//package com.elitesland.yst.production.sale.service;
//
//import cn.hutool.core.collection.CollUtil;
//import cn.hutool.core.lang.Assert;
//import cn.hutool.core.util.StrUtil;
//import com.alibaba.fastjson.JSON;
//import com.elitesland.yst.production.pur.dto.PurPriceBaseDTO;
//import com.elitesland.yst.production.pur.dto.PurPriceBatchParamDTO;
//import com.elitesland.yst.production.pur.dto.PurPriceDetailParamDTO;
//import com.elitesland.yst.production.sale.api.dto.PriceAlterDTO;
//import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
//import com.elitesland.yst.production.sale.api.service.CrmCustService;
//import com.elitesland.yst.production.sale.api.service.PriSalePriceAlterService;
//import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
//import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParamVO;
//import com.elitesland.yst.production.sale.api.vo.param.pri.*;
//import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
//import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPageRespVO;
//import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceAlterDRespVO;
//import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceAlterPageRespVO;
//import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePricePageRespVO;
//import com.elitesland.yst.production.sale.common.constant.ConstantsCache;
//import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
//import com.elitesland.yst.production.sale.common.constant.UdcEnum;
//import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
//import com.elitesland.yst.production.sale.common.model.UserDTO;
//import com.elitesland.yst.production.sale.convert.PriSalePriceAlterConvert;
//import com.elitesland.yst.production.sale.convert.PriSalePriceAlterDConvert;
//import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
//import com.elitesland.yst.production.sale.core.service.UserService;
//import com.elitesland.yst.production.sale.entity.*;
//import com.elitesland.yst.production.sale.event.ItemPriceAlterEvent;
//import com.elitesland.yst.production.sale.event.ItemPriceReduceEvent;
//import com.elitesland.yst.production.sale.repo.PriSalePriceAlterDRepo;
//import com.elitesland.yst.production.sale.repo.PriSalePriceAlterDRepoProc;
//import com.elitesland.yst.production.sale.repo.PriSalePriceAlterRepo;
//import com.elitesland.yst.production.sale.repo.PriSalePriceRepo;
//import com.elitesland.yst.production.sale.rmi.ystpur.RmiPurPriceService;
//import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
//import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
//import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
//import com.elitesland.yst.production.sale.rmi.ystsupport.RmiPriMainPriceService;
//import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
//import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSettingService;
//import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
//import com.elitesland.yst.production.sale.workflow.ProcDefKey;
//import com.elitesland.workflow.ProcessInfo;
//import com.elitesland.workflow.WorkflowConstant;
//import com.elitesland.workflow.WorkflowService;
//import com.elitesland.workflow.enums.ProcInstStatus;
//import com.elitescloud.cloudt.comm.consumer.dto.ComCurrRpcDTO;
//import com.elitescloud.cloudt.comm.consumer.dto.ComTaxRateRpcDTO;
//import com.elitescloud.cloudt.common.annotation.SysCodeProc;
//import com.elitescloud.cloudt.common.base.ApiCode;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.cloudt.common.base.PagingVO;
//import com.elitescloud.boot.exception.BusinessException;
//import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
////import com.elitescloud.cloudt.core.security.util.SecurityUtil;
//import com.elitescloud.cloudt.core.udc.UdcService;
////import com.elitesland.yst.dto.PurPriceBaseDTO;
////import com.elitesland.yst.dto.param.PurPriceBatchParamDTO;
////import com.elitesland.yst.dto.param.PurPriceDetailParamDTO;
//import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
////import com.elitesland.yst.production.support.consumer.pri.dto.PriMainPriceRpcDTO;
//import com.elitesland.yst.production.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
//import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
//import com.elitesland.yst.production.support.provider.item.param.ItmItemBusinessRpcPagingParam;
//import com.elitescloud.cloudt.support.dto.OrgBuRpcDTO;
//import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
//import com.elitescloud.cloudt.system.vo.SysSettingVO;
//import com.elitescloud.cloudt.system.vo.SysUdcComboVO;
//import com.elitescloud.cloudt.system.vo.SysUserVO;
//import com.google.common.collect.Lists;
//import com.querydsl.core.types.ExpressionUtils;
//import com.querydsl.core.types.Predicate;
//import com.querydsl.core.types.Projections;
//import com.querydsl.jpa.impl.JPAQuery;
//import com.querydsl.jpa.impl.JPAUpdateClause;
//import lombok.RequiredArgsConstructor;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.dubbo.config.annotation.DubboReference;
//import org.springframework.cache.annotation.CacheEvict;
//import org.springframework.data.domain.PageRequest;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.TransactionDefinition;
//import org.springframework.transaction.annotation.Transactional;
//import org.springframework.transaction.support.TransactionTemplate;
//import org.springframework.util.CollectionUtils;
//import org.springframework.util.ObjectUtils;
//import org.springframework.util.StringUtils;
//
//import javax.validation.Valid;
//import java.math.BigDecimal;
//import java.math.RoundingMode;
//import java.time.LocalDate;
//import java.time.LocalDateTime;
//import java.time.format.DateTimeFormatter;
//import java.util.*;
//import java.util.stream.Collectors;
//
//import static com.elitesland.yst.production.sale.common.constant.ConstantsSale.DATE_FORMAT;
//
///**
// * @author Eric.li (Li Jia Zhe)
// * @date 2021/5/19 5:24 下午
// */
//@Service
//@RequiredArgsConstructor
//@Slf4j
//@Valid
//public class PriSalePriceAlterServiceImpl extends BaseServiceImpl implements PriSalePriceAlterService {
//
//    private final QPriSalePriceAlterDO qPriSalePriceAlterDO = QPriSalePriceAlterDO.priSalePriceAlterDO;
//    private final QPriSalePriceAlterDDO qPriSalePriceAlterDDO = QPriSalePriceAlterDDO.priSalePriceAlterDDO;
//    private final PriSalePriceAlterRepo priSalePriceAlterRepo;
//    private final PriSalePriceAlterDRepo priSalePriceAlterDRepo;
//    private final PriSalePriceAlterDRepoProc priSalePriceAlterDRepoProc;
//    private final PriSalePriceRepo priSalePriceRepo;
//    private final PriSalePriceService priSalePriceService;
//    private final RmiItemService rmiItemService;
//    private final RmiPriMainPriceService rmiPriMainPriceService;
//    private final CrmCustService crmCustService;
//    private final RmiOrgOuService rmiOrgOuService;
//    private final RmiCommonService rmiComService;
//    private final RmiPurPriceService rmiPurPriceService;
//    private final UserService userService;
//    private final RmiSysNextNumberService numberService;
//    private final TransactionTemplate transactionTemplate;
//    private final RmiOrgBuService rmiOrgBuService;
//
//
//    @DubboReference
//    private WorkflowService workflowService;
//
//    private final ComSaleFileInfoService comSaleFileInfoService;
//    private final RmiSettingService rmiSettingService;
//
//    private Map<String, String> regionMap;
//    private Map<String, String> statusMap;
//    private Map<String, String> uomMap;
//
//    private final Map<String,String> typeMap = new HashMap<>();{
//        typeMap.put(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode(),UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCodeName());
//        typeMap.put(UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode(),UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCodeName());
//        typeMap.put(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode(),UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCodeName());
//        typeMap.put(UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCode(),UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCodeName());
//    }
//
//
//    @Override
//    @SysCodeProc
//    public PagingVO<PriSalePriceAlterPageRespVO> query(PriSalePriceAlterPagingParam param) {
//        List<Long> first = priSalePriceAlterDRepoProc.findPriceAlterIDByIC(param.getItemCode());
//        param.setIdByIC(first!=null && first.size()>0 ? first.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()) : new ArrayList<>());
//        List<Long> second = priSalePriceAlterDRepoProc.findPriceAlterIDByIN(param.getItemName());
//        param.setIdByIN(second!=null && second.size()>0 ? second.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()) : new ArrayList<>());
//
//        var jpaQuery = jpaQueryFactory.select(Projections.bean(PriSalePriceAlterPageRespVO.class,
//                qPriSalePriceAlterDO.id, qPriSalePriceAlterDO.ouId, qPriSalePriceAlterDO.docNo, qPriSalePriceAlterDO.docType,
//                qPriSalePriceAlterDO.docStatus, qPriSalePriceAlterDO.applyDate, qPriSalePriceAlterDO.applyEmpId))
//                .from(qPriSalePriceAlterDO)
//                .where(buildPageSearchCondition(param));
//
//        long total = jpaQuery.fetchCount();
//        if (total == 0) {
//            return PagingVO.<PriSalePriceAlterPageRespVO>builder().build();
//        }
//        var pageRequest = wrapperPageRequest(param.getPageRequest(), null);
//        appendPageAndSort(jpaQuery, pageRequest, qPriSalePriceAlterDO);
//        List<PriSalePriceAlterPageRespVO> pageResult = jpaQuery.fetch();
//
//        // ----------- 反查公司填充公司名称 ------------
//        List<Long> ouIds = pageResult.stream().map(PriSalePriceAlterPageRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<OrgOuRpcDTO> ouRpcResult = rmiOrgOuService.findOuDtoList(ouIds, null);
//        pageResult.forEach(p -> ouRpcResult.stream().filter(ou -> ou.getId().equals(p.getOuId())).findFirst().ifPresent(ou -> p.setOuName(ou.getOuName())));
//
//        // ----------- 根据申请人Id(applyEmpId)回显姓名 ------------
//        List<Long> applyEmpIds = pageResult.stream().map(PriSalePriceAlterPageRespVO::getApplyEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        applyEmpIds.forEach(applyEmpId -> {
//            UserDTO user = userService.getUser(applyEmpId);
//            if (Objects.nonNull(user)) {
//                // 匹配与当遍历的empId相同的记录，并赋值
//                pageResult.stream().filter(r -> r.getApplyEmpId().equals(applyEmpId))
//                        .forEach(emp -> emp.setApplyUserName(user.getFirstName()));
//            }
//        });
//
//        return PagingVO.<PriSalePriceAlterPageRespVO>builder().total(total).records(pageResult).build();
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public ApiResult<Object> saveOrSubmitAlter(PriSalePriceAlterSaveParam param, String operation) {
//        CurrentUserDTO currentUser = UserService.currentUser();
//        if (currentUser == null) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
//        }
//
//
//        // 设置隔离级别
//        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
//        // ----------- 不同价格类型，进行校验特定的参数，校验通过返回已存在的申请单 -----------
//        // 开启事务
//        PriSalePriceAlterDO alterDO = transactionTemplate.execute(transactionStatus ->{
//            try {
//                PriSalePriceAlterDO alterDO1;
//                try {
//                    alterDO1 = checkParam(param);
//                } catch (Exception e) {
//                    throw new BusinessException(e);
//                }
//                // ----------- 申请单存在，更新申请单主表，对于申请单明细进行全删重插操作 -----------
//                if (Objects.nonNull(alterDO1)) {
//                    // 判断单子状态，只有待提交的单子可以进行重新编辑或直接提交
//                    if (!UdcEnum.PRI_APPLY_STATUS_DR.getValueCode().equals(alterDO1.getDocStatus()) && !UdcEnum.PRI_APPLY_STATUS_RJ.getValueCode().equals(alterDO1.getDocStatus())) {
//                        throw new BusinessException("申请单非待提交或非已拒绝状态");
//                    }
//                    alterDO1.setOuId(param.getOuId());
//                    alterDO1.setSaleRegion(param.getSaleRegion());
//                    alterDO1.setCustGroup(param.getCustGroup());
//                    alterDO1.setRemark(param.getRemark());
//                    // 物理删除全部明细
//                    priSalePriceAlterDRepo.deleteAllByMasId(param.getId());
//                } else {
//                    alterDO1 = PriSalePriceAlterConvert.INSTANCE.paramToDo(param);
//                    String docNo = numberService.generateCode("yst-sale","PRI_NO", null);
//                    alterDO1.setDocNo(docNo);
//                    alterDO1.setApplyDate(LocalDateTime.now());
//                    alterDO1.setApplyEmpId(0L);
//                    if (Objects.nonNull(currentUser) && Objects.nonNull(currentUser.getUserId())) {
//                        alterDO1.setApplyEmpId(currentUser.getUserId());
//                    }
//                    alterDO1.setDeleteFlag(0);
//                    alterDO1.setAuditDataVersion(1); // 设置默认版本
//                }
//                // 处理申请单状态，若是提交审批状态也要处理
//                if (ConstantsSale.SAVE_OPERATION.equals(operation)) {
//                    alterDO1.setDocStatus(UdcEnum.PRI_APPLY_STATUS_DR.getValueCode());
//                }
////                else {
////                    if (UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode().equals(alterDO1.getDocType()) || UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode().equals(alterDO1.getDocType())) {
////                        alterDO1.setDocStatus(UdcEnum.PRI_APPLY_STATUS_APPING.getValueCode());
////                        alterDO1.setProcInstStatus(ProcInstStatus.APPROVING);
////                    }
////                }
//                // 权限字段处理
//                alterDO1.setSecOuId(param.getOuId());
//                List<Long> ouIds = new ArrayList<>();
//                String buCode = null;
//                if (!StringUtils.isEmpty(param.getOuId())){
//                    ouIds.add(param.getOuId());
//                    List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
//                    buCode = ouDtoList.get(0).getOuCode();
//                    List<String> buCodes = new ArrayList<>();
//                    buCodes.add(buCode);
//                    List<OrgBuRpcDTO> buDtoList = rmiOrgBuService.findBuDtoList(null, buCodes);
//                    alterDO1.setSecBuId(buDtoList.get(0).getId());
//                }
//                //获取当前登录人(确定修改人信息)
////                GeneralUserDetails user = SecurityContextUtil.currentUser();
////                if (!ObjectUtils.isEmpty(user) && !ObjectUtils.isEmpty(user.getSecurityOrgUserEmpBuDTO())) {
////                    alterDO1.setSecUserId(user.getSecurityOrgUserEmpBuDTO().getEmpId());
////                }
//                PriSalePriceAlterDO save = priSalePriceAlterRepo.save(alterDO1);
//                // 上传附件
////                if (!CollectionUtils.isEmpty(param.getFileComVOS())) {
//                    comSaleFileInfoService.comSaleFileHardSave("PRICE_B", alterDO1.getId(), param.getFileComVOS());
////                }
//                // ----------- 构造明细，并插入数据库 -----------
//                final Long masId = alterDO1.getId();
//                final String saleRegion = alterDO1.getSaleRegion();
//                String finalBuCode = buCode;
//                List<PriSalePriceAlterDDO> alterDDOList = param.getDetails().stream().map(d -> {
//                    // 校验商品是否在经营目录中
//                    if (param.getCatalogueFlag()  == 1 && !param.getDocType().equals(UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCode())){
//                        ItmItemBusinessRpcPagingParam pagingParam = new ItmItemBusinessRpcPagingParam();
//                        List<String> itemCodes = new ArrayList<>();
//                        List<String> buCodes = new ArrayList<>();
//                        itemCodes.add(d.getItemCode());
//                        buCodes.add(finalBuCode);
////                        pagingParam.setItemCodes(itemCodes);
////                        pagingParam.setBuCodes(buCodes);
//                        PagingVO<ItmItemBusinessRpcPagingDTO> itemBusinessRpcDtoByParam = rmiItemService.findItemBusinessRpcDtoByParam(pagingParam);
//                        if (ObjectUtils.isEmpty(itemBusinessRpcDtoByParam.getRecords())){
//                            throw new BusinessException("商品编码为"+d.getItemCode()+"的商品在经营目录上没有维护,请检查");
//                        }
//                    }
//                    PriSalePriceAlterDDO alterDDO = PriSalePriceAlterDConvert.INSTANCE.paramToDo(d);
//                    alterDDO.setMasId(masId);
//                    alterDDO.setCurrCode(StrUtil.isBlank(d.getCurrCode()) ? param.getCurrCode() : d.getCurrCode());
//                    // 内部价
//                    if (TYPE_CROSS.equals(param.getDocType())) {
//                        alterDDO.setPrice(d.getCrossPrice());
//                    } else {
//                        alterDDO.setSaleRegion(StringUtils.isEmpty(param.getSaleRegion()) ? saleRegion : param.getSaleRegion());
//                        if (TYPE_BASE.equals(param.getDocType())) {
//                            alterDDO.setPrice(d.getBasePrice());
//                        } else if (TYPE_CUST.equals(param.getDocType())) {
//                            alterDDO.setPrice(d.getCustPrice());
//                        } else if (TYPE_GROUP.equals(param.getDocType())) {
//                            alterDDO.setCustGroup(param.getCustGroup());
//                            alterDDO.setPrice(d.getCustGroupPrice());
//                        }
//                    }
//                    // 根据用户所填含税价，计算不含税价格，填入netPrice
//                    BigDecimal price = alterDDO.getPrice();
//                    BigDecimal taxRate = alterDDO.getTaxRate();
//                    BigDecimal netPrice = price.divide(taxRate.add(BigDecimal.ONE), 4, RoundingMode.HALF_UP);
//                    BigDecimal promotionPrice = alterDDO.getPromotionPrice();
//                    if (!ObjectUtils.isEmpty(promotionPrice)){
//                        BigDecimal promotionNetPrice = promotionPrice.divide(taxRate.add(BigDecimal.ONE),4,RoundingMode.HALF_UP);
//                        alterDDO.setPromotionNetPrice(promotionNetPrice);
//                    }
//                    alterDDO.setNetPrice(netPrice);
//                    return alterDDO;
//                }).collect(Collectors.toList());
//                priSalePriceAlterDRepo.saveAll(alterDDOList);
//                return alterDO1;
//            }catch (Exception e){
//                // 回滚
//                transactionStatus.setRollbackOnly();
//                throw e;
//            }
//        });
//
//
//        /**
//         * 提交
//         */
//        if (ConstantsSale.SUBMIT_OPERATION.equals(operation)
////                &&
////                (UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode().equals(alterDO.getDocType()) || UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCode().equals(alterDO.getDocType()))//只有这2个类型求流程
//        ) {
//            /************************************************************************
//             *                              工作流开始                                *
//             ************************************************************************/
//
//            if (StringUtils.isEmpty(param.getId())                                                                    //1,新对象
//                    || StringUtils.isEmpty(alterDO.getProcInstId())                                                   //2,旧单子，未起过工作流
//                    || WorkflowConstant.CAN_START_PROC_STATUSES.contains(alterDO.getProcInstStatus())    //3,旧单子，可以起工作流
//            ) {
//                /**
//                 * 为什么要加上面3个判断，是因为流程已经启动了,就没必要再启动流程(场景:在'审批中'的过程中，做保存操作)
//                 * 工作流规则:
//                 *  1,一个业务单据在一个流程没结束前是不能再起的同一个工作流
//                 *  2,一个业务单据可以同时有2个"不同类型"的流程再跑
//                 */
//                //启动流程
//                String procInstName = null;//流程实例名称
//                ProcDefKey procDefKey = null;//流程
//                if (UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode().equals(alterDO.getDocType()) ||
//                        UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode().equals(alterDO.getDocType()) ||
//                        UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode().equals(alterDO.getDocType())) {
//                    procInstName = "B端对外销售价格申请单";//这里可以自定义
//                    procDefKey = ProcDefKey.B2B_OUT_SALE_PRICE;
//                } else if (UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCode().equals(alterDO.getDocType())) {
//                    procInstName = "B端内部结算价申请单";//这里可以自定义
//                    procDefKey = ProcDefKey.B2B_IN_SETTLE_PRICE;
//                } else {
//                    throw new BusinessException("不应该走到这个流程，请开发检查");
//                }
////                String procInstId = workflowService.startProcess(procDefKey.name(), procInstName, alterDO.getId() + "", null, "1", currentUser.getUserId() + "");
//                ProcessInfo processInfo = workflowService.startProcess(procDefKey.name(),procInstName+"-"+alterDO.getDocNo(),alterDO.getId() + "",null);
//                if(ObjectUtils.isEmpty(processInfo)){
//                    throw new BusinessException("工作流启动服务失败,请检查");
//                }
//                //修改业务审批数据
//                QPriSalePriceAlterDO qPriSalePriceAlterDO = QPriSalePriceAlterDO.priSalePriceAlterDO;
//                JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qPriSalePriceAlterDO)
//                        .set(qPriSalePriceAlterDO.procInstId, processInfo.getProcInstId())//流程实例id
////                        .set(qPriSalePriceAlterDO.procInstStatus, ProcInstStatus.APPROVING)//审批状态
//                        .set(qPriSalePriceAlterDO.submitTime, LocalDateTime.now())//提交实际那
////                        .set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_APPING.getValueCode())//单据状态
//                        .where(qPriSalePriceAlterDO.id.eq(alterDO.getId()));
//                if (!Objects.equals(processInfo.getProcInstStatus(),ProcInstStatus.APPROVED)){
//                    jpaUpdateClause.set(qPriSalePriceAlterDO.procInstStatus,ProcInstStatus.APPROVING);
//                    jpaUpdateClause.set(qPriSalePriceAlterDO.docStatus,UdcEnum.PRI_APPLY_STATUS_APPING.getValueCode());
//                }
//                jpaUpdateClause.execute();
//            }
//
//            /************************************************************************
//             *                              工作流结束                                *
//             ************************************************************************/
//        }
//
//        return ApiResult.ok(alterDO.getId());
//    }
//
//    /**
//     * 不同类型申请单特定参数校验，并返回已存在申请单
//     */
//    private PriSalePriceAlterDO checkParam(PriSalePriceAlterSaveParam param) {
//        Assert.isFalse(CollUtil.isEmpty(param.getDetails()), "申请单明细不得为空");
//        if (TYPE_GROUP.equals(param.getDocType())) {
//            Assert.notBlank(param.getCustGroup(), "客户等级不得为空");
//        }
//        for (PriSalePriceAlterDSaveParam detail : param.getDetails()) {
//            Assert.isFalse(Objects.isNull(detail.getValidFrom()) ||
//                    Objects.isNull(detail.getValidTo()), "明细行中[生效时间]和[失效时间]都不得为空");
//            Assert.isFalse(detail.getValidFrom().isAfter(detail.getValidTo()), "明细行中[生效时间]不得晚于[失效时间]");
//            if (TYPE_BASE.equals(param.getDocType())) {
//                Assert.notNull(detail.getBasePrice(), "明细行中[基础价]不得为空");
//                if (!ObjectUtils.isEmpty(detail.getPromotionPrice()) && detail.getPromotionPrice().compareTo(BigDecimal.ZERO) > 0){
//                    Assert.notNull(detail.getPromDateF(),"活动价格大于0的情况下,明细行中[活动价起始时间]不得为空");
//                    Assert.notNull(detail.getPromDateT(),"活动价格大于0的情况下,明细行中[活动价结束时间]不得为空");
//                }
//            } else if (TYPE_CUST.equals(param.getDocType())) {
//                Assert.notNull(detail.getCustCode(), "明细行中[客户编码]不得为空");
//                Assert.notNull(detail.getCustPrice(), "明细行中[客户含税价]不得为空");
//            } else if (TYPE_GROUP.equals(param.getDocType())) {
//                Assert.notNull(detail.getCustGroupPrice(), "明细行中[客户等级含税价格]不得为空");
//            } else {
//                Assert.notNull(detail.getCrossPrice(), "明细行中[内部结算价]不得为空");
//                if (!ObjectUtils.isEmpty(detail.getPromotionPrice()) && detail.getPromotionPrice().compareTo(BigDecimal.ZERO) > 0){
//                    Assert.notNull(detail.getPromDateF(),"政策价格大于0的情况下,明细行中[政策价起始时间]不得为空");
//                    Assert.notNull(detail.getPromDateT(),"政策价格大于0的情况下,明细行中[政策价结束时间]不得为空");
//                }
//            }
//        }
//        // 查询申请单
//        Long id = Objects.isNull(param.getId()) ? 0L : param.getId();
//        Optional<PriSalePriceAlterDO> alterOptional = priSalePriceAlterRepo.findById(id);
//        return alterOptional.orElse(null);
//    }
//
//    @Override
//    @SysCodeProc
//    public List<PriSalePriceAlterDRespVO> parseImportData(PriSalePriceImportParam param, List<PriSalePriceAlterDRespVO> importData) {
//        // 查看系统是否使用经营目录
//        SysSettingVO settingByCode = rmiSettingService.findSettingByCode("ENABLE_BUSIDIC");
//
//        // 查询公司信息
//        List<Long> ouIds = new ArrayList<>();
//        ouIds.add(param.getOuId());
//        List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
//
//        String docType = param.getDocType();
//        // 校验数据完整性
//        checkImportData(docType, importData);
//
//        // ----------- 反查商品明细、商品价格、币种、税率 -----------
//        // 商品集合
//        List<String> itemCodes = importData.stream().map(PriSalePriceAlterDRespVO::getItemCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//        List<ItmItemRpcDTO> itemRpcResult = rmiItemService.findItemList(null, itemCodes);
//   //     List<PriMainPriceRpcDTO> priceRpcResult = rmiPriMainPriceService.findMainPriceDtoList(null, itemCodes);
//
//        // 币种集合
//        List<String> currCodes = importData.stream().map(PriSalePriceAlterDRespVO::getCurrCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//        if (StrUtil.isNotBlank(param.getCurrCode()) && !currCodes.contains(param.getCurrCode())) {
//            currCodes.add(param.getCurrCode());
//        }
//        List<ComCurrRpcDTO> currRpcResult = rmiComService.findCurrDtoList(currCodes);
//        // 税率编码集合
//        List<String> taxRateNos = importData.stream().map(PriSalePriceAlterDRespVO::getTaxRateNo).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//        List<ComTaxRateRpcDTO> taxRateRpcResult = rmiComService.findTaxRateList(taxRateNos);
//
//        // 校验数据正确性，并填充部分值
//        importData = checkImportDataCorrectness(itemRpcResult, currRpcResult, taxRateRpcResult, docType, importData);
//
//        // 获取采购价
//        PurPriceBatchParamDTO purPriceParam = new PurPriceBatchParamDTO();
//        purPriceParam.setOuId(param.getOuId());
//        purPriceParam.setValidDate(LocalDate.now());
//        List<PurPriceDetailParamDTO> collect = importData.stream().map(vi -> {
//            PurPriceDetailParamDTO detail = new PurPriceDetailParamDTO();
//            detail.setItemId(vi.getItemId());
//            detail.setUom(vi.getUom());
//            detail.setCurrCode(vi.getCurrCode());
//            return detail;
//        }).collect(Collectors.toList());
//        purPriceParam.setPurPriceDetailParamDtoList(collect);
//        List<PurPriceBaseDTO> purPriRpcResult = rmiPurPriceService.getPriceListByParam(purPriceParam);
//
//        // 经过数据正确性校验itemRpcResult一定不为空
//        importData.forEach(d -> {
//            // 由于导入使用的是不带时分秒的时间，所以需要转换一下生效时间和失效时间
//            d.setValidFrom(Objects.isNull(d.getValidFromDate()) ? null : d.getValidFromDate().atStartOfDay());
//            d.setValidTo(Objects.isNull(d.getValidToDate()) ? null : d.getValidToDate().atStartOfDay());
//            d.setPromDateF(Objects.isNull(d.getPromFromDate()) ? null : d.getPromFromDate().atStartOfDay());
//            d.setPromDateT(Objects.isNull(d.getPromToDate()) ? null : d.getPromToDate().atStartOfDay());
//            // 处理币种
//            d.setCurrCode((StrUtil.isBlank(d.getCurrCode()) ? param.getCurrCode() : d.getCurrCode()));
//            currRpcResult.stream().filter(curr -> StrUtil.isNotBlank(d.getCurrCode()) && d.getCurrCode().equals(curr.getCurrCode()))
//                    .findFirst().ifPresent(c -> d.setCurrName(c.getCurrName()));
//
//            purPriRpcResult.stream().filter(p -> p.getItemId().equals(d.getItemId())
//                    && p.getCurrCode().equals(d.getCurrCode())
//                    && p.getToUom().equals(d.getUom()))
//                    .findFirst().ifPresent(pri -> d.setFloorPrice(pri.getPrice()));
//
//            // 回填商品价格
////            priceRpcResult.stream().filter(price -> d.getItemId().equals(price.getItemId())).findFirst().ifPresent(p -> {
////                d.setMarketPrice(p.getPrice1());
////                d.setGuidePrice(p.getPrice2());
////                // 根据采购价计算销售底价：销售底价 = 采购价 /（1 - 毛利控制率） price4
////                if (Objects.nonNull(p.getPrice4()) && Objects.nonNull(d.getFloorPrice())) {
////                    d.setFloorPrice(d.getFloorPrice().divide(BigDecimal.ONE.subtract(p.getPrice4()), 4, RoundingMode.HALF_UP));
////                } else {
////                    d.setFloorPrice(null);
////                }
////            });
//
//            // 非内部结算价，需要填充税率（可能存在填写的税率码正确，但是税率不正确的情况，不按Excel中填写的税率）
//            Optional<ComTaxRateRpcDTO> taxRateRpcDTO = taxRateRpcResult.stream().filter(taxRate -> StrUtil.isNotBlank(d.getTaxRateNo()) && d.getTaxRateNo().equals(taxRate.getTaxRateNo())).findFirst();
//            if (taxRateRpcDTO.isPresent()){
//                // 如果导入模板中有且存在所有种类的价格，相关的税率和税率编码都取模板中的数据
//                ComTaxRateRpcDTO comTaxRateRpcDTO = taxRateRpcDTO.get();
//                d.setTaxRate(BigDecimal.valueOf(comTaxRateRpcDTO.getTaxRateValue()));
//                d.setTaxRateDesc(comTaxRateRpcDTO.getTaxRateDesc());
//            }else if (settingByCode.getSettingVal().equals("1")){
//               // 如果是启用经营目录
//                // 1.如果是非内部结算价,从经营目录获取税率,经营目录不存在则报错
//                // 2.如果是内部结算价,从商品主档获取其的销项税率
//                if (!TYPE_CROSS.equals(docType)){
//                    Assert.isFalse(CollectionUtils.isEmpty(ouDtoList), "公司id为"+param.getOuId()+"在我方数据库未找到,请检查");
//                    ItmItemBusinessRpcPagingParam pagingParam = new ItmItemBusinessRpcPagingParam();
//                    List<String> itemCodess = new ArrayList<>();
//                    List<String> buCodes = new ArrayList<>();
//                    itemCodess.add(d.getItemCode());
//                    buCodes.add(ouDtoList.get(0).getOuCode());
////                    pagingParam.setItemCodes(itemCodess);
////                    pagingParam.setBuCodes(buCodes);
//                    PagingVO<ItmItemBusinessRpcPagingDTO> itemBusinessRpcDtoByParam = rmiItemService.findItemBusinessRpcDtoByParam(pagingParam);
//                    if (ObjectUtils.isEmpty(itemBusinessRpcDtoByParam.getRecords())){
//                        throw new BusinessException("商品编码为"+d.getItemCode()+"的商品在经营目录上没有维护,请检查");
//                    }
//                    d.setTaxRate(itemBusinessRpcDtoByParam.getRecords().get(0).getTaxRate());
//                }else{
//                    itemRpcResult.stream().filter(item -> item.getId().equals(d.getItemId())).findFirst().ifPresent(itm ->{
//                        d.setTaxRate(itm.getTaxRate2());
//                    });
//                }
//
//            }else{
//                // 如果没有启动经营目录,全部冲商品表查商品主档的销项税率
//                itemRpcResult.stream().filter(item -> item.getId().equals(d.getItemId())).findFirst().ifPresent(itm ->{
//                    d.setTaxRate(itm.getTaxRate2());
//                });
//            }
//        });
//
//        // 通过税率反查税率信息
//        List<BigDecimal> taxRates = importData.stream().map(PriSalePriceAlterDRespVO::getTaxRate).distinct().filter(Objects::nonNull).collect(Collectors.toList());
//        List<ComTaxRateRpcDTO> taxCodeList = rmiComService.findTaxCodeList(taxRates);
//        importData.forEach(i -> {
//            taxCodeList.stream().filter(tax -> i.getTaxRate().compareTo(BigDecimal.valueOf(tax.getTaxRateValue())) == 0)
//                    .findFirst().ifPresent(taxCode -> {
//                        i.setTaxRateNo(taxCode.getTaxRateNo());
//                        i.setTaxRateDesc(taxCode.getTaxRateDesc());
//            });
//        });
//
//
//        // 导入客户价或内部结算价（客户编码不为空时）需要反查客户信息
//        if (StrUtil.equalsAny(docType, TYPE_CUST, TYPE_CROSS)) {
//            List<String> custCodes = importData.stream().map(PriSalePriceAlterDRespVO::getCustCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//            List<CrmCustPageRespVO> custList = this.queryCrmCustList(custCodes);
//            importData.forEach(d -> custList.stream()
//                    .filter(cust -> cust.getCustCode().equals(d.getCustCode()))
//                    .findFirst().ifPresent(c -> {
//                        d.setCustId(c.getId());
//                        d.setCustCode(c.getCustCode());
//                        d.setCustName(c.getCustName());
//                    }));
//        }
//        // 非【内部结算价和基础价】需要查询已存在的价格，并循环填入要导入的数据中
//        if (!TYPE_CROSS.equals(param.getDocType()) && !TYPE_BASE.equals(param.getDocType())) {
//            List<Long> itemIds = importData.stream().map(PriSalePriceAlterDRespVO::getItemId).distinct().collect(Collectors.toList());
//            List<PriSalePricePageRespVO> existPriceList = priSalePriceService.queryExistPrice(param.getOuId(), null, null, itemIds, null);
//            for (PriSalePriceAlterDRespVO data : importData) {
//                // 构造基础价格
//                data.setBasePrice(BigDecimal.ZERO);
//                existPriceList.stream().filter(p -> TYPE_BASE.equals(p.getPriceType())
//                        && data.getItemId().equals(p.getItemId()))
//                        .findFirst().ifPresent(bp -> data.setBasePrice(bp.getPrice()));
//                // 若为客户价
//                if (TYPE_CUST.equals(docType)) {
//                    // 并且拼接客户等级
//                    existPriceList.stream().filter(p -> TYPE_GROUP.equals(p.getPriceType())
//                            && data.getCustLevel().equals(p.getCustGroup())
//                            && data.getItemId().equals(p.getItemId()))
//                            .findFirst().ifPresent(gp -> data.setCustGroupPrice(gp.getPrice()));
//                }
//            }
//        }
//        return importData;
//    }
//
//    /**
//     * 校验导入数据完整性
//     */
//    private void checkImportData(String docType, List<PriSalePriceAlterDRespVO> importData) {
//        // 校验是否有重复明细
//        for (PriSalePriceAlterDRespVO data : importData) {
//            Assert.notBlank(data.getItemCode(), "导入明细行中[商品编码]不得为空");
//            Assert.notBlank(data.getCurrCode(), "导入明细行中[货币码]不得为空");
//            if (Objects.nonNull(data.getValidFromDate()) && Objects.nonNull(data.getValidToDate())) {
//                Assert.isFalse(data.getValidFromDate().isAfter(data.getValidToDate()), "导入明细行中[生效时间]不得晚于[失效时间]");
//            }
////            Assert.notBlank(data.getTaxRateNo(), "导入明细行中[税率编码]不得为空");
//            if (TYPE_BASE.equals(docType)) {
//                Assert.notBlank(data.getPrice(), "导入明细行中[基础价]不得为空");
//                if (!ObjectUtils.isEmpty(data.getPromotionPrice()) && data.getPromotionPrice().compareTo(BigDecimal.ZERO) > 0){
//                    Assert.notNull(data.getPromFromDate(), "活动价大于0,导入明细行中[活动价开始时间]不得为空");
//                    Assert.notNull(data.getPromToDate(), "活动价大于0,导入明细行中[活动价结束时间]不得为空");
//                }
//            } else if (TYPE_CUST.equals(docType)) {
//                Assert.notBlank(data.getCustCode(), "明细行中[客户编码]不得为空");
//                Assert.notBlank(data.getPrice(), "明细行中[客户含税价]不得为空");
//            } else if (TYPE_GROUP.equals(docType)) {
//                Assert.notBlank(data.getPrice(), "明细行中[客户等级含税价格]不得为空");
//            } else if (TYPE_CROSS.equals(docType)) {
//                Assert.notBlank(data.getPrice(), "明细行中[内部结算价]不得为空");
//                Assert.isFalse(StrUtil.isAllNotBlank(data.getSaleRegion(), data.getCustCode()), "明细行中[区域]或[客户编码]只能填写一项");
//                if (!ObjectUtils.isEmpty(data.getPromotionPrice()) && data.getPromotionPrice().compareTo(BigDecimal.ZERO) > 0){
//                    Assert.notNull(data.getPromFromDate(), "政策价大于0,导入明细行中[政策价开始时间]不得为空");
//                    Assert.notNull(data.getPromToDate(), "政策价大于0,导入明细行中[政策价结束时间]不得为空");
//                }
//            }
//        }
//        Map<String, List<PriSalePriceAlterDRespVO>> groupData = importData.stream().collect(Collectors.groupingBy(PriSalePriceAlterDRespVO::getItemCode));
//        if (TYPE_CUST.equals(docType)) {
//            groupData = importData.stream().collect(Collectors.groupingBy(d -> d.getItemCode() + "-" + d.getCustCode()));
//        } else if (TYPE_GROUP.equals(docType)) {
//            groupData = importData.stream().collect(Collectors.groupingBy(d -> d.getItemCode() + "-" + d.getSaleRegion()));
//        } else if (TYPE_CROSS.equals(docType)) {
//            groupData = importData.stream().collect(Collectors.groupingBy(d -> d.getItemCode() + "-" + d.getSaleRegion() + "-" + d.getCustCode()));
//        }
//        for (String key : groupData.keySet()) {
//            Assert.isFalse((groupData.get(key).size() > 1), "导入明细行中存在重复数据，请检查数据");
//        }
//    }
//
//    /**
//     * 校验导入数据正确性
//     */
//    private List<PriSalePriceAlterDRespVO> checkImportDataCorrectness(List<ItmItemRpcDTO> itemRpcResult, List<ComCurrRpcDTO> currRpcResult,
//                                                                      List<ComTaxRateRpcDTO> taxRateRpcResult, String docType, List<PriSalePriceAlterDRespVO> parseData) {
//        List<SysUdcComboVO> salRegions = null;
//        List<CrmCustPageRespVO> crmCustResult = new ArrayList<>(0);
//
//        // 内部结算价需要校验【区域】是否正确
//        if (TYPE_CROSS.equals(docType)) {
//            salRegions = sysUdcService.listCodeCombos("ORG", "OU_REGION");
//        }
//        // 客户价和内部价需要校验【客户】是否正确
//        if (StrUtil.equalsAny(docType, TYPE_CUST, TYPE_CROSS)) {
//            List<String> custCodes = parseData.stream().map(PriSalePriceAlterDRespVO::getCustCode)
//                    .filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//            crmCustResult = this.queryCrmCustList(custCodes);
//        }
//        // 校验单位是否正确
//        List<SysUdcComboVO> uomRpcResult = sysUdcService.listCodeCombos("COM", "UOM");
//
//        // 循环开始依次校验，同时补充部分值，减少循环操作次数
//        for (PriSalePriceAlterDRespVO data : parseData) {
//            // 校验商品是否存在
//            ItmItemRpcDTO itemTemp = itemRpcResult.stream().filter(item -> item.getItemCode().equals(data.getItemCode()))
//                    .findFirst().orElseThrow(new BusinessException("商品[" + data.getItemCode() + "]不存在，请检查"));
//
//            // 若用户填写了单位，则校验单位，不填则不进行校验
//            if (StrUtil.isNotBlank(data.getUomName())) {
//                var uomTemp = uomRpcResult.stream().filter(uom -> uom.getValDesc().equals(data.getUomName())).findFirst()
//                        .orElseThrow(new BusinessException("销售单位[" + data.getUomName() + "]不存在，请检查"));
//                // 若不是内部结算价，则校验销售计量单位，内部结算价校验采购计量单位
//                if (!docType.equals(TYPE_CROSS)) {
//                    if (!itemTemp.getUom().equals(uomTemp.getUdcVal())) {
//                        throw new BusinessException("商品[" + data.getItemCode() + "]计量单位[" + data.getUomName() + "]与商品销售计量单位不一致，请检查");
//                    }
//                } else {
//                    if (!itemTemp.getPurcUom().equals(uomTemp.getUdcVal())) {
//                        throw new BusinessException("商品[" + data.getItemCode() + "]计量单位[" + data.getUomName() + "]与商品采购计量单位不一致，请检查");
//                    }
//                }
//            }
//
//            // 校验填写的价格是否为数字
//            try {
//                var price = new BigDecimal(data.getPrice());
//                if (TYPE_BASE.equals(docType)) {
//                    data.setBasePrice(price);
//                } else if (TYPE_CUST.equals(docType)) {
//                    data.setCustPrice(price);
//                } else if (TYPE_GROUP.equals(docType)) {
//                    data.setCustGroupPrice(price);
//                } else {
//                    data.setCrossPrice(price);
//                }
//            } catch (Exception e) {
//                throw new BusinessException("商品[" + data.getItemCode() + "]价格填写格式错误，请检查");
//            }
//
//            // 校验币种
//            if (StrUtil.isNotBlank(data.getCurrCode())) {
//                currRpcResult.stream().filter(curr -> data.getCurrCode().equals(curr.getCurrCode()))
//                        .findFirst().orElseThrow(new BusinessException("货币码[" + data.getCurrCode() + "]不存在，请检查"));
//            }
//            // 校验税率码
//            if (StrUtil.isNotBlank(data.getTaxRateNo())) {
//                taxRateRpcResult.stream().filter(taxRate -> data.getTaxRateNo().equals(taxRate.getTaxRateNo()))
//                        .findFirst().orElseThrow(new BusinessException("税率码[" + data.getTaxRateNo() + "]不存在，请检查"));
//            }
//
//            // 客户价格\内部结算价 - 校验客户是否存在
//            if (StrUtil.equalsAny(docType, TYPE_CUST, TYPE_CROSS) && StrUtil.isNotBlank(data.getCustCode())) {
//                CrmCustPageRespVO crmCust = crmCustResult.stream()
//                        .filter(cust -> data.getCustCode().equals(cust.getCustCode()))
//                        .findFirst().orElseThrow(new BusinessException("客户[" + data.getCustCode() + "]不存在，请检查"));
//                if (crmCust.getCustStatus().equals(UdcEnum.CRM_CUST_STATUS_CLOSED.getValueCode())) {
//                    throw new BusinessException("客户[" + data.getCustCode() + "]为禁用状态，请检查");
//                }
//                data.setCustId(crmCust.getId());
//                data.setCustName(crmCust.getCustName());
//                data.setCustLevel(crmCust.getCustLevel());
//            }
//
//            // 内部结算价 - 若填写了区域，则需要校验是否存在
//            if (TYPE_CROSS.equals(docType) && StrUtil.isNotBlank(data.getSaleRegionName())) {
//                SysUdcComboVO ouRegion = salRegions.stream().filter(region -> data.getSaleRegionName().equals(region.getValDesc()))
//                        .findFirst().orElseThrow(new BusinessException("区域[" + data.getSaleRegionName() + "]不存在，请检查"));
//                data.setSaleRegion(ouRegion.getUdcVal());
//            }
//
//            // 补充商品相关值
//            data.setItemId(itemTemp.getId());
//            data.setBarcode(itemTemp.getBarCode());
//            data.setItemName(itemTemp.getItemName());
//            data.setItemSpec(itemTemp.getSpec());
//            data.setItemCateCode(itemTemp.getItemCateCode());
//            data.setItemCatePath(buildItemCatePath(itemTemp.getItemCatePathName()));
//            // 若用户在Excel中没有填写UOM，则返回商品中的
//            if (StrUtil.isBlank(data.getUom())) {
//                data.setUom(itemTemp.getUom());
//                if (TYPE_CROSS.equals(docType)) {
//                    data.setUom(itemTemp.getPurcUom());
//                }
//            }
//            if (TYPE_CROSS.equals(docType)) {
//                data.setTaxRateNo(itemTemp.getTaxCode2());
//                data.setTaxRate(itemTemp.getTaxRate2());
//            }
//        }
//        return parseData;
//    }
//
//    private String buildItemCatePath(List<String> itemCatePath) {
//        if (CollUtil.isNotEmpty(itemCatePath)) {
//            StringJoiner stringJoiner = new StringJoiner("/");
//            itemCatePath.forEach(p -> stringJoiner.add(p));
//            return stringJoiner.toString();
//        }
//        return null;
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    @CacheEvict(value = ConstantsCache.CUST_PRICE, key = "'all'", condition = "#result.success")
//    public ApiResult<Object> approveAlter(PriSalePriceApproveParam param) {
//        Long id = param.getDocId();
//        // 校验申请单是否存在，且状态是否为草稿状态
//        Optional<PriSalePriceAlterDO> alterOptional = priSalePriceAlterRepo.findById(id);
//        if (!alterOptional.isPresent()) {
//            return ApiResult.fail("申请单不存在");
//        }
//        PriSalePriceAlterDO alterDO = alterOptional.get();
//        String apprStatus = param.getApprStatus();
////        String docStatus  = null;
////        Integer sourceVersion = alterDO.getAuditDataVersion();
////        Long apprUserId = 0L;
////        if (UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode().equals(alterDO.getDocType()) || UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode().equals(alterDO.getDocType())) {
////            if (!alterDO.getDocStatus().equals(UdcEnum.PRI_APPLY_STATUS_APPING.getValueCode())) {
////                return ApiResult.fail("该申请单非待审核状态");
////            }
////            CurrentUserDTO currentUser = UserService.currentUser();
////            if (Objects.nonNull(currentUser) && Objects.nonNull(currentUser.getUserId())) {
////                apprUserId = currentUser.getDetail().getId();
////            }
////            docStatus = UdcEnum.PRI_APPLY_STATUS_CF.getValueCode();
////            sourceVersion = Objects.isNull(alterDO.getAuditDataVersion()) ? Integer.valueOf(0) : alterDO.getAuditDataVersion();
////        }
//
//        // 审批通过
//        if (UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode().equals(apprStatus)) {
//            // 将申请单明细数据同步到价格主表（存在相同的进行合并）
//            List<PriSalePriceAlterDDO> details = priSalePriceAlterDRepoProc.getDetailsByMasId(id);
//            log.info("价格审批通过时转价格表数据{}", JSON.toJSONString(details));
//            if (!CollectionUtils.isEmpty(details)) {
//                Long ouId = alterDO.getOuId();  // 公司
//                List<Long> custIds = details.stream().map(PriSalePriceAlterDDO::getCustId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//                String custGroup = alterDO.getCustGroup();
//                String docType = alterDO.getDocType(); // 价格类型
//                List<Long> itemIds = details.stream().map(PriSalePriceAlterDDO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//                // 查询符合条件已经存在的价格
//                List<PriSalePricePageRespVO> existPrices = priSalePriceService.queryExistPrice(ouId, custIds, custGroup, itemIds, docType);
//
//                List<PriceAlterDTO> priceAlterDTOS = new ArrayList<>();
//
//                // 构造最新价格数据
//                List<PriSalePriceDO> priSalePriceDOS = details.stream().map(alterD -> {
//                    var priSalePriceDO = new PriSalePriceDO();
//                    priSalePriceDO.setOuId(ouId);
//                    priSalePriceDO.setPriceType(docType);
//                    priSalePriceDO.setBarcode(alterD.getBarcode());
//                    priSalePriceDO.setItemCode(alterD.getItemCode());
//                    priSalePriceDO.setItemId(alterD.getItemId());
//                    priSalePriceDO.setItemCateCode(alterD.getItemCateCode());
//                    priSalePriceDO.setItemCatePath(alterD.getItemCatePath());
//                    priSalePriceDO.setCustId(alterD.getCustId());
//                    priSalePriceDO.setCustGroup(alterD.getCustGroup());
//                    priSalePriceDO.setValidFrom(alterD.getValidFrom());
//                    priSalePriceDO.setValidTo(alterD.getValidTo());
//                    priSalePriceDO.setRemark(alterDO.getRemark());
//                    priSalePriceDO.setSaleRegion(alterD.getSaleRegion());
//                    priSalePriceDO.setUom(alterD.getUom());
//                    priSalePriceDO.setTaxRate(alterD.getTaxRate());
//                    priSalePriceDO.setTaxRateNo(alterD.getTaxRateNo());
//                    priSalePriceDO.setPrice(alterD.getPrice());
//                    priSalePriceDO.setNetPrice(alterD.getNetPrice());
//                    priSalePriceDO.setCurrCode(alterD.getCurrCode());
//                    priSalePriceDO.setCreator(alterD.getCreator());
//                    priSalePriceDO.setCreateUserId(alterD.getCreateUserId());
//                    priSalePriceDO.setModifyUserId(alterD.getModifyUserId());
//                    priSalePriceDO.setUpdater(alterD.getUpdater());
//                    //活动价字段
//                    priSalePriceDO.setPromotionPrice(alterD.getPromotionPrice());
//                    priSalePriceDO.setPromDateF(alterD.getPromDateF());
//                    priSalePriceDO.setPromDateT(alterD.getPromDateT());
//                    priSalePriceDO.setPromotionNetPrice(alterD.getPromotionNetPrice());
//                    //权限字段
//                    priSalePriceDO.setSecOuId(alterDO.getSecOuId());
//                    priSalePriceDO.setSecUserId(alterDO.getSecUserId());
//                    priSalePriceDO.setSecBuId(alterDO.getSecBuId());
//                    priSalePriceDO.setPriceStatus(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode());  // 默认写死，价格状态
//
//                    Optional<PriSalePricePageRespVO> priceOptional = existPrices.stream().filter(ep -> ep.getItemId().equals(alterD.getItemId())).findFirst();
//                    // 内部结算价存在三种情况：saleRegion和custId都无值、saleRegion有值custId无值、saleRegion无值custId有值
//                    if (TYPE_CROSS.equals(docType)) {
//                        if (StrUtil.isNotBlank(alterD.getSaleRegion())) {
//                            priceOptional = existPrices.stream().filter(ep -> ep.getItemId().equals(alterD.getItemId()) &&
//                                    alterD.getSaleRegion().equals(ep.getSaleRegion())).findFirst();
//                        } else if (Objects.nonNull(alterD.getCustId())) {
//                            priceOptional = existPrices.stream().filter(ep -> ep.getItemId().equals(alterD.getItemId()) &&
//                                    alterD.getCustId().equals(ep.getCustId())).findFirst();
//                        } else {
//                            priceOptional = existPrices.stream().filter(ep -> ep.getItemId().equals(alterD.getItemId()) &&
//                                    Objects.isNull(ep.getCustId()) && StrUtil.isBlank(ep.getSaleRegion())).findFirst();
//                        }
//                    }
//
//                    priceOptional.ifPresent(p -> {
//                        priSalePriceDO.setId(p.getId());
//                        priSalePriceDO.setCreator(p.getCreator());
//                        priSalePriceDO.setCreateTime(p.getCreateTime());
//                        priSalePriceDO.setCreateUserId(p.getCreateUserId());
//
//                        // 只发送基础价和等级价降价事件
//                        if (priSalePriceDO.getPrice().compareTo(p.getPrice())<0){
//                            if (TYPE_BASE.equals(priSalePriceDO.getPriceType())||TYPE_GROUP.equals(priSalePriceDO.getPriceType())){
//                                log.info("发送的降价事件："+JSON.toJSONString(priSalePriceDO));
//                                publishEventSync(new ItemPriceReduceEvent(this,
//                                        priSalePriceDO.getItemCode(),
//                                        priSalePriceDO.getPrice(),
//                                        priSalePriceDO.getPriceType(),
//                                        priSalePriceDO.getCustGroup()));
//                            }
//                        }
//                    });
//
//                    if (TYPE_BASE.equals(priSalePriceDO.getPriceType())){
//                        // 改sku价格
//                        PriceAlterDTO alterDTO = PriceAlterDTO.builder()
//                                .ouId(priSalePriceDO.getOuId())
//                                .price(priSalePriceDO.getPrice())
//                                .skuCode(priSalePriceDO.getItemCode())
//                                .build();
//
//                        priceAlterDTOS.add(alterDTO);
//                    }
//
//
//                    return priSalePriceDO;
//                }).collect(Collectors.toList());
//                // 保存数据
//                log.info("价格审批通过时转价格表保存数据{}", JSON.toJSONString(priSalePriceDOS));
//                priSalePriceRepo.saveAll(priSalePriceDOS);
//
//                if (priceAlterDTOS.size()>0){
//                    log.info("发送价格变更事件：{}", JSON.toJSONString(priceAlterDTOS));
//                    publishEventSync(new ItemPriceAlterEvent(this, priceAlterDTOS));
//                }
//
//                List<Long> ids = priSalePriceDOS.stream().map(PriSalePriceDO::getId).distinct().collect(Collectors.toList());
//                if (!CollectionUtils.isEmpty(details))
//                {
//                    priSalePriceRepo.updatePriSalePriceUpdater(details.get(0).getModifyUserId(),details.get(0).getUpdater(),ids);
//                }
//            }
//        }
////        if (UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode().equals(alterDO.getDocType()) || UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode().equals(alterDO.getDocType())) {
////            // 审批拒绝，修改订单状态，其他什么都不做
////            if (UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode().equals(apprStatus)) {
////                docStatus = UdcEnum.PRI_APPLY_STATUS_RJ.getValueCode();
////            }
////            // 使用版本号作为更新条件，控制并发
////            int updateCount = priSalePriceAlterRepo.updateByIdAndVersion(id, sourceVersion, sourceVersion + 1,
////                    docStatus, LocalDateTime.now(), apprUserId);
////            if (updateCount < 1) {
////                throw new BusinessException("该申请单已执行过审批操作，请刷新数据");
////            }
////        }
//        return ApiResult.ok();
//    }
//
//    @Override
//    @SysCodeProc
//    public PriSalePriceAlterSaveParam alterDetail(Long id) {
//        Optional<PriSalePriceAlterDO> alterOptional = priSalePriceAlterRepo.findById(id);
//        if (!alterOptional.isPresent()) {
//            throw new BusinessException("申请单不存在");
//        }
//        PriSalePriceAlterDO alterDO = alterOptional.get();
//        String docType = alterDO.getDocType();
//        PriSalePriceAlterSaveParam alter = PriSalePriceAlterConvert.INSTANCE.doToParam(alterDO);
//        List<PriSalePriceAlterDDO> alterDDOS = priSalePriceAlterDRepoProc.getDetailsByMasId(id); // 申请单明细
//
//        // 补充数据(附件
//        List<ComSaleFileComVO> comSaleFileComVOS = comSaleFileInfoService.findFileByBusinessId("PRICE_B", id);
//        alter.setFileComVOS(comSaleFileComVOS);
//        // 反查商品相关信息、商品价格
//        List<Long> itemIds = alterDDOS.stream().map(PriSalePriceAlterDDO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<ItmItemRpcDTO> itemRpcResult = rmiItemService.findItemList(itemIds, null);
//     //   List<PriMainPriceRpcDTO> priceRpcResult = rmiPriMainPriceService.findMainPriceDtoList(itemIds, null);
//
//        // 反查公司信息，填充公司名称
//        List<OrgOuRpcDTO> ouRpcResult = rmiOrgOuService.findOuDtoList(Lists.newArrayList(alterDO.getOuId()), null);
//        ouRpcResult.stream().filter(ou -> ou.getId().equals(alterDO.getOuId())).findFirst().ifPresent(ou -> alter.setOuName(ou.getOuName()));
//
//        // 非内部结算价才需要查询已存在的价格，并循环填入要导入的数据中
//        List<PriSalePricePageRespVO> existPriceList = null;
//        if (!TYPE_CROSS.equals(docType) && !TYPE_BASE.equals(docType)) {
//            existPriceList = priSalePriceService.queryExistPrice(alter.getOuId(), null, null, itemIds, null);
//        }
//
//        // 客户价时需要查询客户等级
//        List<CrmCustPageRespVO> custList = null;
//        if (TYPE_CUST.equals(docType)) {
//            List<String> custCodes = alterDDOS.stream().map(PriSalePriceAlterDDO::getCustCode).distinct().collect(Collectors.toList());
//            custList = this.queryCrmCustList(custCodes);
//        }
//
//        // 货币
//        List<String> currCodes = alterDDOS.stream().map(PriSalePriceAlterDDO::getCurrCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//        List<ComCurrRpcDTO> currRpcList = rmiComService.findCurrDtoList(currCodes);
//        // 税率
//        List<String> taxRateNos = alterDDOS.stream().map(PriSalePriceAlterDDO::getTaxRateNo).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//        List<ComTaxRateRpcDTO> taxRateRpcResult = rmiComService.findTaxRateList(taxRateNos);
//        // 采购价
//        PurPriceBatchParamDTO purPriceParam = new PurPriceBatchParamDTO();
//        purPriceParam.setOuId(alter.getOuId());
//        purPriceParam.setValidDate(LocalDate.now());
//        List<PurPriceDetailParamDTO> collect = alterDDOS.stream().map(vi -> {
//            PurPriceDetailParamDTO detail = new PurPriceDetailParamDTO();
//            detail.setItemId(vi.getItemId());
//            detail.setUom(vi.getUom());
//            detail.setCurrCode(vi.getCurrCode());
//            return detail;
//        }).collect(Collectors.toList());
//        purPriceParam.setPurPriceDetailParamDtoList(collect);
//        List<PurPriceBaseDTO> purPriRpcResult = rmiPurPriceService.getPriceListByParam(purPriceParam);
//
//        List<PriSalePriceAlterDSaveParam> details = new ArrayList<>(alterDDOS.size());
//        for (PriSalePriceAlterDDO alterD : alterDDOS) {
//            PriSalePriceAlterDSaveParam temp = PriSalePriceAlterDConvert.INSTANCE.doToParam(alterD);
//            // 回填商品相关属性
//            itemRpcResult.stream().filter(item -> item.getId().equals(alterD.getItemId())).findFirst().ifPresent(i -> {
//                temp.setItemName(i.getItemName());
//                temp.setItemCateCode(i.getItemCateCode());
//                temp.setItemSpec(i.getSpec());
//            });
//            // 获取采购价
//            purPriRpcResult.stream().filter(p -> p.getItemId().equals(temp.getItemId())
//                    && p.getCurrCode().equals(temp.getCurrCode())
//                    && p.getToUom().equals(temp.getUom()))
//                    .findFirst().ifPresent(pri -> temp.setFloorPrice(pri.getPrice()));
//            // 回填商品市场价、销售指导价、销售底价
////            priceRpcResult.stream().filter(price -> alterD.getItemId().equals(price.getItemId())).findFirst().ifPresent(p -> {
////                temp.setMarketPrice(p.getPrice1());
////                temp.setGuidePrice(p.getPrice2());
////                // 根据采购价计算销售底价：销售底价 = 采购价 /（1 - 毛利控制率） price4
////                if (Objects.nonNull(p.getPrice4()) && Objects.nonNull(temp.getFloorPrice())) {
////                    temp.setFloorPrice(temp.getFloorPrice().divide(BigDecimal.ONE.subtract(p.getPrice4()), 4, RoundingMode.HALF_UP));
////                } else {
////                    temp.setFloorPrice(null);
////                }
////            });
//            // 将价格填入不同类型对应字段
//            if (TYPE_BASE.equals(docType)) {
//                temp.setBasePrice(alterD.getPrice());
//            } else if (TYPE_CUST.equals(docType)) {
//                temp.setCustPrice(alterD.getPrice());
//            } else if (TYPE_GROUP.equals(docType)) {
//                temp.setCustGroupPrice(alterD.getPrice());
//            } else {
//                temp.setCrossPrice(alterD.getPrice());
//            }
//            // 回填已存在的价格
//            if (!TYPE_CROSS.equals(docType) && !TYPE_BASE.equals(docType)) {
//                temp.setBasePrice(BigDecimal.ZERO);
//                existPriceList.stream().filter(p -> TYPE_BASE.equals(p.getPriceType()) && alterD.getItemId().equals(p.getItemId()))
//                        .findFirst().ifPresent(bp -> temp.setBasePrice(bp.getPrice()));
//                // 若为客户价，则拼接客户等级价
//                if (TYPE_CUST.equals(docType)) {
//                    Optional<CrmCustPageRespVO> custOptional = custList.stream().filter(c -> alterD.getCustCode().equals(c.getCustCode())).findFirst();
//                    if (custOptional.isPresent()) {
//                        existPriceList.stream().filter(p -> TYPE_GROUP.equals(p.getPriceType())
//                                && p.getCustGroup().equals(custOptional.get().getCustLevel())
//                                && alterD.getItemId().equals(p.getItemId()))
//                                .findFirst().ifPresent(gp -> temp.setCustGroupPrice(gp.getPrice()));
//                    }
//                }
//            }
//
//            // 回填币种名称
//            currRpcList.stream().filter(c -> StrUtil.isNotBlank(temp.getCurrCode())
//                    && temp.getCurrCode().equals(c.getCurrCode()))
//                    .findFirst().ifPresent(curr -> temp.setCurrName(curr.getCurrName()));
//            // 回填税率描述
//            taxRateRpcResult.stream().filter(taxRate -> (StrUtil.isNotBlank(temp.getTaxRateNo())
//                    && temp.getTaxRateNo().equals(taxRate.getTaxRateNo())))
//                    .findFirst().ifPresent(t -> temp.setTaxRateDesc(t.getTaxRateDesc()));
//            details.add(temp);
//        }
//        alter.setDetails(details);
//        return alter;
//    }
//
//    @Override
//    public PagingVO<SalePriceAlterExportVO> searchForExport(PriSalePriceAlterPagingParam param) {
//        JPAQuery<SalePriceAlterExportVO> jpaQuery = selectForExport(param);
//
//        long total = jpaQuery.fetchCount();
//        if (total == 0) {
//            return PagingVO.<SalePriceAlterExportVO>builder().build();
//        }
////        var pageRequest = wrapperPageRequest(param.getPageRequest(), null);
//        appendPageAndSort(jpaQuery, param.getPageRequest(), qPriSalePriceAlterDO);
//        List<SalePriceAlterExportVO> pageResult = jpaQuery.fetch();
//
//        // ----------- 反查公司填充公司名称 ------------
//        List<Long> ouIds = pageResult.stream().map(SalePriceAlterExportVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<OrgOuRpcDTO> ouRpcResult = rmiOrgOuService.findOuDtoList(ouIds, null);
//
//        // 反查商品相关信息、商品价格
//        List<Long> itemIds = pageResult.stream().map(SalePriceAlterExportVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<ItmItemRpcDTO> itemRpcResult = rmiItemService.findItemList(itemIds, null);
//
//        // 查询客户等级
//        List<CrmCustPageRespVO> custList = new ArrayList<>();
//        List<String> custCodes = pageResult.stream()
////                .filter(exportVO -> TYPE_CUST.equals(exportVO.getDocType()))
//                .map(SalePriceAlterExportVO::getCustCode)
//                .filter(Objects::nonNull)
//                .distinct()
//                .collect(Collectors.toList());
//        if (custCodes.size()>0){
//            custList = this.queryCrmCustList(custCodes);
//        }
//
//        // 申请者
//        List<Long> empIds = pageResult.stream().map(SalePriceAlterExportVO::getApplyEmpId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
//        List<SysUserVO> users = new ArrayList<>();
//        if (empIds.size()>0){
//            List<SysUserVO> users1 = userService.getUsers(empIds);
//            if (users1!=null){
//                users = users1;
//            }
//        }
//
//        if (regionMap == null){
//            regionMap = sysUdcService.getCodeMap("ORG", "OU_REGION");
//            statusMap = sysUdcService.getCodeMap("PRI", "SALE_APPLY_STATUS");
//            uomMap = sysUdcService.getCodeMap("COM", "UOM");
//        }
//
//        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DATE_FORMAT);
//
//        for (var exportVO : pageResult) {
//
//            // 公司名称
//            ouRpcResult.stream()
//                    .filter(ou -> ou.getId().equals(exportVO.getOuId()))
//                    .findFirst()
//                    .ifPresent(ou -> exportVO.setOuName(ou.getOuName()));
//
//            // 申请人
//            users.stream()
//                    .filter(user-> user.getId().equals(exportVO.getApplyEmpId()))
//                    .findFirst()
//                    .ifPresent(user->exportVO.setApplyUserName(user.getFirstName()));
//
//            // 价格类型
//            exportVO.setDocTypeName(typeMap.get(exportVO.getDocType()));
//
//            // 回填商品相关属性
//            itemRpcResult.stream().filter(item -> item.getId().equals(exportVO.getItemId())).findFirst().ifPresent(i -> {
//                exportVO.setItemName(i.getItemName());
//                exportVO.setItemCateCode(i.getItemCateCode());
//                exportVO.setItemSpec(i.getSpec());
//            });
//
//            // 客户等级
//            Optional<CrmCustPageRespVO> custOptional = custList.stream().filter(c -> c.getCustCode().equals(exportVO.getCustCode())).findFirst();
//            custOptional.ifPresent(crmCustPageRespVO -> exportVO.setCustLevel(crmCustPageRespVO.getCustLevel()));
//
//            // 区域
//            exportVO.setSaleRegionName(regionMap.get(exportVO.getSaleRegion()));
//
//            // 状态
//            exportVO.setDocStatusName(statusMap.get(exportVO.getDocStatus()));
//
//            // 单位
//            exportVO.setUomName(uomMap.get(exportVO.getUom()));
//
//            // 时间
//            exportVO.setApplyDateStr(exportVO.getApplyDate().format(dtf));
//            exportVO.setCreateTimeStr(exportVO.getCreateTime().format(dtf));
//            exportVO.setModifyTimeStr(exportVO.getModifyTime().format(dtf));
//            exportVO.setValidFromStr(exportVO.getValidFrom().format(dtf));
//            exportVO.setValidToStr(exportVO.getValidTo().format(dtf));
//            if (exportVO.getPromDateF() != null){
//                exportVO.setPromDateFStr(exportVO.getPromDateF().format(dtf));
//            }
//            if (exportVO.getPromDateT() != null){
//                exportVO.setPromDateTStr(exportVO.getPromDateT().format(dtf));
//            }
//
//        }
//
//        return PagingVO.<SalePriceAlterExportVO>builder()
//                .total(total)
//                .records(pageResult)
//                .build();
//    }
//
//    private JPAQuery<SalePriceAlterExportVO> selectForExport(PriSalePriceAlterPagingParam param){
//        return jpaQueryFactory.select(Projections.bean(SalePriceAlterExportVO.class,
//                qPriSalePriceAlterDO.id,
//                qPriSalePriceAlterDO.ouId,
//                qPriSalePriceAlterDO.docNo,
//                qPriSalePriceAlterDO.docType,
//                qPriSalePriceAlterDO.docStatus,
//                qPriSalePriceAlterDO.applyDate,
//                qPriSalePriceAlterDO.applyEmpId,
//                qPriSalePriceAlterDO.saleRegion,
//
//                qPriSalePriceAlterDDO.itemId,
//                qPriSalePriceAlterDDO.itemCode,
//                qPriSalePriceAlterDDO.itemName,
//                qPriSalePriceAlterDDO.itemSpec,
//                qPriSalePriceAlterDDO.barcode,
//                qPriSalePriceAlterDDO.price,
//                qPriSalePriceAlterDDO.itemCateCode,
//                qPriSalePriceAlterDDO.itemCatePath,
//                qPriSalePriceAlterDDO.uom,
//                qPriSalePriceAlterDDO.custCode,
//                qPriSalePriceAlterDDO.custName,
//                qPriSalePriceAlterDDO.taxRate,
//                qPriSalePriceAlterDDO.taxRateNo,
//                qPriSalePriceAlterDDO.currCode,
//                qPriSalePriceAlterDDO.validFrom,
//                qPriSalePriceAlterDDO.validTo,
//                qPriSalePriceAlterDDO.promDateF,
//                qPriSalePriceAlterDDO.promDateT,
//                qPriSalePriceAlterDDO.creator,
//                qPriSalePriceAlterDDO.createTime,
//                qPriSalePriceAlterDDO.updater,
//                qPriSalePriceAlterDDO.modifyTime,
//                qPriSalePriceAlterDDO.promotionNetPrice,
//                qPriSalePriceAlterDDO.promotionPrice))
//                .from(qPriSalePriceAlterDO)
//                .leftJoin(qPriSalePriceAlterDDO).on(qPriSalePriceAlterDDO.masId.eq(qPriSalePriceAlterDO.id))
//                .where(buildPageSearchConditionExport(param));
//    }
//
//    private List<CrmCustPageRespVO> queryCrmCustList(List<String> custCodes) {
//        try {
//            if (CollUtil.isEmpty(custCodes)) {
//                return new ArrayList<>(0);
//            }
//            var custQueryParam = new CrmCustQueryParamVO();
//            custQueryParam.setCustCodes(custCodes);
//            custQueryParam.setTransFlag(false);
//            return crmCustService.searchList(custQueryParam);
//        } catch (Exception e) {
//            throw new BusinessException("调用客户相关服务异常", e);
//        }
//    }
//
//    private Predicate buildPageSearchConditionExport(PriSalePriceAlterPagingParam param) {
//        Predicate predicate = qPriSalePriceAlterDO.isNotNull();
//        if (Objects.nonNull(param)) {
//            if (!StringUtils.isEmpty(param.getDocNo())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.docNo.like("%" + param.getDocNo() + "%"));
//            }
//            if (!StringUtils.isEmpty(param.getDocType())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.docType.eq(param.getDocType()));
//            }
//            if (!StringUtils.isEmpty(param.getItemCode())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDDO.itemCode.like("%" +param.getItemCode() + "%"));
//            }
//            if (!StringUtils.isEmpty(param.getItemName())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDDO.itemName.like("%" +param.getItemName()+ "%"));
//            }
//            if (Objects.nonNull(param.getApplyDateFrom())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.applyDate.after(param.getApplyDateFrom())
//                        .or(qPriSalePriceAlterDO.applyDate.eq(param.getApplyDateFrom())));
//            }
//            if (Objects.nonNull(param.getApplyDateTo())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.applyDate.before(param.getApplyDateTo())
//                        .or(qPriSalePriceAlterDO.applyDate.eq(param.getApplyDateTo())));
//            }
//            if (Objects.nonNull(param.getOuId())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.ouId.eq(param.getOuId()));
//            }
//        }
//        // 数据权限
////        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qPriSalePriceAlterDO.getMetadata()));
//        return predicate;
//    }
//
//    private Predicate buildPageSearchCondition(PriSalePriceAlterPagingParam param) {
//        Predicate predicate = qPriSalePriceAlterDO.isNotNull();
//        if (Objects.nonNull(param)) {
//            if (!StringUtils.isEmpty(param.getDocNo())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.docNo.like("%" + param.getDocNo() + "%"));
//            }
//            if (!StringUtils.isEmpty(param.getDocType())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.docType.eq(param.getDocType()));
//            }
//            if (!StringUtils.isEmpty(param.getItemCode())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.id.in(param.getIdByIC()));
//            }
//            if (!StringUtils.isEmpty(param.getItemName())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.id.in(param.getIdByIN()));
//            }
//            if (Objects.nonNull(param.getApplyDateFrom())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.applyDate.after(param.getApplyDateFrom())
//                        .or(qPriSalePriceAlterDO.applyDate.eq(param.getApplyDateFrom())));
//            }
//            if (Objects.nonNull(param.getApplyDateTo())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.applyDate.before(param.getApplyDateTo())
//                        .or(qPriSalePriceAlterDO.applyDate.eq(param.getApplyDateTo())));
//            }
//            if (Objects.nonNull(param.getOuId())) {
//                predicate = ExpressionUtils.and(predicate, qPriSalePriceAlterDO.ouId.eq(param.getOuId()));
//            }
//        }
//        // 权限条件查询
//        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qPriSalePriceAlterDO.getMetadata()));
//        log.info("价格申请权限"+predicate);
//        return predicate;
//    }
//
//    // 四种价格类型
//    public static final String TYPE_BASE = UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode();
//    public static final String TYPE_CUST = UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode();
//    public static final String TYPE_GROUP = UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode();
//    public static final String TYPE_CROSS = UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCode();
//
//}
