package com.elitesland.yst.production.sale.service;

import com.elitesland.yst.production.sale.convert.SalContractDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.SalContractDQtyRespDTO;
import com.elitesland.yst.production.sale.dto.SalContractDRespDTO;
import com.elitesland.yst.production.sale.dto.SalContractRespDTO;
import com.elitesland.yst.production.sale.entity.QSalContractDDO;
import com.elitesland.yst.production.sale.entity.QSalContractDO;
import com.elitesland.yst.production.sale.entity.SalContractDDO;
import com.elitesland.yst.production.sale.repo.SalContractDRepo;
import com.elitesland.yst.production.sale.repo.SalContractDRepoProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * @author Shadow
 * @since 2021-08-06 15:01
 */
@Slf4j
//(version = "${provider.service.version}")
@RestController
@RequestMapping(SalContractRpcService.URI)
public class SalContractRpcServiceImpl extends BaseServiceImpl implements SalContractRpcService{

    @Autowired
    private SalContractDRepo salContractDRepo;

    @Autowired
    private SalContractDRepoProc salContractDRepoProc;

    private final QSalContractDDO qSalContractDDO = QSalContractDDO.salContractDDO;

    private final QSalContractDO qSalContractDO = QSalContractDO.salContractDO;

    @Override
    public ApiResult<SalContractDRespDTO> updateContractD(Long did) {

        SalContractDConvert salContractDConvert = SalContractDConvert.INSTANCE;

        SalContractDRespDTO dto = null;

        Optional<SalContractDDO> byId = salContractDRepo.findById(did);

        if (byId.isPresent()){
            dto = salContractDConvert.do2rpcDTO(byId.get());
            return ApiResult.ok(dto);
        }
        return ApiResult.fail("查无信息");
    }

    @Override
    public ApiResult<List<SalContractDQtyRespDTO>> queryContractDQty(List<Long> relateDocDids) {
        if (ObjectUtils.isEmpty(relateDocDids)){
            return null;
        }
        JPAQuery<SalContractDQtyRespDTO> respDTOJPAQuery = this.select(relateDocDids);
        List<SalContractDQtyRespDTO> contractDQtyRespDTOS = respDTOJPAQuery.fetch();
        return ApiResult.ok(contractDQtyRespDTOS);
    }

    @Override
    public ApiResult<List<SalContractRespDTO>> queryContractByCode(List<String> contractNos) {
        if (CollectionUtils.isEmpty(contractNos)){
            return null;
        }
        JPAQuery<SalContractRespDTO> jpaQuery = this.selectForContract(contractNos);
        List<SalContractRespDTO> contractRespDTOS = jpaQuery.fetch();
        return ApiResult.ok(contractRespDTOS);
    }

    public JPAQuery<SalContractRespDTO> selectForContract(List<String> contractNos){

        Predicate predicate = null;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalContractRespDTO.class,
                qSalContractDO.id.as("contractId"),
                qSalContractDO.contractName,
                qSalContractDO.contractNo
                )).from(qSalContractDO);
        jpaQuery.where(predicate, qSalContractDO.contractNo.in(contractNos));
        jpaQuery.where(predicate, qSalContractDO.deleteFlag.eq(0).or(qSalContractDO.deleteFlag.isNotNull()));
        return jpaQuery;
    }

    public JPAQuery<SalContractDQtyRespDTO> select(List<Long> relateDocDids) {

        Predicate predicate = null;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalContractDQtyRespDTO.class,
                qSalContractDDO.id,
                qSalContractDDO.qty
        )).from(qSalContractDDO);

        jpaQuery.where(predicate, qSalContractDDO.id.in(relateDocDids));
        jpaQuery.where(predicate, qSalContractDDO.deleteFlag.eq(0).or(qSalContractDDO.deleteFlag.isNull()));
        return jpaQuery;
    }
}