package com.elitesland.yst.production.sale.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.file.utils.UUIDUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitesland.yst.production.order.param.SalSoDetailRespDTO;
import com.elitesland.yst.production.sale.api.service.shop.SalReceiptStateService;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptdRespVO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.SalReceiptStatementDTO;
import com.elitesland.yst.production.sale.entity.SalReceiptSettleDO;
import com.elitesland.yst.production.sale.entity.SalReceiptSettleddDO;
import com.elitesland.yst.production.sale.entity.SalReceiptSettleitemDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptSettleRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptSettleddRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptSettleitemRepo;
import com.elitesland.yst.production.sale.rmi.ystfin.RmiSettleDocTypeService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiSysSettingService;
import com.elitesland.yst.production.sale.rocketmq.MqSource;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.common.message.MessageConst;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/**
 * @auther JinXK
 * @date 2021/8/17 9:47
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SalReceiptStateServiceImpl extends BaseServiceImpl implements SalReceiptStateService {

//    private final RmiItemService rmiItemService;
    private final RmiSysSettingService rmiSysSettingService;
    private final SalReceiptSettleddRepo salReceiptSettleddRepo;
    private final CrmCustRepo crmCustRepo;
    private final RmiSettleDocTypeService rmiSettleDocTypeService;
    private final SalReceiptSettleRepo salReceiptSettleRepo;
    private final SalReceiptSettleitemRepo salReceiptSettleitemRepo;
    private final RmiOrgOuService rmiOrgOuService;
//    private final RmiOrderSalSoService rmiOrderSalSoService;

//    @Autowired
//    private MqSource mySource;

    @Autowired
    private UdcProvider udcProvider;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> createStatement(SalReceiptRespVO receiptDO, List<SalReceiptdRespVO> ddos, String receiptSerial) {
        SalReceiptStatementDTO statementDTO = getSalReceiptStatementDTO(receiptDO, ddos, receiptSerial);
        //保存数据到sal_receipt_settledd表
        setSettledd(statementDTO);
        //传给结算中心做为结算单的明细记录
        Message<SalReceiptStatementDTO> message = sendMessage(statementDTO);
        //输出日志
        LocalDateTime now = LocalDateTime.now();
        log.info("收款结算单"+now+"输出:"+statementDTO);

        return ApiResult.ok(message);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> createStatement(String soType, SalReceiptRespVO receiptDO, List<SalReceiptdRespVO> ddos, String receiptSerial) {
        SalReceiptStatementDTO statementDTO = getSalReceiptStatementDTO(receiptDO, ddos, receiptSerial);
        //保存数据到sal_receipt_settledd表
        setSettledd(soType, statementDTO);
        //传给结算中心做为结算单的明细记录
        Message<SalReceiptStatementDTO> message = sendMessage(statementDTO);
        //输出日志
        LocalDateTime now = LocalDateTime.now();
        log.info("收款结算单"+now+"输出:"+ JSONUtil.toJsonStr(statementDTO));

        return ApiResult.ok(message);
    }

    private void setSettledd(String soType, SalReceiptStatementDTO statementDTO){
        SalReceiptSettleDO settleDO = new SalReceiptSettleDO();
        salReceiptSettleRepo.save(settleDO);
        statementDTO.setSourceId(settleDO.getId());

        AtomicReference<BigDecimal> settleAmt = new AtomicReference<>(new BigDecimal(0));
        AtomicReference<BigDecimal> settleTax = new AtomicReference<>(new BigDecimal(0));
        if(statementDTO.getDetails()!=null && statementDTO.getDetails().size()>0){
            statementDTO.getDetails().forEach(detail -> {
                //订单收款结算商品细表信息组装
                SalReceiptSettleitemDO settleitemDO = new SalReceiptSettleitemDO();
                settleitemDO.setMasId(settleDO.getId());
                settleitemDO.setLineNo(detail.getSoLineNo());
                settleitemDO.setItemCat(detail.getItemClass());
                settleitemDO.setFinCat(detail.getFinanceClass());
                settleitemDO.setTaxRate(detail.getTaxRate());
                settleitemDO.setReceiptAmt(detail.getAmt());
                settleitemDO.setReceiptTax(detail.getTax());
                settleitemDO.setApAmt(detail.getTotalAmount());
                settleitemDO.setCardAmt(BigDecimal.ZERO);
                settleitemDO.setCouponAmt(BigDecimal.ZERO);
                settleitemDO.setGiftAmt(BigDecimal.ZERO);
                settleitemDO.setUsepointAmt(BigDecimal.ZERO);
                settleitemDO.setLineNo(detail.getSoLineNo());
                settleitemDO.setItemCat(detail.getItemClass());
                salReceiptSettleitemRepo.save(settleitemDO);
//                int count = salReceiptSettleddRepo.countByDocDId(detail.getReceiptDId());
//                if(count>0){
//                    throw new BusinessException("该单据已存在于salReceiptSettledd");
//                }
                //订单收款结算细细表信息组装
                SalReceiptSettleddDO settleddDO = new SalReceiptSettleddDO();
                settleddDO.setSettleitemId(settleitemDO.getId());
                if(statementDTO.getDetails()!=null && statementDTO.getDetails().size()>0){
                    settleddDO.setDocNo(statementDTO.getDetails().get(0).getSoNo());
                }
                settleddDO.setCreateUserId(statementDTO.getCreateUserId());
                settleddDO.setCurrCode(statementDTO.getCurrency());
                settleddDO.setAgentEmpId(statementDTO.getApplyEmpId());
                settleddDO.setAgentName(statementDTO.getApplyName());
                settleddDO.setSoSource(statementDTO.getOrderChannel());
                settleddDO.setReceiptType(statementDTO.getBusinessType2());
                settleddDO.setReceiptDate(statementDTO.getProcessTime());
                settleddDO.setDocTime(statementDTO.getProcessTime());
                settleddDO.setPno(statementDTO.getDocNo());
                settleddDO.setOuId(statementDTO.getOuId());
                settleddDO.setOuCode(statementDTO.getOuCode());
                settleddDO.setOuName(statementDTO.getOuName());
                settleddDO.setBuId(statementDTO.getBuId());
                settleddDO.setBuCode(statementDTO.getBuCode());
                settleddDO.setBuName(statementDTO.getBuName());
                settleddDO.setCustId(statementDTO.getCustId());
                settleddDO.setCustCode(statementDTO.getCustCode());
                settleddDO.setCustName(statementDTO.getCustName());
                settleddDO.setDocType(soType);
                settleddDO.setDocType2("B");
                settleddDO.setCardAmt(BigDecimal.ZERO);
                settleddDO.setGiftAmt(BigDecimal.ZERO);
                settleddDO.setCouponAmt(BigDecimal.ZERO);
                settleddDO.setUsepointAmt(BigDecimal.ZERO);
                settleddDO.setDocDId(detail.getSoDId());
                settleddDO.setItemCat(detail.getItemClass());
                settleddDO.setFinCat(detail.getFinanceClass());
                settleddDO.setItemCode(detail.getItemCode());
                settleddDO.setItemId(detail.getItemId());
                settleddDO.setItemName(detail.getItemName());
                settleddDO.setUom(detail.getUom());
                settleddDO.setTaxRate(detail.getTaxRate());
                settleddDO.setOriginAmt(detail.getAmt());
                settleddDO.setReceiptAmt(detail.getAmt());
                settleAmt.set(settleAmt.get().add(detail.getAmt()));
                settleddDO.setReceiptTax(detail.getTax());
                settleTax.set(settleTax.get().add(detail.getTax()));
                settleddDO.setRemark(detail.getRemark());
                settleddDO.setLineNo(detail.getSoLineNo());
                settleddDO.setApAmt(detail.getTotalAmount());
                salReceiptSettleddRepo.save(settleddDO);
            });
        }
//        else{
////            int count = salReceiptSettleddRepo.countByDocId(statementDTO.getReceiptId());
////            if(count>0){
////                throw new BusinessException("该单据已存在于salReceiptSettledd");
////            }
//            salReceiptSettleddRepo.save(settleddDO);
//        }

        settleDO.setDocType(soType);
        settleDO.setDocType2("B");
        settleDO.setSettleDate(statementDTO.getProcessTime());
        settleDO.setSoSource(statementDTO.getOrderChannel());
        settleDO.setBuId(statementDTO.getBuId());
        settleDO.setBuCode(statementDTO.getBuCode());
        settleDO.setBuName(statementDTO.getBuName());
        settleDO.setCurrCode(statementDTO.getCurrency());
        settleDO.setOuId(statementDTO.getOuId());
        settleDO.setOuCode(statementDTO.getOuCode());
        settleDO.setOuName(statementDTO.getOuName());
        settleDO.setCustId(statementDTO.getCustId());
        settleDO.setCustCode(statementDTO.getCustCode());
        settleDO.setCustName(statementDTO.getCustName());
        settleDO.setAgentEmpId(statementDTO.getApplyEmpId());
        settleDO.setAgentName(statementDTO.getApplyName());
        settleDO.setCreateUserId(statementDTO.getCreateUserId());
        settleDO.setSettleAmt(settleAmt.get());
        settleDO.setSettleTax(settleTax.get());
        settleDO.setReceiptOuId(statementDTO.getOuId());
        settleDO.setReceiptOuCode(statementDTO.getOuCode());
        settleDO.setReceiptOuName(statementDTO.getOuName());
        salReceiptSettleRepo.save(settleDO);
    }

//    @Override
//    public ApiResult<Object> createInvoice(SalInvApplyRespVO salInvApplyDO, List<SalInvApplydRespVO> detailList) {
//        InvCustDTO invCustDTO = getInvCustDTO(salInvApplyDO, detailList);
//        //传给结算中心做为开发票的入参
//        Message<InvCustDTO> message = sendInvoice(invCustDTO);
//        //输出日志
//        LocalDateTime now = LocalDateTime.now();
//        log.info("发票单"+now+"输出:"+JSONUtil.toJsonStr(invCustDTO));
//
//        return ApiResult.ok(message);
//    }

    private SalReceiptStatementDTO getSalReceiptStatementDTO(SalReceiptRespVO receiptDO, List<SalReceiptdRespVO> ddos, String receiptSerial){
//        SalReceiptStatementDTO dto = new SalReceiptStatementDTO();
//        dto.setReceiptId(receiptDO.getId());
//        /**收款单类型取值暂时改为判断后传固定值**/
////        List<SalReceiveDefQueryParam> params = new ArrayList<>();
////        SalReceiveDefQueryParam queryParam = new SalReceiveDefQueryParam();
////        queryParam.setOuId(receiptDO.getOuId());
////        params.add(queryParam);
////        List<SalReceiveDefRemoteDTO> remoteDTOS = rmiSettleDocTypeService.getReceiptSettleDocType(params);
////        if(remoteDTOS.size()==0 || remoteDTOS.get(0).getSettleDefines().size()==0 ||
////                remoteDTOS.get(0).getSettleDefines().get(0).getDefineCode()==null){
////            throw new BusinessException("收款单类型查询失败,ouId:"+receiptDO.getOuId()+",返回参数:"+ JSONUtil.toJsonStr(remoteDTOS));
////        }
////        dto.setSettleType(remoteDTOS.get(0).getSettleDefines().get(0).getDefineCode());
//        if(receiptDO.getReceiptType()==null){
//            throw new BusinessException("收款单类型为空,请联系管理员");
//        }else{
//            if(receiptDO.getReceiptType().equals("ONLINE_PRE") || receiptDO.getReceiptType().equals("40")){
//                dto.setSettleType("B0001");
//            }else if(receiptDO.getReceiptType().equals("AR") || receiptDO.getReceiptType().equals("10")){
//                dto.setSettleType("B0002");
//            }else if(receiptDO.getReceiptType().equals("DEPOSIT") || receiptDO.getReceiptType().equals("20")){
//                dto.setSettleType("B0003");
//            }else if(receiptDO.getReceiptType().equals("DEP_PRE")){
//                dto.setSettleType("B0004");
//            }else if(receiptDO.getReceiptType().equals("PRE") || receiptDO.getReceiptType().equals("30")){
//                dto.setSettleType("B0005");
//            }else if(receiptDO.getReceiptType().equals("VIRTUAL")){
//                dto.setSettleType("B0006");
//            }else if(receiptDO.getReceiptType().equals("RED")){
//                dto.setSettleType("B0007");
//            }else if(receiptDO.getReceiptType().equals("OFF_PRE")){
//                dto.setSettleType("B0008");
//            }
//        }
//        dto.setBusinessType2("B");
////        dto.setOrderChannel(receiptDO.getSoSource());
//        dto.setBuId(receiptDO.getBuId());
//        dto.setBuName(receiptDO.getBuName());
//        dto.setApplyEmpId(receiptDO.getApplyEmpId());
//        dto.setApplyName(receiptDO.getApplyName());
//        dto.setCurrency(receiptDO.getCurrCode());
//        dto.setCurrencyName(receiptDO.getCurrName());
//        dto.setOuId(receiptDO.getOuId());
//        dto.setOuCode(receiptDO.getOuCode());
//        dto.setOuName(receiptDO.getOuName());
//        dto.setCustId(receiptDO.getCustId());
//        dto.setCustCode(receiptDO.getCustCode());
//        dto.setCustName(receiptDO.getCustName());
//        Optional<CrmCustDO> optional = crmCustRepo.findById(receiptDO.getCustId());
//        if(optional.isPresent()){
//            dto.setContactType(optional.get().getCustGroup2());
//            if(optional.get().getCustGroup2().equals("20")){
//                //小B客户
//                SysSettingVO sysSetting = rmiSysSettingService.findSysSettingByNo(ConstantsSale.BCUSTNO);
//                if(sysSetting==null || sysSetting.getSettingVal()==null){
//                    throw new BusinessException("虚拟客户名称查询失败");
//                }
//                dto.setFakeCustCode(sysSetting.getSettingVal());
//            }
////            else if(optional.get().getCustGroup2().equals("10") && optional.get().getCustCode2()!=null){
////                //大B客户
////                dto.setFakeCustCode(optional.get().getCustCode2());
////            }
//        }
//        dto.setState("APPROVING");//待审批
//        dto.setVerifyState("10");//未核销
//        dto.setCreateUserId(receiptDO.getCreateUserId());
//        dto.setCreator(receiptDO.getCreator());
//        dto.setRemark(receiptDO.getRemark());
//        dto.setReceiptType(receiptDO.getReceiptType());
//        dto.setPayMethod(receiptDO.getPayMethod());
//        dto.setApplyDate(receiptDO.getApplyDate());
//        dto.setAmt(receiptDO.getAmt());
//        dto.setDocNo(receiptDO.getDocNo());
//        dto.setContractCode(receiptDO.getContractCode());
//        dto.setOuBankAcc(receiptDO.getOuBankAcc());
//        if(receiptSerial!=null){
//            dto.setReceiptSerial(receiptSerial);
//        }
//        if(receiptDO.getDocType()!=null && receiptDO.getDocType().equals("RE")){
//            dto.setProcessTime(receiptDO.getPlanReceiptDate());
//            List<SysUdcComboVO> receiptTypeList = sysUdcService.listCodeCombos("SAL","RECEIPT_TYPE");
//            receiptTypeList.forEach(l -> {
//                if(l.getUdcVal().equals(receiptDO.getReceiptType())){
//                    dto.setReceiptTypeName(l.getValDesc());
//                }
//            });
//        }else if(receiptDO.getDocType().equals("RD")){
//            dto.setProcessTime(receiptDO.getApplyDate());
//            dto.setRelationNumber(receiptDO.getRelateDocNo());
//            List<SysUdcComboVO> refoundTypeList = sysUdcService.listCodeCombos("SAL","REFOUND_TYPE");
//            refoundTypeList.forEach(l -> {
//                if(l.getUdcVal().equals(receiptDO.getReceiptType())){
//                    dto.setReceiptTypeName(l.getValDesc());
//                }
//            });
//        }
//        if(ddos.size()>0){
//            //先校验itemId，为空则反查补上
//            List<Long> itemIdNull = ddos.stream().filter(sod->sod.getItemId()==null).map(SalReceiptdRespVO::getItemId).collect(Collectors.toList());
//            if(itemIdNull.size()>0){
//                //反查itemId
//                List<String> itemCodes = ddos.stream().map(r -> r.getItemCode()).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//                ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
//                itemRpcDtoParam.setItemCodes(itemCodes);
//                List<ItmItemRpcDTO> itemRpcResult = rmiItemService.findItemListByParam(itemRpcDtoParam);
//                ddos.forEach(r -> {
//                    itemRpcResult.stream().filter(c -> (StrUtil.isNotBlank(r.getItemCode()) && r.getItemCode().equals(c.getItemCode())))
//                            .findFirst().ifPresent(curr -> r.setItemId(curr.getId()));
//                });
//            }
//
//            List<SalReceiptDetailStatementDTO> list = new ArrayList<>();
//            List<Long> itemIds = ddos.stream().filter(sod->sod.getItemId()!=null).map(SalReceiptdRespVO::getItemId).distinct().collect(Collectors.toList());
//            ItmItemCateContrPropRpcDTO item = rmiItemService.findItemCateContPropDtoByItemId(itemIds);
//            if(item==null || item.getItmItemCateContrPropDTOS()==null){
//                throw new BusinessException("商品、财务分类查询失败,itemIds:"+itemIds);
//            }
//            ItmItemRpcDtoParam param = new ItmItemRpcDtoParam();
//            param.setItemIds(itemIds);
//            List<ItmItemRpcDTO> itemListByParam = rmiItemService.findItemListByParam(param);
//            if(itemListByParam.size()==0){
//                throw new BusinessException("业务类型查询失败,itemIds:"+itemIds);
//            }
//            ddos.forEach(ddo -> {
//                SalReceiptDetailStatementDTO detail = new SalReceiptDetailStatementDTO();
//                detail.setReceiptDId(ddo.getId());
//                detail.setSoNo(ddo.getSoNo());
//                detail.setSoLineNo(ddo.getSoLineNo());
//                item.getItmItemCateContrPropDTOS().forEach(itemDto -> {
//                    if(ddo.getItemId().equals(itemDto.getId())){
//                        detail.setFinanceClass(itemDto.getControlParamValue());//todo 财务分类
//                    }
//                });
//                itemListByParam.forEach(i ->{
//                    if(i.getId().equals(ddo.getItemId())){
//                        if(i.getItemType().equals("20")){
//                            //服务类商品
//                            detail.setBusinessType("6035");
//                        }else{
//                            detail.setBusinessType("6010");
//                        }
//                        detail.setItemClass(i.getItemCateCode());
//                        detail.setItemClassName(String.join("/",i.getItemCatePathName()));
//                    }
//                });
//                detail.setItemId(ddo.getItemId());
//                detail.setItemCode(ddo.getItemCode());
//                detail.setItemName(ddo.getItemName());
//                detail.setTaxRate(ddo.getSoTaxRate());
//                detail.setTotalAmount(ddo.getReceiptAmt());
//                detail.setAmt(ddo.getReceiptAmt());
//                detail.setTax(ddo.getReceiptTax());
//                detail.setShoppingCardAmt(BigDecimal.ZERO);
//                detail.setBillCouponAmt(BigDecimal.ZERO);
//                detail.setScoreAmount(BigDecimal.ZERO);
//                detail.setCouponAmount(BigDecimal.ZERO);
//                detail.setRemark(ddo.getRemark());
//                detail.setUom(ddo.getSoUom());
//                list.add(detail);
//            });
//            dto.setDetails(list);
//        }
//        return dto;
        return null;
    }

    private void setSettledd(SalReceiptStatementDTO statementDTO){
        SalReceiptSettleDO settleDO = new SalReceiptSettleDO();
        salReceiptSettleRepo.save(settleDO);
        SalReceiptSettleitemDO settleitemDO = new SalReceiptSettleitemDO();
        settleitemDO.setMasId(settleDO.getId());
        salReceiptSettleitemRepo.save(settleitemDO);
        statementDTO.setSourceId(settleDO.getId());

        SalReceiptSettleddDO settleddDO = new SalReceiptSettleddDO();
        settleddDO.setSettleitemId(settleitemDO.getId());
        if(statementDTO.getDetails()!=null && statementDTO.getDetails().size()>0){
            settleddDO.setDocNo(statementDTO.getDetails().get(0).getSoNo());
        }
        settleddDO.setDocId(statementDTO.getReceiptId());
        settleddDO.setDocTime(statementDTO.getProcessTime());
        settleddDO.setPno(statementDTO.getDocNo());
        settleddDO.setOuId(statementDTO.getOuId());
        settleddDO.setOuCode(statementDTO.getOuCode());
        settleddDO.setOuName(statementDTO.getOuName());
        settleddDO.setBuId(statementDTO.getBuId());
        settleddDO.setBuCode(statementDTO.getBuCode());
        settleddDO.setBuName(statementDTO.getBuName());
        settleddDO.setCustId(statementDTO.getCustId());
        settleddDO.setCustCode(statementDTO.getCustCode());
        settleddDO.setCustName(statementDTO.getCustName());
        settleddDO.setDocType(statementDTO.getSettleType());
        settleddDO.setDocType2("B");
        settleddDO.setCardAmt(BigDecimal.ZERO);
        settleddDO.setGiftAmt(BigDecimal.ZERO);
        settleddDO.setCouponAmt(BigDecimal.ZERO);
        settleddDO.setUsepointAmt(BigDecimal.ZERO);
        if(statementDTO.getDetails()!=null && statementDTO.getDetails().size()>0){
            statementDTO.getDetails().forEach(detail -> {
//                int count = salReceiptSettleddRepo.countByDocDId(detail.getReceiptDId());
//                if(count>0){
//                    throw new BusinessException("该单据已存在于salReceiptSettledd");
//                }
                settleddDO.setDocDId(detail.getReceiptDId());
                settleddDO.setItemCat(detail.getItemClass());
                settleddDO.setFinCat(detail.getFinanceClass());
                settleddDO.setItemCode(detail.getItemCode());
                settleddDO.setItemId(detail.getItemId());
                settleddDO.setItemName(detail.getItemName());
                settleddDO.setUom(detail.getUom());
                settleddDO.setTaxRate(detail.getTaxRate());
                settleddDO.setOriginAmt(detail.getAmt());
                settleddDO.setReceiptAmt(detail.getAmt());
                settleddDO.setReceiptTax(detail.getTax());
                settleddDO.setRemark(detail.getRemark());
                salReceiptSettleddRepo.save(settleddDO);
            });
        }else{
//            int count = salReceiptSettleddRepo.countByDocId(statementDTO.getReceiptId());
//            if(count>0){
//                throw new BusinessException("该单据已存在于salReceiptSettledd");
//            }
            salReceiptSettleddRepo.save(settleddDO);
        }
    }

//    private InvCustDTO getInvCustDTO(SalInvApplyRespVO salInvApplyDO, List<SalInvApplydRespVO> detailList){
//        InvCustDTO invCustDTO = new InvCustDTO();
//        invCustDTO.setSourceId(salInvApplyDO.getId().toString());
//        invCustDTO.setSettleEntityId(salInvApplyDO.getOuId());
//        invCustDTO.setSettleEntityName(salInvApplyDO.getOuName());
//        invCustDTO.setSettleEntityCode(salInvApplyDO.getOuCode());
//        invCustDTO.setApplyNo(salInvApplyDO.getDocNo());
//        invCustDTO.setApplyDate(salInvApplyDO.getApplyDate());
//        invCustDTO.setInvAmount(salInvApplyDO.getInvAmt());
//        invCustDTO.setPushMethod(salInvApplyDO.getPushMethod());
//        invCustDTO.setMobile(salInvApplyDO.getPhone());
//        invCustDTO.setEmail(salInvApplyDO.getEmail());
//        invCustDTO.setPurAddress(salInvApplyDO.getInvAddress());
//        invCustDTO.setPurTel(salInvApplyDO.getInvTel());
//        invCustDTO.setPurBankAccountAddress(salInvApplyDO.getInvBankName()+" "+salInvApplyDO.getInvBankAcc());
//        invCustDTO.setPurName(salInvApplyDO.getInvTitle());
//        invCustDTO.setPurTaxNo(salInvApplyDO.getTaxerNo());
//        invCustDTO.setOpenInvType(salInvApplyDO.getOpenType());
//        invCustDTO.setInvType(salInvApplyDO.getInvType());
//        invCustDTO.setRemark(salInvApplyDO.getRemark());
//        invCustDTO.setOrderSource("B");
//        invCustDTO.setCustCode(salInvApplyDO.getCustCode());
//        invCustDTO.setCustId(salInvApplyDO.getCustId());
//        Optional<CrmCustDO> optional = crmCustRepo.findById(salInvApplyDO.getCustId());
//        if(optional.isPresent()){
//            invCustDTO.setAddressNo(""+optional.get().getAddrNo());
//        }
//        if(salInvApplyDO.getOffFlowNo()!=null){
//            List<InvAwaitCustSaveDetailsDTO> detailsDTOS = new ArrayList<>();
//            InvAwaitCustSaveDetailsDTO detailsDTO = new InvAwaitCustSaveDetailsDTO();
//            detailsDTO.setMisId(salInvApplyDO.getId().toString());
//            detailsDTO.setFlowNo(salInvApplyDO.getOffFlowNo());
//            detailsDTO.setBlueInvNo(salInvApplyDO.getOffInvNo());
//            detailsDTO.setBlueInvCode(salInvApplyDO.getOffInvCode());
//            detailsDTOS.add(detailsDTO);
//            invCustDTO.setInvAwaitCustDetailsDTOList(detailsDTOS);
//        }
//        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
//        List<Long> ouIds = new ArrayList<>();
//        ouIds.add(salInvApplyDO.getOuId());
//        orgOuRpcDtoParam.setOuIds(ouIds);
//        List<OrgOuRpcDTO> ouRpcDTOS = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
//        ouRpcDTOS.forEach(ou -> {
//            if(ou.getId().equals(salInvApplyDO.getOuId())){
//                invCustDTO.setSalTaxNo(ou.getTaxerCode());
//                invCustDTO.setSalAddress(ou.getInvAddress());
//                invCustDTO.setSalTel(ou.getInvPicPhone());
//                invCustDTO.setSalBankAccountAddress(ou.getInvBankName()+" "+ou.getInvBankAcc());
//            }
//        });
//        List<Long> sodid = detailList.stream().filter(sod -> sod.getSoDId()!=null).map(SalInvApplydRespVO::getSoDId).collect(Collectors.toList());
//        if(sodid.size()>0){
//            List<SalSoDetailRespDTO> sodList = getSodListBySodId(sodid);
//            detailList.forEach(d -> {
//                sodList.forEach(sod -> {
//                    if(d.getSoDId().equals(sod.getSoDId()))
//                        d.setPrice(sod.getPrice()==null?BigDecimal.ZERO:sod.getPrice());
//                });
//            });
//        }
//        List<InvCustDtlDTO> custList = new ArrayList<>();
//        AtomicReference<BigDecimal> applyAmt = new AtomicReference<>(new BigDecimal(0));
//        detailList.forEach(d -> {
//            InvCustDtlDTO invCustDtlDTO = new InvCustDtlDTO();
//            invCustDtlDTO.setSourceId(d.getId().toString());
//            invCustDtlDTO.setMisId(d.getMasId().toString());
//            if(d.getDoDocNo()!=null)
//                invCustDtlDTO.setRelationNumber(d.getDoDocNo());
//            if(d.getSoNo()!=null)
//                invCustDtlDTO.setRelationNumber(d.getSoNo());
//            if(d.getSoLineNo()!=null)
//                invCustDtlDTO.setLineNo(d.getSoLineNo().intValue());
//            if(d.getPrice()!=null)
//                invCustDtlDTO.setPrice(d.getPrice());
//            invCustDtlDTO.setQty(d.getApplyQty());
//            invCustDtlDTO.setTaxCode(d.getTaxClass());
//            invCustDtlDTO.setTaxName(d.getTaxClassDesc());
//            invCustDtlDTO.setItemCode(d.getItemCode());
//            invCustDtlDTO.setItemName(d.getItemName());
//            invCustDtlDTO.setTaxRate(d.getSoTaxRate());
//            invCustDtlDTO.setTaxAmount(d.getApplyTax());
//            invCustDtlDTO.setUom(d.getSoUom());
//            invCustDtlDTO.setSpec(d.getItemSpec());
//            invCustDtlDTO.setInvNature("0");
//            invCustDtlDTO.setTotalAmount(d.getApplyNetAmt());
//            custList.add(invCustDtlDTO);
//            applyAmt.set(applyAmt.get().add(d.getSoAmt()));
//        });
//        invCustDTO.setOrderAmount(applyAmt.get());
//        invCustDTO.setInvAwaitCustDtlDTOList(custList);
//        return invCustDTO;
//    }

    /**
     * 根据明细id获取销售单明细
     */
    private List<SalSoDetailRespDTO> getSodListBySodId(List<Long> sodIds){
        List<SalSoDetailRespDTO> sodList = new ArrayList<>();
//        if(sodIds.size()>0){
//            SalSoDetailQueryDTO salSoDetailQueryDTO = new SalSoDetailQueryDTO();
//            salSoDetailQueryDTO.setSoDIdList(sodIds);
//            salSoDetailQueryDTO.setSize(10000);
//            ApiResult<PagingVO<SalSoDetailRespDTO>> apiResult = rmiOrderSalSoService.querySalSoDetail(salSoDetailQueryDTO);
//            if(apiResult.getCode()!=200){
//                throw new BusinessException(apiResult.getMsg());
//            }
//            sodList = apiResult.getData().getRecords();
//        }
        return sodList;
    }

    /**
     * 生产消息
     *
     * @param statementDTO
     */
    private Message<SalReceiptStatementDTO> sendMessage(SalReceiptStatementDTO statementDTO) {

        Message<SalReceiptStatementDTO> springMessage =
                MessageBuilder.withPayload(statementDTO)
                        .setHeader(MessageConst.PROPERTY_KEYS, UUIDUtil.getUUID())
                        .setHeader("sale-fin", "sale-fin-sale")
                        .build();

        log.info("[sendMessage]收款结算单发送消息队列, messageId:{}; message payload:{}",
                springMessage.getHeaders().get(MessageConst.PROPERTY_KEYS), JSON.toJSONString(springMessage.getPayload()));

//        boolean sendResult = mySource.ystPurOutput().send(springMessage);
//        if (!sendResult) {
//            throw new BusinessException("生成结算单发送消息失败");
//        }
        return springMessage;
    }
    /**
     * 生产发票消息
     *
     * @param invCustDTO
     */
//    private Message<InvCustDTO> sendInvoice(InvCustDTO invCustDTO) {
//
//        Message<InvCustDTO> springMessage =
//                MessageBuilder.withPayload(invCustDTO)
//                        .setHeader(MessageConst.PROPERTY_KEYS, UUIDUtil.getUUID())
//                        .setHeader("sale-fin", "sale-fin-inv")
//                        .build();
//
//        log.info("[sendMessage]发票发送消息队列, messageId:{}; message payload:{}",
//                springMessage.getHeaders().get(MessageConst.PROPERTY_KEYS), JSON.toJSONString(springMessage.getPayload()));
//
//        boolean sendResult = mySource.ystPurOutput().send(springMessage);
//        if (!sendResult) {
//            throw new BusinessException("发票发送消息失败");
//        }
//        return springMessage;
//    }

}
