package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustSimpleParam;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanInfoSimpleQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanRegionVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsTeamRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerAppSumRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.CrmCustConvert;
import com.elitesland.yst.production.sale.convert.SalesmanInfoConvert;
import com.elitesland.yst.production.sale.dto.SalemanCustDTO;
import com.elitesland.yst.production.sale.dto.SalesmanInfoDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanAPPQueryDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanInfoAPPRespDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.yst.production.sale.dto.save.SalesmanUpdateDTO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepo;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepoProc;
import com.elitesland.yst.production.sale.search.bean.SalesmanInfoSearchBean;
import com.elitesland.yst.production.sale.search.service.SearchBeanService;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Danny.Wang
 * @title SalesmanRpcServiceImpl
 * @Date2023/3/2 10:00
 */
@Service
@Slf4j
@RestController
@RequestMapping(SalesmanRpcService.URI)
public class SalesmanRpcServiceImpl implements SalesmanRpcService{

    @Autowired
    private SalesmanInfoRepo salesmanInfoRepo;
    @Autowired
    private SalesmanInfoRepoProc salesmanInfoRepoProc;
    @Autowired
    private RmiSysUDCService rmiSysUDCService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private SalesmanInfoService salesmanInfoService;
    @Autowired
    private SalesmanInfoServiceImpl salesmanInfoServiceImpl;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    @Autowired
    private CrmCustService crmCustService;
    @Autowired
    private StatisticsDealerService statisticsDealerService;
    @Autowired
    private SaleStatisticsService saleStatisticsService;
    @Autowired
    private SearchBeanService searchBeanService;

    @Override
    public ApiResult<SalesmanInfoDTO> querySalesmanInfo(SalesmanQueryDTO salesmanQueryDTO) {
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        SalesmanInfoDTO salesmanInfoDTO = new SalesmanInfoDTO();
        //id查询
        if (salesmanQueryDTO.getSalesmanId() != null){
            Optional<SalesmanInfoDO> salesmanInfoRepoById = salesmanInfoRepo.findById(salesmanQueryDTO.getSalesmanId());
            if (salesmanInfoRepoById.isEmpty()){
                return ApiResult.fail("未查询到业务员信息");
            }
            SalesmanInfoDO salesmanInfoDO = salesmanInfoRepoById.get();
            salesmanInfoDTO.setId(salesmanInfoDO.getId());
            salesmanInfoDTO.setSalesmanNo(salesmanInfoDO.getSalesmanNo());
            salesmanInfoDTO.setSalesmanType(salesmanInfoDO.getSalesmanType());
            salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDO.getSalesmanType()));
            salesmanInfoDTO.setOuName(salesmanInfoDO.getOuName());
            salesmanInfoDTO.setOuCode(salesmanInfoDO.getOuCode());
            salesmanInfoDTO.setFileCode(salesmanInfoDO.getFileCode());
            ApiResult<List<SysEmployeeDetailDTO>> detailListByCode = employeeRpcService.getDetailListByCode(Set.of(salesmanInfoDO.getSalesmanNo()));
            if (!detailListByCode.isSuccess()){
                return ApiResult.fail("查询员工信息失败");
            }
            List<SysEmployeeDetailDTO> detailDTOS = detailListByCode.getData();
            if (CollUtil.isEmpty(detailDTOS)){
                return ApiResult.ok(salesmanInfoDTO);
            }
            salesmanInfoDTO.setFullName(detailDTOS.get(0).getFullName());
            salesmanInfoDTO.setPhone(detailDTOS.get(0).getPhone());
            salesmanInfoDTO.setOrgId(detailDTOS.get(0).getOrgList().get(0).getOrgId());
            salesmanInfoDTO.setOrgName(detailDTOS.get(0).getOrgList().get(0).getOrgName());
            return ApiResult.ok(salesmanInfoDTO);
        }
        //编码查询
        if (salesmanQueryDTO.getSalesmanCode() != null){
            SalesmanInfoDO salesmanInfoRepoById = salesmanInfoRepo.findBySalesmanNo(salesmanQueryDTO.getSalesmanCode());
            if (Optional.ofNullable(salesmanInfoRepoById).isEmpty()){
                return ApiResult.fail("未查询到业务员信息");
            }
            salesmanInfoDTO.setId(salesmanInfoRepoById.getId());
            salesmanInfoDTO.setSalesmanNo(salesmanInfoRepoById.getSalesmanNo());
            salesmanInfoDTO.setSalesmanType(salesmanInfoRepoById.getSalesmanType());
            salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRepoById.getSalesmanType()));
            salesmanInfoDTO.setOuName(salesmanInfoRepoById.getOuName());
            salesmanInfoDTO.setOuCode(salesmanInfoRepoById.getOuCode());
            salesmanInfoDTO.setFileCode(salesmanInfoRepoById.getFileCode());
            ApiResult<List<SysEmployeeDetailDTO>> detailListByCode = employeeRpcService.getDetailListByCode(Set.of(salesmanInfoRepoById.getSalesmanNo()));
            if (!detailListByCode.isSuccess()){
                return ApiResult.fail("查询员工信息失败");
            }
            List<SysEmployeeDetailDTO> detailDTOS = detailListByCode.getData();
            if (CollUtil.isEmpty(detailDTOS)){
                return ApiResult.ok(salesmanInfoDTO);
            }
            salesmanInfoDTO.setFullName(detailDTOS.get(0).getFullName());
            salesmanInfoDTO.setPhone(detailDTOS.get(0).getPhone());
            salesmanInfoDTO.setOrgId(detailDTOS.get(0).getOrgList().get(0).getOrgId());
            salesmanInfoDTO.setOrgName(detailDTOS.get(0).getOrgList().get(0).getOrgName());
            return ApiResult.ok(salesmanInfoDTO);
        }

        return ApiResult.ok(salesmanInfoDTO);
    }

    @Override
    public ApiResult<List<SalesmanInfoDTO>> querySalesmanInfoList(SalesmanQueryDTO salesmanQueryDTO) {
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        List<SalesmanInfoDTO> list = new ArrayList<>();
        if (salesmanQueryDTO.getSalesmanCodeList() != null) {
            List<SalesmanInfoDO> salesmanInfoDOS = salesmanInfoRepoProc.getByIdByCodes(salesmanQueryDTO.getSalesmanCodeList());
            if (CollUtil.isEmpty(salesmanInfoDOS)) {
                return ApiResult.fail("未查询到业务员信息");
            }
            salesmanInfoDOS.forEach(e -> {
                SalesmanInfoDTO salesmanInfoDTO = new SalesmanInfoDTO();
                salesmanInfoDTO.setId(e.getId());
                salesmanInfoDTO.setSalesmanNo(e.getSalesmanNo());
                salesmanInfoDTO.setSalesmanType(e.getSalesmanType());
                salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(e.getSalesmanType()));
                salesmanInfoDTO.setOuName(e.getOuName());
                salesmanInfoDTO.setOuCode(e.getOuCode());
                salesmanInfoDTO.setFileCode(e.getFileCode());
                ApiResult<List<SysEmployeeDetailDTO>> detailListByCode = employeeRpcService.getDetailListByCode(Set.of(e.getSalesmanNo()));
                if (detailListByCode.isSuccess()) {
                    List<SysEmployeeDetailDTO> detailDTOS = detailListByCode.getData();
                    if (CollUtil.isNotEmpty(detailDTOS)) {
                        salesmanInfoDTO.setFullName(detailDTOS.get(0).getFullName());
                        salesmanInfoDTO.setPhone(detailDTOS.get(0).getPhone());
                        salesmanInfoDTO.setOrgId(detailDTOS.get(0).getOrgList().get(0).getOrgId());
                        salesmanInfoDTO.setOrgName(detailDTOS.get(0).getOrgList().get(0).getOrgName());
                    }
                }
                list.add(salesmanInfoDTO);
            });
        }
        return ApiResult.ok(list);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> updateSalesmanInfo(SalesmanUpdateDTO salesmanUpdateDTO) {
        Long aLong = salesmanInfoRepoProc.updateSalesmanInfo(salesmanUpdateDTO);
        if (aLong < 1){
            return ApiResult.fail("头像信息更新失败");
        }
        Optional<SalesmanInfoDO> salesmanInfoDO = salesmanInfoRepo.findById(salesmanUpdateDTO.getSalesmanId());
        ApiResult<Long> upsert = ApiResult.ok();
        if (salesmanInfoDO.isPresent() && StringUtils.isNotBlank(salesmanUpdateDTO.getPhone())){
            SalesmanInfoDO infoDO = salesmanInfoDO.get();
            EmployeeUpsertDTO employeeUpsertDTO = new EmployeeUpsertDTO();
            employeeUpsertDTO.setPhone(salesmanUpdateDTO.getPhone());
            employeeUpsertDTO.setCode(infoDO.getSalesmanNo());
            ApiResult<SysEmployeeDetailDTO> apiResult = employeeRpcService.getDetailByCode(infoDO.getSalesmanNo());
            SysEmployeeDetailDTO resultData = apiResult.getData();
            if (apiResult.isSuccess() ){
                 upsert = employeeRpcService.updateMobile(resultData.getId(), salesmanUpdateDTO.getPhone(), true);
            }
        }
        return ApiResult.ok(upsert.getData());
    }

    @Override
    public ApiResult<List<SalesmanInfoAPPRespDTO>> salesmanTeam(SalesmanAPPQueryDTO salesmanAPPQueryDTO) {
        return salesmanInfoService.salesmanTeam(salesmanAPPQueryDTO);
    }

    public List<SalesmanInfoAPPRespDTO> assembleUnderlingList(List<EmployeeUnderlingDTO> underlingList,String docMonth, LocalDateTime docTimeStart, LocalDateTime docTimeEnd){
        if (CollectionUtils.isEmpty(underlingList)){
            return Collections.EMPTY_LIST;
        }
        List<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOList = underlingList.stream().map(employeeUnderlingDTO -> {
            SalesmanInfoAPPRespDTO salesmanInfo = new SalesmanInfoAPPRespDTO();
            salesmanInfo.setCode(employeeUnderlingDTO.getCode());
            salesmanInfo.setId(employeeUnderlingDTO.getId());
            salesmanInfo.setFullName(employeeUnderlingDTO.getFullName());
            salesmanInfo.setEnabled(employeeUnderlingDTO.getEnabled());
            salesmanInfo.setPhone(employeeUnderlingDTO.getPhone());
            salesmanInfo.setHasUnder(employeeUnderlingDTO.getHasUnderling());
            return salesmanInfo;
        }).collect(Collectors.toList());
        //组装每个业务员的经销商、门店的团队销售业绩和我的销售业绩
        assembleSalePerformance(salesmanInfoAPPRespDTOList,docMonth, docTimeStart, docTimeEnd);

        return salesmanInfoAPPRespDTOList;
    }

    /**
     * 组装每个业务员的经销商、门店的团队销售业绩和我的销售业绩
     *
     * @param respDTOList 业务员信息对象
     * @param docMonth 统计月份(yyyy-MM)
     * @param docTimeStart 统计时间开始
     * @param docTimeEnd   统计时间结束
     * @return
     */
    public void assembleSalePerformance(List<SalesmanInfoAPPRespDTO> respDTOList, String docMonth, LocalDateTime docTimeStart, LocalDateTime docTimeEnd){
       List<String> codeList = respDTOList.stream().map(SalesmanInfoAPPRespDTO::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
       SaleStatisticsDealerQueryVO statisticsDealerQueryVO = new SaleStatisticsDealerQueryVO();
       statisticsDealerQueryVO.setAgentEmpList(codeList);
       statisticsDealerQueryVO.setDocMonth(docMonth);
       statisticsDealerQueryVO.setDocTimeStart(docTimeStart);
       statisticsDealerQueryVO.setDocTimeEnd(docTimeEnd);
       List<StatisticsDealerAppSumRespVO> dealerSumList = statisticsDealerService.appSumByEmpCode(statisticsDealerQueryVO);

       SaleStatisticsStoreQueryVO statisticsStoreQueryVO = new SaleStatisticsStoreQueryVO();
       statisticsStoreQueryVO.setAgentEmpList(codeList);
       statisticsStoreQueryVO.setDocMonth(docMonth);
       statisticsStoreQueryVO.setDocTimeStart(docTimeStart);
       statisticsStoreQueryVO.setDocTimeEnd(docTimeEnd);
       List<SaleStatisticsTeamRespVO> storeSumList = saleStatisticsService.queryByCodes(statisticsStoreQueryVO);
       respDTOList.forEach(salesmanDTO -> {
           Optional<StatisticsDealerAppSumRespVO> dealerOptional = dealerSumList.stream().filter(respVO -> Objects.equals(respVO.getAgentEmpCode(),salesmanDTO.getCode())).findFirst();
           if (dealerOptional.isPresent()){
               salesmanDTO.setDealerTeamShipQty(dealerOptional.get().getTeamShipTotalQty());
               salesmanDTO.setDealerTeamOrderQty(dealerOptional.get().getTeamOrderTotalQty());
               salesmanDTO.setDealerMyShipQty(dealerOptional.get().getMyShipTotalQty());
               salesmanDTO.setDealerMyOrderQty(dealerOptional.get().getMyOrderTotalQty());
               salesmanDTO.setDealerTotalQty(dealerOptional.get().getDealerTotalQty());
           }
           Optional<SaleStatisticsTeamRespVO> storeOptional = storeSumList.stream().filter(respVO -> Objects.equals(respVO.getAgentEmp(),salesmanDTO.getCode())).findFirst();
           if (storeOptional.isPresent()){
               salesmanDTO.setStoreMyShipQty(storeOptional.get().getPersonalPerformance());
               salesmanDTO.setStoreTeamShipQty(storeOptional.get().getTeamPerformance());
           }
       });

    }

    public MapBuilder setMapBuilder(SalesmanAPPQueryDTO param) {
        MapBuilder whereSqlMapBuilder = MapUtils.builder();

        if (StringUtils.isNotBlank(param.getType())) {
            whereSqlMapBuilder.field(SalesmanInfoSearchBean::getSalesmanType, param.getType()).op(FieldOps.Equal);
        }
        whereSqlMapBuilder.field(SalesmanInfoSearchBean::getEnableStatus, 1).op(FieldOps.Equal);
        return whereSqlMapBuilder;
    }


    @Override
    public ApiResult<SalemanCustDTO> getSalemanCust(Long id) {
        log.info("根据门店查询客户和业务员信息参数 门店id:"+id);
        if(ObjectUtils.isEmpty(id)){
            return ApiResult.ok();
        }
        OrgStoreDetailRpcDTO storeDetail = orgStoreRpcService.get(id);
        log.info("根据门店id查询门店信息参数id:"+id + "返回"+ JSON.toJSONString(storeDetail));
        if(ObjectUtils.isEmpty(storeDetail) || StringUtils.isEmpty(storeDetail.getPcode())){
            log.info("门店信息为空或者pCode为空");
            return ApiResult.ok();
        }
        CrmCustSimpleParam param = new CrmCustSimpleParam();
//        param.setCorOu(storeDetail.getPcode());
        param.setCustCode(storeDetail.getPcode());
        List<LmSaveCustRespVO> list = crmCustService.getCustSimpleByParam(param);
        log.info("根据对应公司查询客户基本信息参数,param:{},返回 list:{}",param,list);
        if(CollectionUtils.isEmpty(list)){
            return ApiResult.ok();
        }
        LmSaveCustRespVO cust = list.get(0);
        log.info("公司对应客户基本信息：-----"+JSON.toJSONString(cust));
        if(ObjectUtils.isEmpty(cust.getAgentEmpId()) || ObjectUtils.isEmpty(cust.getAgentEmpId())){
            SalemanCustDTO s = CrmCustConvert.INSTANCE.dtoConvertLmSaveCustRespVO(cust);
            return ApiResult.ok(s);
        }
        //根据业务员ID查询
        SalesmanLevelInfoDTO salesmanLevel = salesmanInfoService.queryLevelInfo(cust.getAgentEmpId());
        SalemanCustDTO salemanCustDTO = SalesmanInfoConvert.INSTANCE.salesmanCoverLevel(salesmanLevel);
//        BeanUtils.copyProperties(salesmanLevel,salemanCustDTO);
        salemanCustDTO.setPath(salesmanLevel.getSalesman_path());
        salemanCustDTO.setCustAbbr(cust.getCustAbbr());
        salemanCustDTO.setCustName(cust.getCustName());
        salemanCustDTO.setCustCode2(cust.getCustCode2());
        salemanCustDTO.setCustCode(cust.getCustCode());
        salemanCustDTO.setRegion(cust.getRegion());
        salemanCustDTO.setPid(cust.getPid());

        return ApiResult.ok(salemanCustDTO);
    }

    @Override
    public ApiResult<SalesmanLevelInfoDTO> queryLevelInfo(Long id) {
        return ApiResult.ok(salesmanInfoService.queryLevelInfo(id));
    }

    @Override
    public List<SalesmanInfoSimpleRespVO> simpleQuery(SalesmanInfoSimpleQueryVO param) {
        log.info("业务员基本信息查询入参 {}", param);
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        List<SalesmanInfoSimpleRespVO> simpleRespVOS = salesmanInfoRepoProc.simpleQuery(param);
        if (CollUtil.isEmpty(simpleRespVOS)){
            return new ArrayList<>();
        }
        Set<String> codes = simpleRespVOS.stream().map(SalesmanInfoSimpleRespVO::getSalesmanNo).collect(Collectors.toSet());
        ApiResult<List<SysEmployeeDetailDTO>> detailListByCode = employeeRpcService.getDetailListByCode(codes);
        if (!detailListByCode.isSuccess()){
            return simpleRespVOS;
        }
        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = salesmanInfoServiceImpl.getSalesmanRegionMap(regionUDCMap, simpleRespVOS.stream().map(SalesmanInfoSimpleRespVO::getId).collect(Collectors.toList()));
        List<SysEmployeeDetailDTO> employeeDetailDTOS = detailListByCode.getData();
        Map<String, SysEmployeeDetailDTO> detailDTOMap = employeeDetailDTOS.stream().collect(Collectors.toMap(SysEmployeeDetailDTO::getCode, v -> v, (v1, v2) -> v1));
        for (SalesmanInfoSimpleRespVO simpleRespVO : simpleRespVOS) {
            SysEmployeeDetailDTO employeeDetailDTO = detailDTOMap.get(simpleRespVO.getSalesmanNo());
            if (Optional.ofNullable(employeeDetailDTO).isPresent()) {
                simpleRespVO.setFullName(employeeDetailDTO.getFullName());
                simpleRespVO.setAreaVO(employeeDetailDTO.getAreaVO());
                simpleRespVO.setAddress(employeeDetailDTO.getAddress());
                simpleRespVO.setPhone(employeeDetailDTO.getPhone());
            }
            simpleRespVO.setJurisdiction(salesmanRegionMap.get(simpleRespVO.getId()));
            simpleRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(simpleRespVO.getSalesmanType()));
        }
        return simpleRespVOS;
    }

    @Override
    public ApiResult<List<SalesmanInfoDTO>> querySalesmanInfoByIds(SalesmanQueryDTO salesmanQueryDTO) {
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        List<SalesmanInfoDTO> list = new ArrayList<>();
        if (CollUtil.isNotEmpty(salesmanQueryDTO.getSalesmanIdList())) {
            List<SalesmanInfoDO> salesmanInfoDOS = salesmanInfoRepoProc.getByIds(salesmanQueryDTO.getSalesmanIdList());
            if (CollUtil.isEmpty(salesmanInfoDOS)) {
                return ApiResult.fail("未查询到业务员信息");
            }
            salesmanInfoDOS.forEach(e -> {
                SalesmanInfoDTO salesmanInfoDTO = new SalesmanInfoDTO();
                salesmanInfoDTO.setId(e.getId());
                salesmanInfoDTO.setSalesmanNo(e.getSalesmanNo());
                salesmanInfoDTO.setSalesmanType(e.getSalesmanType());
                salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(e.getSalesmanType()));
                salesmanInfoDTO.setOuName(e.getOuName());
                salesmanInfoDTO.setOuCode(e.getOuCode());
                salesmanInfoDTO.setFileCode(e.getFileCode());
                ApiResult<List<SysEmployeeDetailDTO>> detailListByCode = employeeRpcService.getDetailListByCode(Set.of(e.getSalesmanNo()));
                if (detailListByCode.isSuccess()) {
                    List<SysEmployeeDetailDTO> detailDTOS = detailListByCode.getData();
                    if (CollUtil.isNotEmpty(detailDTOS)) {
                        salesmanInfoDTO.setFullName(detailDTOS.get(0).getFullName());
                        salesmanInfoDTO.setPhone(detailDTOS.get(0).getPhone());
                        salesmanInfoDTO.setOrgId(detailDTOS.get(0).getOrgList().get(0).getOrgId());
                        salesmanInfoDTO.setOrgName(detailDTOS.get(0).getOrgList().get(0).getOrgName());
                    }
                }
                list.add(salesmanInfoDTO);
            });
        }
        return ApiResult.ok(list);
    }
}
