package com.elitesland.yst.production.sale.service;

import com.elitesland.yst.production.sale.api.service.TaskInfoService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.dataturbo.annotation.DataTurboTransfer;
import com.elitesland.yst.dataturbo.service.DataTurboTransferService;
import com.elitesland.yst.dataturbo.service.param.DataTurboProcessParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 功能说明:任务是否逾期定时任务
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/17
 * @Version 1.0
 * @Content:
 */
@Service
@Slf4j
@DataTurboTransfer("sale_task_whether_overdue")
public class TaskWhetherOverdueTransferServiceImpl implements DataTurboTransferService {
    @Autowired
    private TaskInfoService taskInfoService;

    @Override
    public Object transfer(DataTurboProcessParam param) {
        log.info("任务是否逾期DataTurbo参数,时间：{},信息：{}", param);
        TaskInfoQueryVO queryVO = new TaskInfoQueryVO();
        taskInfoService.overdueTask(queryVO);
        return new Object();
    }


}
