package com.elitesland.yst.production.sale.service.shop;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCustUserBineSimpleRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.dto.save.BipOrderRpcDto;
import com.elitesland.yst.production.sale.entity.BipMessageDO;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.service.BipOrderRpcService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.record.DVALRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/10/07/12:45
 * @Description:
 */
@Service
@Slf4j
@RestController
@RequestMapping(BipOrderRpcService.URI)
public class BipOrderRpcServiceImpl  implements BipOrderRpcService {

    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;
    @Autowired
    private BipOrderDRepo bipOrderDRepo;

    @Autowired
    private BipOrderRepo bipOrderRepo;

    @Autowired
    private BipMessageRepo bipMessageRepo;

    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @Override
    public ApiResult updateOrderLogistInfo(List<BipOrderRpcDto> bipOrderRpcDtoList) {

        List<BipOrderDDO> bipOrderDDOS=new ArrayList<>();
       for(BipOrderRpcDto bipOrderRpcDto:bipOrderRpcDtoList){
           if(bipOrderRpcDto.getOrderDId()==null){
               throw new BusinessException("明细ID不能为空!");
           }
           BipOrderDDO bipOrderDDo=bipOrderDRepo.findById(bipOrderRpcDto.getOrderDId()).get();
           bipOrderDDo.setLogisNo(bipOrderRpcDto.getLogistNo());
           bipOrderDDo.setLogisId(bipOrderRpcDto.getLogistId());
           bipOrderDDOS.add(bipOrderDDo);
       }

        bipOrderDRepo.saveAll(bipOrderDDOS);
       return ApiResult.ok();
    }

    @Override
    public ApiResult updateorderStatus(BipOrderRpcDto bipOrderRpcDto) {

        if(bipOrderRpcDto.getId()==null){
            throw new BusinessException("退货主表ID不能为空!");
        }

        if(StringUtils.isBlank(bipOrderRpcDto.getStatus())){
            throw new BusinessException("退货主表状态不能为空!");
        }
        log.info("远程同步退货单状态参数信息:"+ JSON.toJSONString(bipOrderRpcDto));
        bipOrderRepoProc.updatStatusByIdAndStatus(bipOrderRpcDto.getId(),bipOrderRpcDto.getStatus());
        return ApiResult.ok();

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult shipMentMessagePush(List<String> bipShipMentOrderCodes) {
        log.info("发货消息推送订单编码入参{}", JSON.toJSONString(bipShipMentOrderCodes));
        List<BipOrderDO> bipOrderDOS = bipOrderRepo.findAllByDocNoIn(bipShipMentOrderCodes);
        List<Long> custIds = bipOrderDOS.stream().map(BipOrderDO::getCustId).distinct().filter(Objects::nonNull)
                .collect(Collectors.toList());
        List<BipCustUserBineSimpleRespVO> userIdByCustId = bipCustUserBindRepoProc.getUserIdByCustId(custIds);
        List<BipMessageDO> bipMessageDOS = bipOrderDOS.stream().map(mes -> {
            BipMessageDO bipMessageDO = new BipMessageDO();
            bipMessageDO.setTitle("【发货通知】");
            bipMessageDO.setContext("您有订单已发货");
            bipMessageDO.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            Optional<BipCustUserBineSimpleRespVO> simpleRespVO = userIdByCustId.stream().filter(user -> user.getCustId().equals(mes.getCustId()))
                    .findFirst();
            if (simpleRespVO.isPresent()){
                bipMessageDO.setToCustId(simpleRespVO.get().getUserId());
            }else{
                throw new BusinessException("订单【"+mes.getDocNo()+"】的客户未绑定用户");
            }
            return bipMessageDO;
        }).collect(Collectors.toList());
        bipMessageRepo.saveAll(bipMessageDOS);
        return null;
    }

    @Override
    public ApiResult updateOrderIsSend(List<String> orderCodes) {
        try {
            bipOrderRepoProc.updateOrderIsSend(orderCodes);
        }catch (Exception e){
            log.info("OMS调用同步订单是否发货状态字段异常"+e);
            throw new BusinessException("操作失败:"+e.getMessage());
        }
        return ApiResult.ok();
    }
}
