/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.sal;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SalQuotationService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalQuotationQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationPageRespVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sal/quotation"}, produces={"application/json"})
@Api(tags={"\u9500\u552e\u62a5\u4ef7\u4e3b\u8868"})
public class SalQuotationController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(SalQuotationController.class);
    private final SalQuotationService salQuotationService;

    public SalQuotationController(SalQuotationService salQuotationService) {
        this.salQuotationService = salQuotationService;
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u9500\u552e\u62a5\u4ef7\u4e3b\u6570\u636e")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<SalQuotationPageRespVO>> search(@RequestBody SalQuotationQueryParamVO searchParam) {
        return ApiResult.ok((Object)this.salQuotationService.search(searchParam));
    }

    @PostMapping(value={"/submitSalQuotation"})
    @ApiOperation(value="\u63d0\u4ea4\u9500\u552e\u62a5\u4ef7\u4fe1\u606f")
    @ApiOperationSupport(order=7)
    public ApiResult<Long> submitSalQuotation(@RequestBody SalQuotationDetailRespVO salQuotationDetailRespVO) {
        return ApiResult.ok((Object)this.salQuotationService.submitSalQuotation(salQuotationDetailRespVO));
    }

    @PostMapping(value={"/exportData"})
    @ApiOperation(value="\u9500\u552e\u62a5\u4ef7\u5355\u5bfc\u51fa")
    @ApiOperationSupport(order=5)
    public ApiResult<Long> exportSalQuotation(HttpServletResponse response, @RequestBody SalQuotationQueryParamVO salQuotationQueryParamVO) {
        ArrayList<ExportColumnParam> columnParamList = new ArrayList<ExportColumnParam>(16);
        columnParamList.add(new ExportColumnParam("ouName", "\u516c\u53f8\u540d\u79f0"));
        columnParamList.add(new ExportColumnParam("agentEmpName", "\u4e1a\u52a1\u5458"));
        columnParamList.add(new ExportColumnParam("docNo", "\u62a5\u4ef7\u5355\u53f7"));
        columnParamList.add(new ExportColumnParam("quotationDate2", "\u62a5\u4ef7\u65e5\u671f"));
        columnParamList.add(new ExportColumnParam("custCode", "\u5ba2\u6237\u7f16\u7801"));
        columnParamList.add(new ExportColumnParam("custName", "\u5ba2\u6237\u540d\u79f0"));
        columnParamList.add(new ExportColumnParam("custContactName", "\u5ba2\u6237\u8054\u7cfb\u4eba"));
        columnParamList.add(new ExportColumnParam("custContactTel", "\u5ba2\u6237\u8054\u7cfb\u4eba\u7535\u8bdd"));
        columnParamList.add(new ExportColumnParam("itemCode", "\u5546\u54c1\u7f16\u7801"));
        columnParamList.add(new ExportColumnParam("itemName", "\u5546\u54c1\u540d\u79f0"));
        columnParamList.add(new ExportColumnParam("itemSpec", "\u89c4\u683c\u578b\u53f7"));
        columnParamList.add(new ExportColumnParam("qty", "\u6570\u91cf"));
        columnParamList.add(new ExportColumnParam("uomName", "\u8ba1\u91cf\u5355\u4f4d"));
        columnParamList.add(new ExportColumnParam("price", "\u542b\u7a0e\u5355\u4ef7"));
        columnParamList.add(new ExportColumnParam("amt", "\u542b\u7a0e\u91d1\u989d"));
        columnParamList.add(new ExportColumnParam("taxRate2", "\u7a0e\u7387"));
        columnParamList.add(new ExportColumnParam("remark", "\u5907\u6ce8"));
        try {
            this.export(response, "\u53d1\u8d27\u5355\u5bfc\u51fa\u6570\u636e", columnParamList, paramVO -> (PagingVO)this.salQuotationService.searchForExport(paramVO).getData(), salQuotationQueryParamVO);
        }
        catch (Exception e) {
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25");
        }
        return ApiResult.ok();
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="\u67e5\u8be2\u9500\u552e\u62a5\u4ef7\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperationSupport(order=2)
    public ApiResult<SalQuotationDetailRespVO> getSalQuotationById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.salQuotationService.findSalQuotationById(id));
    }

    @PostMapping(value={"/createSalQuotation"})
    @ApiOperation(value="\u4fdd\u5b58\u9500\u552e\u62a5\u4ef7\u4fe1\u606f")
    @ApiOperationSupport(order=3)
    public ApiResult<Long> createSalQuotation(@RequestBody SalQuotationDetailRespVO salQuotationDetailRespVO) {
        return ApiResult.ok((Object)this.salQuotationService.createSalQuotation(salQuotationDetailRespVO));
    }
}

