/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.event.listener;

import com.elitesland.yst.production.sale.api.dto.PriceAlterDTO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.event.ItemPriceAlterEvent;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ItemPriceAlterListener
implements ApplicationListener<ItemPriceAlterEvent> {
    private static final Logger log = LoggerFactory.getLogger(ItemPriceAlterListener.class);
    @Autowired
    private BipItemSkuRepoProc bipItemSkuRepoProc;
    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;

    public void onApplicationEvent(ItemPriceAlterEvent event) {
        log.info("\u76d1\u542c\u5230\u4ef7\u683c\u53d8\u66f4\u4e8b\u4ef6\uff1a{}", event.getPriceAlterDTOS());
        CompletableFuture.runAsync(() -> this.handlePriceAlter(event)).exceptionally(e -> {
            log.error("\u5904\u7406\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e8b\u4ef6\u5931\u8d25", e);
            return null;
        });
    }

    private void handlePriceAlter(ItemPriceAlterEvent event) {
        for (PriceAlterDTO alterDTO : event.getPriceAlterDTOS()) {
            BipItemSkuDO sku = this.bipItemSkuRepoProc.findSkuOnOuId(alterDTO.getOuId(), alterDTO.getSkuCode());
            if (sku == null) continue;
            sku.setPriceOld(sku.getPrice());
            sku.setPrice(alterDTO.getPrice());
            this.bipItemSkuRepo.save(sku);
        }
    }
}

