/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.BipCustUserBindPageQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCustUserBindPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCustUserBineSimpleRespVO;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.QBipCustUserBindDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class BipCustUserBindRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QBipCustUserBindDO DO = QBipCustUserBindDO.bipCustUserBindDO;

    public BipCustUserBindRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    public void updateUserId(Long id, Long userId) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipCustUserBindRepoProc.DO.userId, (Object)userId).where(new Predicate[]{BipCustUserBindRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public BipCustUserBindDO getByUserId(Long userId) {
        return (BipCustUserBindDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipCustUserBindRepoProc.DO.userId.eq((Object)userId))).limit(1L)).fetchOne();
    }

    public List<BipCustUserBindDO> getAllByUserIds(List<Long> userIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipCustUserBindRepoProc.DO.userId.in(userIds))).fetch();
    }

    public List<BipCustUserBindDO> getAllByEmpIds(List<Long> empIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipCustUserBindRepoProc.DO.custId.in(empIds))).where((Predicate)BipCustUserBindRepoProc.DO.deleteFlag.eq((Object)0))).fetch();
    }

    public Long getCustIdByUserId(Long userId) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipCustUserBindRepoProc.DO.custId).from((EntityPath)DO)).where((Predicate)BipCustUserBindRepoProc.DO.userId.eq((Object)userId))).limit(1L)).fetchOne();
    }

    public JPAQuery<BipCustUserBindPageRespVO> select(BipCustUserBindPageQueryVO queryParam) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipCustUserBindPageRespVO.class, (Expression[])new Expression[]{BipCustUserBindRepoProc.DO.id, BipCustUserBindRepoProc.DO.userId, BipCustUserBindRepoProc.DO.username, BipCustUserBindRepoProc.DO.custId, BipCustUserBindRepoProc.DO.custCode, BipCustUserBindRepoProc.DO.custName, BipCustUserBindRepoProc.DO.taxRegNo, BipCustUserBindRepoProc.DO.contactName, BipCustUserBindRepoProc.DO.contactPhone, BipCustUserBindRepoProc.DO.ouId, BipCustUserBindRepoProc.DO.agentEmpId, BipCustUserBindRepoProc.DO.state, BipCustUserBindRepoProc.DO.stateApply, BipCustUserBindRepoProc.DO.timeRegister, BipCustUserBindRepoProc.DO.certFileCode})).from((EntityPath)DO)).where((Predicate)BipCustUserBindRepoProc.DO.deleteFlag.eq((Object)0));
        if (queryParam != null) {
            jpaQuery.where(this.buildCondition(queryParam));
        }
        return jpaQuery;
    }

    private Predicate buildCondition(BipCustUserBindPageQueryVO queryParam) {
        BooleanExpression predicate = DO.isNotNull();
        if (queryParam.getUserId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.userId.eq((Object)queryParam.getUserId()));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getUsername())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.username.like("%" + queryParam.getUsername() + "%"));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getCustCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.custCode.like("%" + queryParam.getCustCode() + "%"));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getCustName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.custName.like("%" + queryParam.getCustName() + "%"));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getState())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.state.eq((Object)queryParam.getState()));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getStateApply())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.stateApply.eq((Object)queryParam.getStateApply()));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getTaxRegNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.taxRegNo.like("%" + queryParam.getTaxRegNo() + "%"));
        }
        if (queryParam.getTimeRegister() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.timeRegister.between((Comparable)queryParam.getTimeRegister().toLocalDate().atTime(LocalTime.MIN), (Comparable)queryParam.getTimeRegister().toLocalDate().atTime(LocalTime.MAX)));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getContactName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.contactName.like("%" + queryParam.getContactName() + "%"));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getContactPhone())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.contactPhone.like("%" + queryParam.getContactPhone() + "%"));
        }
        if (queryParam.getOuId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.ouId.eq((Object)queryParam.getOuId()));
        }
        if (queryParam.getAgentEmpId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipCustUserBindRepoProc.DO.agentEmpId.eq((Object)queryParam.getAgentEmpId()));
        }
        return predicate;
    }

    public void updateStateApplyBatch(List<Long> ids, String state, String stateApply, Long agentEmpId, LocalDateTime timeApply) {
        this.jpaQueryFactory.update((EntityPath)DO).set((Path)BipCustUserBindRepoProc.DO.state, (Object)state).set((Path)BipCustUserBindRepoProc.DO.stateApply, (Object)stateApply).set(BipCustUserBindRepoProc.DO.timeApply, (Object)timeApply).set(BipCustUserBindRepoProc.DO.agentEmpId, (Object)agentEmpId).where(new Predicate[]{BipCustUserBindRepoProc.DO.id.in(ids)}).execute();
    }

    public void updateStateBatch(List<Long> ids, Long agentEmpId, String state) {
        this.jpaQueryFactory.update((EntityPath)DO).set((Path)BipCustUserBindRepoProc.DO.state, (Object)state).set(BipCustUserBindRepoProc.DO.agentEmpId, (Object)agentEmpId).where(new Predicate[]{BipCustUserBindRepoProc.DO.id.in(ids)}).execute();
    }

    public List<BipCustUserBineSimpleRespVO> getUserIdByCustId(List<Long> custIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BipCustUserBindRepoProc.DO.userId, BipCustUserBindRepoProc.DO.custId}).from((EntityPath)DO)).where((Predicate)BipCustUserBindRepoProc.DO.custId.in(custIds).and((Predicate)BipCustUserBindRepoProc.DO.deleteFlag.ne((Object)1)))).fetch().parallelStream().map(tuple -> {
            BipCustUserBineSimpleRespVO bipCustUserBineSimpleRespVO = new BipCustUserBineSimpleRespVO();
            bipCustUserBineSimpleRespVO.setUserId((Long)tuple.get(BipCustUserBindRepoProc.DO.userId));
            bipCustUserBineSimpleRespVO.setCustId((Long)tuple.get(BipCustUserBindRepoProc.DO.custId));
            return bipCustUserBineSimpleRespVO;
        }).collect(Collectors.toList());
    }
}

