/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RmiSysAreaRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiSysAreaRpcService.class);
    @Autowired
    private SysAreaRpcService sysAreaRpcService;

    public List<SysAreaRespDTO> findAreaByCodes(Set<String> areaCodes) {
        log.info("\u8c03\u7528system\u57df:\u6839\u636e\u7f16\u53f7\u67e5\u8be2\u884c\u653f\u533a\u57df,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), areaCodes);
        try {
            if (CollectionUtils.isEmpty(areaCodes)) {
                return Collections.emptyList();
            }
            ApiResult apiResult = this.sysAreaRpcService.listByAreaCodes(areaCodes);
            log.info("\u8c03\u7528system\u57df:\u6839\u636e\u7f16\u53f7\u67e5\u8be2\u884c\u653f\u533a\u57df,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (List)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528system\u57df:\u6839\u636e\u7f16\u53f7\u67e5\u8be2\u884c\u653f\u533a\u57df,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528system\u57df:" + e.getMessage());
        }
    }
}

