/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.search.service.impl;

import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerDtlService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.BaseModelVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerRepoProc;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerRepoSqlProc;
import com.elitesland.yst.production.sale.search.bean.BasicsBean;
import com.elitesland.yst.production.sale.search.bean.StatisticsDealerDtlSearchBean;
import com.elitesland.yst.production.sale.search.bean.StatisticsDealerSearchBean;
import com.elitesland.yst.production.sale.search.service.SearchBeanService;
import com.elitesland.yst.production.sale.search.service.StatisticsDealerSearchService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StatisticsDealerSearchServiceImpl
implements StatisticsDealerSearchService {
    @Autowired
    private SearchBeanService searchBeanService;
    @Autowired
    private StatisticsDealerDtlService statisticsDealerDtlService;
    @Autowired
    private SaleStatisticsDealerRepo saleStatisticsDealerRepo;
    @Autowired
    private SaleStatisticsDealerRepoProc statisticsDealerRepoProc;
    @Autowired
    private SaleStatisticsDealerRepoSqlProc saleStatisticsDealerRepoSqlProc;

    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsDealerRespVO> page(SaleStatisticsDealerQueryVO pageParam) {
        this.assembleDocTime(pageParam);
        PagingVO<SaleStatisticsDealerRespVO> pagingVO = this.statisticsDealerRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List respVOList = pagingVO.getRecords();
        this.translateDealer(respVOList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(respVOList).build();
    }

    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsDealerRespVO> appPage(SaleStatisticsDealerQueryVO pageParam) {
        this.assembleDocTime(pageParam);
        PagingVO<SaleStatisticsDealerRespVO> pagingVO = this.statisticsDealerRepoProc.appPage(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List respVOList = pagingVO.getRecords();
        this.translateDealer(respVOList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(respVOList).build();
    }

    @Override
    public StatisticsDealerSumRespVO pageSum(SaleStatisticsDealerQueryVO pageParam) {
        StatisticsDealerSumRespVO sumRespVO = new StatisticsDealerSumRespVO();
        this.assembleDocTime(pageParam);
        StatisticsDealerSumRespVO dealerSumRespVO = this.saleStatisticsDealerRepoSqlProc.pageSum2(pageParam);
        if (Objects.isNull(dealerSumRespVO)) {
            return sumRespVO;
        }
        return dealerSumRespVO;
    }

    @Override
    public StatisticsDealerSumRespVO appPageSum(SaleStatisticsDealerQueryVO pageParam) {
        StatisticsDealerSumRespVO sumRespVO = new StatisticsDealerSumRespVO();
        this.assembleDocTime(pageParam);
        StatisticsDealerSumRespVO dealerSumRespVO = this.saleStatisticsDealerRepoSqlProc.pageSum2(pageParam);
        if (Objects.isNull(dealerSumRespVO)) {
            return sumRespVO;
        }
        return dealerSumRespVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsDealerRespVO> appDetails(SaleStatisticsDealerQueryVO pageParam) {
        if (pageParam.getId() != null) {
            Optional byId = this.saleStatisticsDealerRepo.findById(pageParam.getId());
            if (byId.isPresent()) {
                pageParam.setRegion(((SaleStatisticsDealerDO)((Object)byId.get())).getRegion());
                pageParam.setSalesmanPath(((SaleStatisticsDealerDO)((Object)byId.get())).getSalesmanPath());
                pageParam.setDealerCode(((SaleStatisticsDealerDO)((Object)byId.get())).getDealerCode());
                pageParam.setDocTimeStart(LocalDateTime.of(((SaleStatisticsDealerDO)((Object)byId.get())).getDocTime().toLocalDate(), LocalTime.MIN));
                pageParam.setDocTimeEnd(LocalDateTime.of(((SaleStatisticsDealerDO)((Object)byId.get())).getDocTime().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX));
            }
            pageParam.setId(null);
        }
        this.appDetailsCheck(pageParam);
        if (StringUtils.isBlank((CharSequence)pageParam.getRegion())) {
            pageParam.setRegionFlag(Integer.valueOf(1));
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getAgentEmp())) {
            pageParam.setSalesmanPathFlag(Integer.valueOf(1));
        }
        pageParam.setSize(Integer.valueOf(100));
        PagingVO<SaleStatisticsDealerRespVO> pagingVO = this.statisticsDealerRepoProc.appDetailsPage(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return pagingVO;
    }

    private MapBuilder setMapBuilder(SaleStatisticsDealerQueryVO queryVO) {
        MapBuilder whereSqlMapBuilder = MapUtils.builder().page((long)queryVO.getPageRequest().getPageNumber(), queryVO.getPageRequest().getPageSize());
        ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getDeleteFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        if (!Objects.isNull(queryVO.getId())) {
            ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getId, new Object[]{queryVO.getId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getIds())) {
            ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getId, (Collection)queryVO.getIds())).op((FieldOp)FieldOps.InList);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerCode())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, new Object[]{queryVO.getDealerCode()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getDealerCodeList())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, (Collection)queryVO.getDealerCodeList())).op((FieldOp)FieldOps.InList);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerCodeKeyword())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, new Object[]{queryVO.getDealerCodeKeyword()})).op((FieldOp)FieldOps.Contain);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerName())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerName, new Object[]{queryVO.getDealerName()})).op((FieldOp)FieldOps.Contain);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerKeyword())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, new FieldFns.FieldFn[]{StatisticsDealerSearchBean::getDealerName})).sql("$1 like '%?' or $2 like '%?' ", new Object[]{queryVO.getDealerKeyword(), queryVO.getDealerKeyword()});
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getKeyword())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, new FieldFns.FieldFn[]{StatisticsDealerSearchBean::getDealerName})).sql("$1 like '%?' or $2 like '%?' ", new Object[]{queryVO.getKeyword(), queryVO.getKeyword()});
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerSerialNo())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerSerialNo, new Object[]{queryVO.getDealerSerialNo()})).op((FieldOp)FieldOps.Contain);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerSerialNo1())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerSerialNo, new Object[]{queryVO.getDealerSerialNo1()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getRegion())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getRegion, new Object[]{queryVO.getRegion()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getRegionList())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getRegion, (Collection)queryVO.getRegionList())).op((FieldOp)FieldOps.InList);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getType())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getType, new Object[]{queryVO.getType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getTypeList())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getType, (Collection)queryVO.getTypeList())).op((FieldOp)FieldOps.InList);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getSalesmanPath())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getSalesmanPath, new Object[]{queryVO.getSalesmanPath()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getVehicleType())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getVehicleType, new Object[]{queryVO.getVehicleType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getVehicleTypeList())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getVehicleType, (Collection)queryVO.getVehicleTypeList())).op((FieldOp)FieldOps.InList);
        }
        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocTime, new Object[]{queryVO.getDocTimeStart(), queryVO.getDocTimeEnd()})).op((FieldOp)FieldOps.Between);
        } else {
            if (queryVO.getDocTimeStart() != null) {
                ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocTime, new Object[]{queryVO.getDocTimeStart()})).op((FieldOp)FieldOps.GreaterEqual);
            }
            if (queryVO.getDocTimeEnd() != null) {
                ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocTime, new Object[]{queryVO.getDocTimeEnd()})).op((FieldOp)FieldOps.LessEqual);
            }
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocMonth, new Object[]{queryVO.getDocMonth()})).op((FieldOp)FieldOps.Equal);
        }
        if (Objects.nonNull(queryVO.getDocTime())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocDate, new Object[]{queryVO.getDocTime().toLocalDate().toString()})).op((FieldOp)FieldOps.Equal);
        }
        if (!Objects.isNull(queryVO.getShipQty())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getShipQty, new Object[]{queryVO.getShipQty()})).op((FieldOp)FieldOps.Equal);
        }
        if (!Objects.isNull(queryVO.getOrderQty())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getOrderQty, new Object[]{queryVO.getOrderQty()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getCustType())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getCustType, new Object[]{queryVO.getCustType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getCustTypes())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getCustType, (Collection)queryVO.getCustTypes())).op((FieldOp)FieldOps.InList);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getItemType3())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getItemType3, new Object[]{queryVO.getItemType3()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getItemType3List())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsDealerSearchBean::getItemType3, (Collection)queryVO.getItemType3List())).op((FieldOp)FieldOps.InList);
        }
        return whereSqlMapBuilder;
    }

    private MapBuilder setDtlMapBuilder(SaleStatisticsDealerDtlQueryVO queryVO) {
        MapBuilder whereSqlMapBuilderDtl = MapUtils.builder();
        ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getDeleteFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        if (!Objects.isNull(queryVO.getUserId())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getUserId, new Object[]{queryVO.getUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getLevel())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getLevel, new Object[]{queryVO.getLevel()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getLevels())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getLevel, (Collection)queryVO.getLevels())).op((FieldOp)FieldOps.InList);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getCode())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getCode, new Object[]{queryVO.getCode()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getCodes())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getCode, (Collection)queryVO.getCodes())).op((FieldOp)FieldOps.InList);
        }
        return whereSqlMapBuilderDtl;
    }

    public void assembleDocTime(SaleStatisticsDealerQueryVO pageParam) {
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7edf\u8ba1\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (Objects.nonNull(pageParam.getDocTimeStart())) {
            LocalDate localDateStart = pageParam.getDocTimeStart().toLocalDate();
            LocalDateTime minTime = LocalDateTime.of(localDateStart, LocalTime.MIN);
            pageParam.setDocTimeStart(minTime);
        }
        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
            LocalDate localDateEnd = pageParam.getDocTimeEnd().toLocalDate();
            LocalDateTime maxTime = LocalDateTime.of(localDateEnd, ConstantsSale.LOCAL_TIME_MAX);
            pageParam.setDocTimeEnd(maxTime);
        }
    }

    private void translateDealer(List<SaleStatisticsDealerRespVO> respVOList) {
        List<Long> idList = respVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SaleStatisticsDealerDtlRespVO> dtlRespVOList = this.selectDtlByMasId(idList);
        respVOList.forEach(respVO -> {
            List dtlRespVOS = dtlRespVOList.stream().filter(dtlRespVO -> Objects.equals(dtlRespVO.getMasId(), respVO.getId())).collect(Collectors.toList());
            respVO.setDtlRespVOS(dtlRespVOS);
            String docMonth = respVO.getDocTime().format(DateTimeFormatter.ofPattern("yyyy-MM"));
            respVO.setDocMonth(docMonth);
            respVO.setDocDay(respVO.getDocTime().toLocalDate().toString());
            dtlRespVOS.stream().forEach(dtlRespVO -> {
                StringJoiner spliceName = new StringJoiner(" ").add(dtlRespVO.getTypeName()).add(dtlRespVO.getName());
                if (Objects.equals("0", dtlRespVO.getLevel())) {
                    respVO.setAgentEmp(dtlRespVO.getCode());
                    respVO.setAgentEmpName(spliceName.toString());
                } else if (Objects.equals("1", dtlRespVO.getLevel())) {
                    respVO.setLevelOne(spliceName.toString());
                } else if (Objects.equals("2", dtlRespVO.getLevel())) {
                    respVO.setLevelTwo(spliceName.toString());
                } else if (Objects.equals("3", dtlRespVO.getLevel())) {
                    respVO.setLevelThree(spliceName.toString());
                } else if (Objects.equals("4", dtlRespVO.getLevel())) {
                    respVO.setLevelFour(spliceName.toString());
                } else if (Objects.equals("5", dtlRespVO.getLevel())) {
                    respVO.setLevelFive(spliceName.toString());
                }
            });
        });
    }

    private List<SaleStatisticsDealerDtlRespVO> selectDtlByMasId(List<Long> masIds) {
        if (CollectionUtils.isEmpty(masIds)) {
            return Collections.EMPTY_LIST;
        }
        SaleStatisticsDealerDtlQueryVO dtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
        dtlQueryVO.setMasIds(masIds);
        List dtlRespVOList = this.statisticsDealerDtlService.selectByParam(dtlQueryVO);
        if (CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlRespVOList;
    }

    private void appDetailsCheck(SaleStatisticsDealerQueryVO pageParam) {
        if (StringUtils.isBlank((CharSequence)pageParam.getDealerCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7edf\u8ba1\u65f6\u95f4\u4e3a\u7a7a!");
        }
    }
}

