/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitesland.yst.production.order.param.SalDoDQueryDTO;
import com.elitesland.yst.production.order.param.SalDoDRPCRespDTO;
import com.elitesland.yst.production.order.param.SalSoDQueryDTO;
import com.elitesland.yst.production.order.param.SalSoDRefundRespDTO;
import com.elitesland.yst.production.order.param.SalSoDUpdateDTO;
import com.elitesland.yst.production.order.param.SalSoDetailQueryDTO;
import com.elitesland.yst.production.order.param.SalSoDetailRespDTO;
import com.elitesland.yst.production.order.service.SalSoRpcService;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.SalReceiptService;
import com.elitesland.yst.production.sale.api.service.shop.SalReceiptStateService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalReceiptPageParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalReceiptSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptdRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.QSalReceiptDO;
import com.elitesland.yst.production.sale.entity.SalReceiptDDO;
import com.elitesland.yst.production.sale.entity.SalReceiptDO;
import com.elitesland.yst.production.sale.repo.SalInvApplyRepoProc;
import com.elitesland.yst.production.sale.repo.SalInvApplydRepoProc;
import com.elitesland.yst.production.sale.repo.SalReceiptRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptRepoProc;
import com.elitesland.yst.production.sale.repo.SalReceiptdRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptdRepoProc;
import com.elitesland.yst.production.sale.repo.SalSoaRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoDRpcService;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoDService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiBrandService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.item.dto.ItmBrandRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmBrandRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.google.common.collect.Sets;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Valid
public class SalReceiptServiceImpl
extends BaseServiceImpl
implements SalReceiptService {
    private static final Logger log = LoggerFactory.getLogger(SalReceiptServiceImpl.class);
    private final SalReceiptRepoProc salReceiptRepoProc;
    private final SalReceiptRepo salReceiptRepo;
    private final SalReceiptdRepoProc salReceiptdRepoProc;
    private final SalReceiptdRepo salReceiptdRepo;
    private final RmiOrderSalSoDService rmiOrderSalSoDService;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final SalSoaRepo salSoaRepo;
    private final RmiDoDRpcService rmiDoDRpcService;
    private final RmiOrgEmpService rmiOrgEmpService;
    private final RmiBrandService rmiBrandService;
    private final RmiCommonService rmiCommonService;
    private final SalReceiptStateService salReceiptStateService;
    private final RmiOrgOuService rmiOrgOuService;
    private final SalInvApplyRepoProc salInvApplyRepoProc;
    private final SalInvApplydRepoProc salInvApplydRepoProc;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final BipOrderRepo bipOrderRepo;
    private final BipOrderBackRepo bipOrderBackRepo;
    private final BipOrderDRepo bipOrderDRepo;
    private final SalSoRpcService salSoRpcService;
    private final SysCurrencyRpcService sysCurrencyRpcService;
    @Autowired
    protected UdcProvider udcProvider;
    @Autowired(required=false)
    private RedissonClient redissonClient;

    @SysCodeProc
    public PagingVO<SalReceiptRespVO> query(SalReceiptPageParam pagingParam) {
        JPAQuery<SalReceiptRespVO> jpaQuery = this.salReceiptRepoProc.select(pagingParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(pagingParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, QSalReceiptDO.salReceiptDO);
        List result = jpaQuery.fetch();
        try {
            List agentEmpIds = result.stream().filter(dod -> dod.getApprUserId() != null).map(SalReceiptRespVO::getApprUserId).distinct().collect(Collectors.toList());
            if (agentEmpIds.size() > 0) {
                OrgEmpRpcDtoParam orgEmpRpcDtoParam1 = new OrgEmpRpcDtoParam();
                orgEmpRpcDtoParam1.setEmpIds(agentEmpIds);
                List<OrgEmpRpcDTO> empDtoByParam1 = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam1);
                result.forEach(r -> empDtoByParam1.forEach(l -> {
                    if (l.getId().equals(r.getApprUserId())) {
                        r.setApprUserName(l.getEmpName());
                    }
                }));
            }
            List receiptTypeList = this.udcProvider.listByUdcCode("SAL", (Set)Sets.newHashSet((Object[])new String[]{"RECEIPT_TYPE"}));
            List payMethodList = this.udcProvider.listByUdcCode("COM", (Set)Sets.newHashSet((Object[])new String[]{"PAY_METHOD"}));
            List refoundTypeList = this.udcProvider.listByUdcCode("SAL", (Set)Sets.newHashSet((Object[])new String[]{"REFOUND_TYPE"}));
            List refoundMethodList = this.udcProvider.listByUdcCode("SAL", (Set)Sets.newHashSet((Object[])new String[]{"REFOUND_METHOD"}));
            result.forEach(r -> {
                if (r.getDocType() != null && r.getDocType().equals("RE")) {
                    receiptTypeList.forEach(l -> {
                        if (l.getUdcCode().equals(r.getReceiptType())) {
                            r.setReceiptTypeName(l.getUdcDescribe());
                        }
                    });
                    payMethodList.forEach(l -> {
                        if (l.getUdcCode().equals(r.getPayMethod())) {
                            r.setPayMethodName(l.getUdcDescribe());
                        }
                    });
                } else {
                    refoundTypeList.forEach(l -> {
                        if (l.getUdcCode().equals(r.getReceiptType())) {
                            r.setReceiptTypeName(l.getUdcDescribe());
                        }
                    });
                    refoundMethodList.forEach(l -> {
                        if (l.getUdcCode().equals(r.getPayMethod())) {
                            r.setPayMethodName(l.getUdcDescribe());
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
        List<Long> masIds = result.stream().map(SalReceiptRespVO::getId).collect(Collectors.toList());
        List<SalReceiptDDO> details = this.salReceiptdRepo.findByMasIdIn(masIds);
        result.forEach(r -> {
            ArrayList dList = new ArrayList();
            details.forEach(d -> {
                SalReceiptdRespVO detail = new SalReceiptdRespVO();
                if (r.getId().equals(d.getMasId())) {
                    BeanCopyUtil.beanCopy((Object)d, (Object)detail);
                    dList.add(detail);
                }
            });
            r.setSalReceiptdRespVOS(dList);
        });
        PagingVO pageRespVO = PagingVO.builder().total(total).records(result).build();
        return pageRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> saveOrSubmit(SalReceiptSaveParam param) {
        SalReceiptDO salReceiptDO;
        log.info("\u6536\u6b3e/\u9000\u6b3e\u5355\u4fdd\u5b58\u5165\u53c2:" + JSONUtil.toJsonStr((Object)param));
        try {
            salReceiptDO = this.checkParam(param.getSalReceiptRespVO());
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        String docNo = StringUtils.isEmpty((Object)salReceiptDO) ? (param.getSalReceiptRespVO().getDocType() != null && param.getSalReceiptRespVO().getDocType().equals("RD") ? this.rmiSysNextNumberService.generateCode("yst-sale", "RETURN_NO", null) : this.rmiSysNextNumberService.generateCode("yst-sale", "RE", null)) : salReceiptDO.getDocNo();
        RLock rLock = this.redissonClient.getLock(docNo);
        try {
            boolean lock = rLock.tryLock(0L, 5L, TimeUnit.MINUTES);
            if (!lock) {
                throw new BusinessException("\u8ba2\u5355" + docNo + "\u6b63\u5728\u64cd\u4f5c\u4e2d");
            }
            this.insertOrUpdate(salReceiptDO, param.getSalReceiptRespVO(), param.getSaveFlag(), param.getOffFlag(), docNo);
        }
        catch (Exception e) {
            log.error("\u6536\u6b3e/\u9000\u6b3e\u5355\u4fdd\u5b58\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException(e.getMessage());
        }
        finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> insertOrUpdate(SalReceiptDO salReceiptDO, SalReceiptRespVO salReceiptRespVO, String saveFlag, String offFlag, String docNo) {
        if (StringUtils.isEmpty((Object)salReceiptDO)) {
            salReceiptDO = new SalReceiptDO();
            BeanCopyUtil.beanCopy((Object)salReceiptRespVO, (Object)salReceiptDO);
            salReceiptDO.setDocNo(docNo);
            salReceiptDO.setApplyDate(LocalDateTime.now());
        } else {
            BeanCopyUtil.beanCopy((Object)salReceiptRespVO, (Object)salReceiptDO);
            this.salReceiptdRepo.deleteAllByMasId(salReceiptDO.getId());
        }
        List<Object> soaList = new ArrayList();
        if (salReceiptRespVO.getSoaOrSo() != null && salReceiptRespVO.getSoaOrSo().equals("SOA") && (offFlag == null || !offFlag.equals("R"))) {
            List<Long> soaId = salReceiptRespVO.getSalReceiptdRespVOS().stream().map(SalReceiptdRespVO::getSoaId).distinct().collect(Collectors.toList());
            soaList = this.salSoaRepo.findByIdIn(soaId);
            soaList.forEach(soa -> {
                if (!soa.getSoaReceiptStatus().equals(UdcEnum.SAL_SOA_RECEIPT_STATUS_10.getValueCode())) {
                    throw new BusinessException("\u5bf9\u8d26\u5355" + soa.getDocNo() + "\u7684\u5bf9\u8d26\u5355\u6536\u6b3e\u72b6\u6001\u4e0d\u4e3a\u5f85\u6536\u6b3e");
                }
            });
        }
        if ((salReceiptRespVO.getReceiptType().equals("VIRTUAL") || salReceiptRespVO.getReceiptType().equals("DEP_PRE")) && !salReceiptRespVO.getPayMethod().equals("VIRTUAL")) {
            throw new BusinessException("\u865a\u62df\u6536\u6b3e\u6216\u62bc\u91d1\u8f6c\u9884\u6536\u7c7b\u578b\u7684\u5355\u5b50,\u6536\u6b3e\u65b9\u5f0f\u5fc5\u987b\u4e3a\u865a\u62df\u6536\u6b3e");
        }
        AtomicReference<BigDecimal> amt = new AtomicReference<BigDecimal>(new BigDecimal(0));
        if (salReceiptRespVO.getSalReceiptdRespVOS() != null && salReceiptRespVO.getSalReceiptdRespVOS().size() > 0) {
            salReceiptRespVO.getSalReceiptdRespVOS().forEach(d -> {
                if (d.getReceiptAmt() == null || d.getReceiptAmt().compareTo(BigDecimal.ZERO) == 0) {
                    throw new BusinessException("\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u7b49\u4e8e0");
                }
                amt.set(((BigDecimal)amt.get()).add(d.getReceiptAmt()));
                if (salReceiptRespVO.getDocType() != null && salReceiptRespVO.getDocType().equals("RE") && !salReceiptRespVO.getReceiptType().equals("OFF_PRE") && !salReceiptRespVO.getReceiptType().equals("ONLINE_PRE")) {
                    if (salReceiptRespVO.getReceiptType() != null && salReceiptRespVO.getReceiptType().equals("AR")) {
                        if (d.getReceiptAmt().compareTo(d.getOpenAmt()) > 0) {
                            throw new BusinessException("\u5e94\u6536\u6b3e\u65f6\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u6b3e\u4f59\u989d");
                        }
                    } else if (d.getReceiptAmt().compareTo(d.getApAmt()) > 0) {
                        throw new BusinessException("\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f85\u6536\u6b3e\u91d1\u989d");
                    }
                }
            });
            if (amt.get().compareTo(salReceiptRespVO.getAmt()) != 0 && salReceiptRespVO.getDocType().equals("RE")) {
                throw new BusinessException("\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u548c\u660e\u7ec6\u7684\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u7684\u5408\u8ba1\u503c\u76f8\u7b49");
            }
        }
        if ("SAVE".equals(saveFlag)) {
            salReceiptDO.setDocStatus(UdcEnum.SAL_RECEIPT_STATUS_DRAFT.getValueCode());
        } else {
            salReceiptDO.setDocStatus(UdcEnum.SAL_RECEIPT_STATUS_APPROVING.getValueCode());
        }
        if (StringUtils.isEmpty((Object)salReceiptRespVO.getRelateDocNo())) {
            if (salReceiptRespVO.getReceiptType().equals("AR") && salReceiptRespVO.getReceiptType().equals("VIRTUAL")) {
                throw new BusinessException("\u5f53\u6536\u6b3e\u7c7b\u578b\u4e3a\u8d26\u671f\u6536\u6b3e\u3001\u865a\u62df\u6536\u6b3e\u65f6\uff0c\u5fc5\u987b\u5173\u8054\u8ba2\u5355");
            }
            salReceiptDO.setDocStatus2(UdcEnum.SAL_RECEIPT_WRITEOFF_10.getValueCode());
        }
        if ("DEPOSIT".equals(salReceiptRespVO.getReceiptType())) {
            if (StringUtils.isEmpty((Object)salReceiptDO.getTransferAmt())) {
                salReceiptDO.setTransferAmt(BigDecimal.ZERO);
            }
            if (StringUtils.isEmpty((Object)salReceiptDO.getTransferingAmt())) {
                salReceiptDO.setTransferingAmt(BigDecimal.ZERO);
            }
            if (StringUtils.isEmpty((Object)salReceiptDO.getOpenAmt())) {
                salReceiptDO.setOpenAmt(salReceiptDO.getAmt());
            }
        }
        if (salReceiptRespVO.getDocType().equals("RE") && !salReceiptRespVO.getReceiptType().equals("PRE") && !salReceiptRespVO.getReceiptType().equals("RED") && salReceiptRespVO.getSalReceiptdRespVOS().size() > 0) {
            SalSoDetailQueryDTO searchParam = new SalSoDetailQueryDTO();
            searchParam.setDocNo(((SalReceiptdRespVO)salReceiptRespVO.getSalReceiptdRespVOS().get(0)).getSoNo());
            ApiResult apiResult = this.salSoRpcService.querySalSoDetail(searchParam);
            if (apiResult.getCode() != 200) {
                throw new BusinessException(apiResult.getMsg());
            }
            List sodList = ((PagingVO)apiResult.getData()).getRecords();
            if (sodList.size() == 0) {
                throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u9500\u552e\u5355\u53f7\u4fe1\u606f:" + ((SalReceiptdRespVO)salReceiptRespVO.getSalReceiptdRespVOS().get(0)).getSoNo());
            }
            if (((SalSoDetailRespDTO)sodList.get(0)).getDocType().equals("SE")) {
                throw new BusinessException("\u8d2d\u7269\u5361\u8ba2\u5355" + ((SalSoDetailRespDTO)sodList.get(0)).getDocNo() + "\u7684\u6536\u6b3e\u7c7b\u578b\u5fc5\u987b\u662f\u9884\u6536\u6536\u6b3e");
            }
            if (((SalSoDetailRespDTO)sodList.get(0)).getDocType().equals("SH")) {
                throw new BusinessException("\u63d0\u8d27\u5238\u8ba2\u5355" + ((SalSoDetailRespDTO)sodList.get(0)).getDocNo() + "\u7684\u6536\u6b3e\u7c7b\u578b\u5fc5\u987b\u662f\u9884\u6536\u6536\u6b3e");
            }
        }
        if (salReceiptRespVO.getReceiptType().equals("ONLINE_PRE") || salReceiptRespVO.getReceiptType().equals("40")) {
            HashSet<String> currCodes = new HashSet<String>();
            currCodes.add(salReceiptRespVO.getCurrCode());
            ApiResult sysCurrencyRespDTOListApiResult = this.sysCurrencyRpcService.listByCodes(currCodes);
            Assert.notNull((Object)sysCurrencyRespDTOListApiResult, (String)"\u67e5\u8be2\u5e01\u79cd\u5931\u8d25", (Object[])new Object[0]);
            Assert.isTrue((boolean)sysCurrencyRespDTOListApiResult.isSuccess(), (String)"\u67e5\u8be2\u5e01\u79cd\u5931\u8d25", (Object[])new Object[0]);
            if (((List)sysCurrencyRespDTOListApiResult.getData()).size() > 0) {
                salReceiptRespVO.setCurrName(((SysCurrencyRespDTO)((List)sysCurrencyRespDTOListApiResult.getData()).get(0)).getCurrName());
            }
        }
        if (offFlag != null || salReceiptRespVO.getReceiptType().equals("DEP_PRE")) {
            if (StringUtils.isEmpty((Object)salReceiptRespVO.getRelateDocId()) || StringUtils.isEmpty((Object)salReceiptRespVO.getRelateDocNo())) {
                throw new BusinessException("\u5173\u8054\u5355\u53f7\u4e0eID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Optional oldOp = this.salReceiptRepo.findById(salReceiptRespVO.getRelateDocId());
            if (oldOp.isEmpty()) {
                throw new BusinessException("\u5173\u8054\u5355\u636e\u4e0d\u5b58\u5728");
            }
            if (((SalReceiptDO)oldOp.get()).getId().equals(salReceiptDO.getId())) {
                throw new BusinessException("\u4e0d\u80fd\u5173\u8054\u81ea\u5df1");
            }
            SalReceiptDO oldSa = new SalReceiptDO();
            if (offFlag != null && offFlag.equals("R")) {
                salReceiptDO.setReceiptType("RED");
                oldSa = (SalReceiptDO)oldOp.get();
                oldSa.setOffFlag("R");
            }
            if (salReceiptRespVO.getReceiptType().equals("DEP_PRE") && "SUBMIT".equals(saveFlag)) {
                oldSa = (SalReceiptDO)oldOp.get();
                if (salReceiptRespVO.getAmt().compareTo(oldSa.getOpenAmt()) > 0 || salReceiptRespVO.getAmt().compareTo(BigDecimal.ZERO) < 0) {
                    throw new BusinessException("\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u62bc\u91d1\u4f59\u989d\u4e14\u4e0d\u80fd\u5c0f\u4e8e0");
                }
                oldSa.setTransferingAmt((oldSa.getTransferingAmt() == null ? BigDecimal.ZERO : oldSa.getTransferingAmt()).add(salReceiptRespVO.getAmt()));
                oldSa.setOpenAmt(oldSa.getAmt().subtract(oldSa.getReturnAmt() == null ? BigDecimal.ZERO : oldSa.getReturnAmt()).subtract(oldSa.getTransferingAmt()).subtract(oldSa.getTransferAmt() == null ? BigDecimal.ZERO : oldSa.getTransferAmt()).subtract(oldSa.getReturningAmt() == null ? BigDecimal.ZERO : oldSa.getReturningAmt()));
            }
            if (offFlag != null && offFlag.equals("T") && "SUBMIT".equals(saveFlag)) {
                BigDecimal absAmt;
                oldSa = (SalReceiptDO)oldOp.get();
                BigDecimal bigDecimal = absAmt = salReceiptRespVO.getAmt() == null ? BigDecimal.ZERO : salReceiptRespVO.getAmt().abs();
                if (oldSa.getOpenAmt().compareTo(BigDecimal.ZERO) == 0) {
                    throw new BusinessException("\u62bc\u91d1\u5df2\u9000\u6b3e\u6216\u5728\u9000\u6b3e\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
                }
                if (oldSa.getOpenAmt().compareTo(absAmt) < 0) {
                    throw new BusinessException("\u9000\u62bc\u91d1\u91d1\u989d\u5927\u4e8e\u62bc\u91d1\u4f59\u989d\uff0c\u4e0d\u53ef\u63d0\u4ea4");
                }
                oldSa.setReturningAmt((oldSa.getReturningAmt() == null ? BigDecimal.ZERO : oldSa.getReturningAmt()).add(absAmt));
                oldSa.setOpenAmt((oldSa.getOpenAmt() == null ? BigDecimal.ZERO : oldSa.getOpenAmt()).subtract(absAmt));
            }
            this.salReceiptRepo.save(oldSa);
        }
        if (salReceiptRespVO.getCreateUserId() == null && salReceiptRespVO.getCreator() == null) {
            CurrentUserDTO currentUserDTO = UserService.currentUser();
            if (currentUserDTO == null) {
                throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u5f02\u5e38");
            }
            log.info("\u6536\u6b3e\u5355\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff1a" + JSONUtil.toJsonStr((Object)currentUserDTO));
            salReceiptDO.setCreateUserId(currentUserDTO.getDetail().getId());
            salReceiptDO.setCreator(currentUserDTO.getDetail().getUsername());
        }
        salReceiptDO.setSecOuId(salReceiptRespVO.getOuId());
        salReceiptDO.setSecBuId(salReceiptRespVO.getBuId());
        salReceiptDO.setSecUserId(salReceiptRespVO.getApplyEmpId());
        this.salReceiptRepo.save(salReceiptDO);
        log.info("\u6536\u6b3e/\u9000\u6b3e\u5355\u4fdd\u5b58\u6210\u529f:" + JSONUtil.toJsonStr((Object)salReceiptDO));
        Long masId = salReceiptDO.getId();
        ArrayList detailList = new ArrayList();
        AtomicReference<BigDecimal> receiptAmt = new AtomicReference<BigDecimal>(new BigDecimal(0));
        AtomicReference<BigDecimal> receiptTax = new AtomicReference<BigDecimal>(new BigDecimal(0));
        if (salReceiptRespVO.getSalReceiptdRespVOS() != null && salReceiptRespVO.getSalReceiptdRespVOS().size() > 0) {
            salReceiptRespVO.getSalReceiptdRespVOS().forEach(detail -> {
                if (!"SAVE".equals(saveFlag) && detail.getApAmt() != null && offFlag != null && !offFlag.equals("R") && detail.getReceiptAmt().abs().compareTo(detail.getApAmt().abs()) > 0) {
                    if (salReceiptRespVO.getDocType().equals("RD")) {
                        throw new BusinessException("\u672c\u6b21\u9000\u6b3e\u91d1\u989d\u4e0d\u53ef\u5927\u4e8e\u5f85\u9000\u6b3e\u91d1\u989d");
                    }
                    throw new BusinessException("\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u4e0d\u53ef\u5927\u4e8e\u5f85\u6536\u6b3e\u91d1\u989d");
                }
                SalReceiptDDO salReceiptDDO = new SalReceiptDDO();
                BeanCopyUtil.beanCopy((Object)detail, (Object)salReceiptDDO);
                salReceiptDDO.setSecOuId(salReceiptRespVO.getOuId());
                salReceiptDDO.setSecBuId(salReceiptRespVO.getBuId());
                salReceiptDDO.setSecUserId(salReceiptRespVO.getApplyEmpId());
                salReceiptDDO.setMasId(masId);
                if (offFlag != null && offFlag.equals("R")) {
                    if (detail.getOffAmt().abs().compareTo(detail.getReceiptAmt().abs()) == 1) {
                        throw new BusinessException("\u7ea2\u51b2\u91d1\u989d\u4e0d\u53ef\u5927\u4e8e\u672c\u6b21\u6536\u6b3e\u91d1\u989d");
                    }
                    receiptAmt.set(((BigDecimal)receiptAmt.get()).add(detail.getOffAmt()));
                    receiptTax.set(((BigDecimal)receiptTax.get()).add(detail.getOffTax()));
                    salReceiptDDO.setReceiptAmt(detail.getOffAmt());
                    salReceiptDDO.setReceiptTax(detail.getOffTax());
                }
                detailList.add(salReceiptDDO);
            });
        } else {
            salReceiptDO.setDocStatus2(UdcEnum.SAL_RECEIPT_WRITEOFF_10.getValueCode());
            if (salReceiptRespVO.getAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new BusinessException("\u6536\u6b3e\u91d1\u989d\u4e3a0\u65f6,\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        this.salReceiptdRepo.saveAll(detailList);
        if (offFlag != null && offFlag.equals("R")) {
            salReceiptDO.setAmt(receiptAmt.get());
            salReceiptDO.setTax(receiptTax.get());
        }
        salReceiptDO.setWriteoffAmt(amt.get());
        if (amt.get().compareTo(salReceiptDO.getAmt()) == 0) {
            salReceiptDO.setDocStatus2(UdcEnum.SAL_RECEIPT_WRITEOFF_30.getValueCode());
        } else if (amt.get().compareTo(BigDecimal.ZERO) != 0) {
            salReceiptDO.setDocStatus2(UdcEnum.SAL_RECEIPT_WRITEOFF_20.getValueCode());
        }
        this.salReceiptRepo.save(salReceiptDO);
        if (salReceiptRespVO.getAttachFiles() != null && salReceiptRespVO.getAttachFiles().size() > 0) {
            this.comSaleFileInfoService.comSaleFileHardSave("SAL_RECEIPT", salReceiptDO.getId(), salReceiptRespVO.getAttachFiles());
        }
        if (!"SAVE".equals(saveFlag)) {
            if (salReceiptRespVO.getDocType() != null && salReceiptRespVO.getDocType().equals("RD")) {
                if (salReceiptRespVO.getReceiptType() == null || !salReceiptRespVO.getReceiptType().equals("30")) {
                    HashMap<Long, BigDecimal> IdAndAmt = new HashMap<Long, BigDecimal>();
                    detailList.forEach(d -> {
                        if (d.getSoDId() != null && d.getReceiptAmt() != null) {
                            IdAndAmt.put(d.getSoDId(), d.getReceiptAmt().abs());
                        }
                    });
                    if (IdAndAmt.size() > 0) {
                        this.rmiOrderSalSoDService.submitRefund(IdAndAmt);
                    }
                }
            } else {
                if (salReceiptRespVO.getSoaOrSo() != null && salReceiptRespVO.getSoaOrSo().equals("SOA")) {
                    Long receiptId = salReceiptDO.getId();
                    String receiptDocNo = salReceiptDO.getDocNo();
                    soaList.forEach(soa -> {
                        soa.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_20.getValueCode());
                        soa.setReceiptId(receiptId);
                        soa.setReceiptNo(receiptDocNo);
                    });
                    this.salSoaRepo.saveAll(soaList);
                }
                List<Long> sodIdList = detailList.stream().filter(s -> s.getSoDId() != null).map(SalReceiptDDO::getSoDId).collect(Collectors.toList());
                List<Object> sodList = new ArrayList();
                if (sodIdList.size() > 0) {
                    sodList = this.getSodListBySodId(sodIdList);
                    if (salReceiptRespVO.getReceiptType().equals("OFF_PRE")) {
                        List<Long> bipOrderDids = sodList.stream().filter(a -> a.getRelateDocDid() != null).map(SalSoDetailRespDTO::getRelateDocDid).distinct().collect(Collectors.toList());
                        List<BipOrderDDO> orderDs = this.bipOrderDRepo.findByIdIn(bipOrderDids);
                        if (sodList.size() != orderDs.size()) {
                            log.info("\u67e5\u627e\u5546\u57ce\u5355\u5b50\u5f02\u5e38:sodList-" + JSONUtil.toJsonStr(sodList) + ";orderDList-" + JSONUtil.toJsonStr(orderDs));
                            throw new BusinessException("\u67e5\u627e\u5546\u57ce\u5355\u5b50\u5f02\u5e38");
                        }
                        List<Long> orderIds = orderDs.stream().map(BipOrderDDO::getOrderId).distinct().collect(Collectors.toList());
                        List<BipOrderDO> orders = this.bipOrderRepo.findByIdIn(orderIds);
                        HashMap amtMap = new HashMap();
                        List<Object> finalSodList = sodList;
                        detailList.forEach(d -> finalSodList.forEach(sod -> {
                            if (d.getSoDId().equals(sod.getSoDId())) {
                                amtMap.put(sod.getRelateDocDid(), d.getReceiptAmt());
                            }
                        }));
                        for (Map.Entry m : amtMap.entrySet()) {
                            orderDs.forEach(od -> {
                                if (((Long)m.getKey()).equals(od.getId())) {
                                    od.setPayDoneAmt(od.getPayDoneAmt().add((BigDecimal)m.getValue()));
                                    orders.forEach(o -> {
                                        if (od.getOrderId().equals(o.getId())) {
                                            o.setPayDoneAmt(o.getPayDoneAmt().add((BigDecimal)m.getValue()));
                                            o.setPayTime(LocalDateTime.now());
                                            if (o.getPayAmt().compareTo(o.getPayDoneAmt()) <= 0) {
                                                o.setStatus("shipping");
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        this.bipOrderRepo.saveAll(orders);
                        this.bipOrderDRepo.saveAll(orderDs);
                    }
                }
                ArrayList<SalSoDUpdateDTO> sodUpList = new ArrayList<SalSoDUpdateDTO>();
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setPayingAmt(sod.getPayingAmt() == null ? BigDecimal.ZERO : sod.getPayingAmt());
                    salSoDUpdateDTO.setOpenAmt(sod.getOpenAmt() == null ? BigDecimal.ZERO : sod.getOpenAmt());
                    salSoDUpdateDTO.setPayedAmt(sod.getPayedAmt() == null ? BigDecimal.ZERO : sod.getPayedAmt());
                    detailList.forEach(d -> {
                        if (sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setPayingAmt(salSoDUpdateDTO.getPayingAmt().add(d.getReceiptAmt()));
                            if (salSoDUpdateDTO.getOpenAmt().compareTo(BigDecimal.ZERO) == 0) {
                                salSoDUpdateDTO.setOpenAmt(d.getReceiptAmt());
                            } else {
                                salSoDUpdateDTO.setOpenAmt(salSoDUpdateDTO.getOpenAmt().subtract(d.getReceiptAmt()));
                            }
                        }
                    });
                    if (sod.getConfirmQty().compareTo(BigDecimal.ZERO) == 0) {
                        salSoDUpdateDTO.setApAmt(sod.getQty().multiply(sod.getPrice()).subtract(salSoDUpdateDTO.getPayedAmt()).subtract(salSoDUpdateDTO.getPayingAmt()));
                    } else {
                        salSoDUpdateDTO.setApAmt(sod.getConfirmQty().multiply(sod.getPrice()).subtract(salSoDUpdateDTO.getPayedAmt()).subtract(salSoDUpdateDTO.getPayingAmt()));
                    }
                    sodUpList.add(salSoDUpdateDTO);
                });
                if (sodUpList.size() > 0) {
                    log.info("\u6536\u6b3e\u4f20OMS\u6570\u636e:" + JSONUtil.toJsonStr(sodUpList));
                    this.rmiOrderSalSoDService.bcQuerySalSoDetail(sodUpList);
                }
            }
            try {
                SalReceiptRespVO respVO = (SalReceiptRespVO)BeanUtil.copyProperties((Object)salReceiptDO, SalReceiptRespVO.class, (String[])new String[0]);
                ArrayList list = new ArrayList();
                detailList.forEach(ddo -> {
                    SalReceiptdRespVO dvo = (SalReceiptdRespVO)BeanUtil.copyProperties((Object)ddo, SalReceiptdRespVO.class, (String[])new String[0]);
                    list.add(dvo);
                });
                String docType = null;
                if (detailList.stream().filter(a -> a != null).collect(Collectors.toList()).size() > 0) {
                    SalSoDetailQueryDTO salSoDetailQueryDTO = new SalSoDetailQueryDTO();
                    salSoDetailQueryDTO.setDocNo(((SalReceiptDDO)detailList.get(0)).getSoNo());
                    ApiResult apiResult = this.salSoRpcService.querySalSoDetail(salSoDetailQueryDTO);
                    if (apiResult.getCode() == 200 && ((PagingVO)apiResult.getData()).getRecords().size() > 0) {
                        SalSoDetailRespDTO salSoDetailRespDTO = (SalSoDetailRespDTO)((PagingVO)apiResult.getData()).getRecords().get(0);
                        docType = salSoDetailRespDTO.getDocType();
                    }
                }
                this.salReceiptStateService.createStatement(docType, respVO, list, salReceiptRespVO.getReceiptSerial());
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new BusinessException(e.getMessage());
            }
        }
        return ApiResult.ok();
    }

    private List<SalSoDetailRespDTO> getSodListBySodId(List<Long> sodIds) {
        List<Object> sodList = new ArrayList<SalSoDetailRespDTO>();
        if (sodIds.size() > 0) {
            SalSoDetailQueryDTO salSoDetailQueryDTO = new SalSoDetailQueryDTO();
            salSoDetailQueryDTO.setSoDIdList(sodIds);
            salSoDetailQueryDTO.setSize(Integer.valueOf(10000));
            ApiResult apiResult = this.salSoRpcService.querySalSoDetail(salSoDetailQueryDTO);
            if (apiResult.getCode() != 200) {
                throw new BusinessException(apiResult.getMsg());
            }
            sodList = ((PagingVO)apiResult.getData()).getRecords();
        }
        return sodList;
    }

    private SalReceiptDO checkParam(SalReceiptRespVO param) {
        if (StringUtils.isEmpty((Object)param.getOuId())) {
            throw new BusinessException("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)param.getBuId())) {
            throw new BusinessException("\u9500\u552e\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)param.getApplyEmpId())) {
            throw new BusinessException("\u7533\u8bf7\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)param.getId())) {
            return null;
        }
        Optional salReceiptDO = this.salReceiptRepo.findById(param.getId());
        if (salReceiptDO.isEmpty()) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25,\u67e5\u8be2\u4e0d\u5230\u8be5id\u6570\u636e");
        }
        return (SalReceiptDO)salReceiptDO.get();
    }

    @SysCodeProc
    public SalReceiptRespVO getById(Long id) {
        List ddos;
        SalReceiptPageParam pagingParam = new SalReceiptPageParam();
        pagingParam.setId(id);
        SalReceiptRespVO salReceiptRespVO = new SalReceiptRespVO();
        List list = this.salReceiptRepoProc.select(pagingParam).fetch();
        if (list.size() > 0) {
            Set taxRates;
            List brands;
            Optional srdo;
            salReceiptRespVO = (SalReceiptRespVO)list.get(0);
            try {
                if (!StringUtils.isEmpty((Object)salReceiptRespVO.getApprUserId()) && StringUtils.isEmpty((Object)salReceiptRespVO.getApprUserName())) {
                    OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
                    ArrayList<Long> agentEmpIds = new ArrayList<Long>();
                    agentEmpIds.add(salReceiptRespVO.getApprUserId());
                    orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
                    List<OrgEmpRpcDTO> empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
                    if (empDtoByParam.size() > 0) {
                        salReceiptRespVO.setApprUserName(empDtoByParam.get(0).getEmpName());
                    }
                }
                String receiptType = salReceiptRespVO.getReceiptType();
                String payMethod = salReceiptRespVO.getPayMethod();
                AtomicReference<String> receiptTypeName = new AtomicReference<String>("");
                AtomicReference<String> payMethodName = new AtomicReference<String>("");
                if (salReceiptRespVO.getDocType() != null && salReceiptRespVO.getDocType().equals("RE")) {
                    List receiptTypeList = this.udcProvider.listByUdcCode("SAL", (Set)Sets.newHashSet((Object[])new String[]{"RECEIPT_TYPE"}));
                    List list2 = this.udcProvider.listByUdcCode("COM", (Set)Sets.newHashSet((Object[])new String[]{"PAY_METHOD"}));
                    receiptTypeList.forEach(l -> {
                        if (l.getUdcCode().equals(receiptType)) {
                            receiptTypeName.set(l.getUdcDescribe());
                        }
                    });
                    list2.forEach(l -> {
                        if (l.getUdcCode().equals(payMethod)) {
                            payMethodName.set(l.getUdcDescribe());
                        }
                    });
                } else {
                    List refoundTypeList = this.udcProvider.listByUdcCode("SAL", (Set)Sets.newHashSet((Object[])new String[]{"REFOUND_TYPE"}));
                    List list3 = this.udcProvider.listByUdcCode("SAL", (Set)Sets.newHashSet((Object[])new String[]{"REFOUND_METHOD"}));
                    refoundTypeList.forEach(l -> {
                        if (l.getUdcCode().equals(receiptType)) {
                            receiptTypeName.set(l.getUdcDescribe());
                        }
                    });
                    list3.forEach(l -> {
                        if (l.getUdcCode().equals(payMethod)) {
                            payMethodName.set(l.getUdcDescribe());
                        }
                    });
                }
                if (receiptTypeName.get() != null) {
                    salReceiptRespVO.setReceiptTypeName(receiptTypeName.get());
                }
                if (payMethodName.get() != null) {
                    salReceiptRespVO.setPayMethodName(payMethodName.get());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            }
            List comSFCList = this.comSaleFileInfoService.findFileByBusinessId("SAL_RECEIPT", salReceiptRespVO.getId());
            salReceiptRespVO.setAttachFiles(comSFCList);
            ddos = this.salReceiptdRepoProc.findBymasId(salReceiptRespVO.getId()).fetch();
            if ("RED".equals(salReceiptRespVO.getReceiptType())) {
                List relateddos = this.salReceiptdRepoProc.findBymasId(salReceiptRespVO.getRelateDocId() == null ? 0L : salReceiptRespVO.getRelateDocId()).fetch();
                Map<Long, List<SalReceiptdRespVO>> relateMap = relateddos.stream().collect(Collectors.groupingBy(SalReceiptdRespVO::getSoDId));
                for (Map.Entry entry : relateMap.entrySet()) {
                    ddos.forEach(d -> {
                        if (d.getSoDId().equals(m.getKey())) {
                            d.setOffAmt(d.getReceiptAmt() == null ? BigDecimal.ZERO : d.getReceiptAmt());
                            d.setOffTax(d.getReceiptTax() == null ? BigDecimal.ZERO : d.getReceiptTax());
                            d.setReceiptAmt(((SalReceiptdRespVO)((List)m.getValue()).get(0)).getReceiptAmt() == null ? BigDecimal.ZERO : ((SalReceiptdRespVO)((List)m.getValue()).get(0)).getReceiptAmt());
                            d.setReceiptTax(((SalReceiptdRespVO)((List)m.getValue()).get(0)).getReceiptTax() == null ? BigDecimal.ZERO : ((SalReceiptdRespVO)((List)m.getValue()).get(0)).getReceiptTax());
                        }
                    });
                }
            }
            if (salReceiptRespVO.getRelateDocId() != null && !(srdo = this.salReceiptRepo.findById(salReceiptRespVO.getRelateDocId())).isEmpty()) {
                salReceiptRespVO.setRelateReceiptType(((SalReceiptDO)srdo.get()).getReceiptType());
                salReceiptRespVO.setRelateOpenAmt(((SalReceiptDO)srdo.get()).getOpenAmt());
            }
            if (salReceiptRespVO.getDocType() != null && salReceiptRespVO.getDocType().equals("RD") && !salReceiptRespVO.getReceiptType().equals("30")) {
                sodid = ddos.stream().filter(sod -> sod.getSoDId() != null).map(SalReceiptdRespVO::getSoDId).distinct().collect(Collectors.toList());
                if (sodid.size() > 0) {
                    SalSoDQueryDTO salSoDQueryDTO = new SalSoDQueryDTO();
                    salSoDQueryDTO.setSodIds(sodid);
                    salSoDQueryDTO.setSize(Integer.valueOf(10000));
                    ApiResult<PagingVO<SalSoDRefundRespDTO>> apiResult = this.rmiOrderSalSoDService.queryRefund(salSoDQueryDTO);
                    if (apiResult.getCode() != 200) {
                        throw new BusinessException(apiResult.getMsg());
                    }
                    List list4 = ((PagingVO)apiResult.getData()).getRecords();
                    ddos.forEach(receiptd -> sodList.forEach(sod -> {
                        if (receiptd.getSoDId() != null && receiptd.getSoDId().equals(sod.getSodId())) {
                            receiptd.setQty(sod.getQty() == null ? BigDecimal.ZERO : sod.getQty());
                            receiptd.setConfirmQty(sod.getConfirmQty() == null ? BigDecimal.ZERO : sod.getConfirmQty());
                            receiptd.setAmt(sod.getAmt() == null ? BigDecimal.ZERO : sod.getAmt());
                            receiptd.setConfirmAmt(sod.getConfirmAmt() == null ? BigDecimal.ZERO : sod.getConfirmAmt());
                            receiptd.setRefundAmt(sod.getRefundAmt() == null ? BigDecimal.ZERO : sod.getRefundAmt());
                            receiptd.setPayingAmt(sod.getPayingAmt() == null ? BigDecimal.ZERO : sod.getPayingAmt());
                            receiptd.setPayedAmt(sod.getPayedAmt() == null ? BigDecimal.ZERO : sod.getPayedAmt());
                            receiptd.setOpenAmt(sod.getOpenAmt() == null ? BigDecimal.ZERO : sod.getOpenAmt());
                            receiptd.setLineNo(sod.getLineNo() == null ? BigDecimal.ZERO : sod.getLineNo());
                            receiptd.setPrice(sod.getPrice() == null ? BigDecimal.ZERO : sod.getPrice());
                            receiptd.setNetPrice(sod.getNetPrice() == null ? BigDecimal.ZERO : sod.getNetPrice());
                            if (sod.getDocCls() != null && sod.getDocCls().equals("RSO")) {
                                receiptd.setDocCls(sod.getDocCls());
                                receiptd.setQty(receiptd.getQty().abs().negate());
                                receiptd.setConfirmQty(receiptd.getConfirmQty().abs().negate());
                                receiptd.setAmt(receiptd.getAmt().abs().negate());
                                receiptd.setConfirmAmt(receiptd.getConfirmAmt().abs().negate());
                                receiptd.setRefundAmt(receiptd.getRefundAmt().abs().negate());
                                receiptd.setPayingAmt(receiptd.getPayingAmt().abs().negate());
                                receiptd.setPayedAmt(receiptd.getPayedAmt().abs().negate());
                                receiptd.setOpenAmt(receiptd.getOpenAmt().abs().negate());
                            }
                        }
                    }));
                }
            } else {
                sodid = ddos.stream().filter(sod -> sod.getSoDId() != null).map(SalReceiptdRespVO::getSoDId).distinct().collect(Collectors.toList());
                if (sodid.size() > 0) {
                    List<SalSoDetailRespDTO> sodList = this.getSodListBySodId(sodid);
                    ddos.forEach(receiptd -> sodList.forEach(sod -> {
                        if (receiptd.getSoDId() != null && receiptd.getSoDId().equals(sod.getSoDId())) {
                            receiptd.setPayedAmt(sod.getPayedAmt() == null ? BigDecimal.ZERO : sod.getPayedAmt());
                            receiptd.setPayingAmt(sod.getPayingAmt() == null ? BigDecimal.ZERO : sod.getPayingAmt());
                            receiptd.setOpenAmt(sod.getOpenAmt() == null ? BigDecimal.ZERO : sod.getOpenAmt());
                            receiptd.setApAmt(sod.getApAmt() == null ? BigDecimal.ZERO : sod.getApAmt());
                            receiptd.setPrice(sod.getPrice() == null ? BigDecimal.ZERO : sod.getPrice());
                            receiptd.setNetPrice(sod.getNetPrice() == null ? BigDecimal.ZERO : sod.getNetPrice());
                            if (sod.getDocCls() != null && sod.getDocCls().equals("RSO")) {
                                receiptd.setDocCls(sod.getDocCls());
                                receiptd.setPayedAmt(receiptd.getPayedAmt().abs().negate());
                                receiptd.setPayingAmt(receiptd.getPayingAmt().abs().negate());
                                receiptd.setOpenAmt(receiptd.getOpenAmt().abs().negate());
                                receiptd.setApAmt(receiptd.getApAmt().abs().negate());
                            }
                        }
                    }));
                }
            }
            List dodIds = ddos.stream().filter(dod -> dod.getDodId() != null).map(SalReceiptdRespVO::getDodId).distinct().collect(Collectors.toList());
            if (dodIds.size() > 0) {
                SalDoDQueryDTO salDoDQueryDTO = new SalDoDQueryDTO();
                salDoDQueryDTO.setIds(dodIds);
                salDoDQueryDTO.setSize(Integer.valueOf(10000));
                PagingVO<SalDoDRPCRespDTO> salDoDRPCRespDTOPagingVO = this.rmiDoDRpcService.queryDodForInvoice(salDoDQueryDTO);
                List list5 = salDoDRPCRespDTOPagingVO.getRecords();
                ddos.forEach(receiptd -> dodList.forEach(dod -> {
                    if (receiptd.getDodId() != null && receiptd.getDodId().equals(dod.getId())) {
                        receiptd.setConfirmAmt(dod.getConfirmAmt() == null ? BigDecimal.ZERO : dod.getConfirmAmt());
                    }
                }));
            }
            if ((brands = ddos.stream().filter(d -> d.getItemBrand() != null && !d.getItemBrand().equals("")).map(SalReceiptdRespVO::getItemBrand).distinct().collect(Collectors.toList())).size() > 0) {
                ItmBrandRpcDtoParam brandRpcDtoParam = new ItmBrandRpcDtoParam();
                brandRpcDtoParam.setBrandCodes(brands);
                List<ItmBrandRpcDTO> list6 = this.rmiBrandService.findBrandDtoByParam(brandRpcDtoParam);
                ddos.forEach(d -> dtoList.forEach(dto -> {
                    if (d.getItemBrand().equals(dto.getBrandCode())) {
                        d.setItemBrandName(dto.getBrandName());
                    }
                }));
            }
            if ((taxRates = ddos.stream().filter(d -> d.getSoTaxRate() != null).map(d -> d.getSoTaxRate()).distinct().collect(Collectors.toSet())).size() > 0) {
                SysTaxRateQueryDTO sysTaxRateQueryDTO = new SysTaxRateQueryDTO();
                sysTaxRateQueryDTO.setTaxRates(taxRates);
                List<SysTaxRateRespDTO> sysTaxRateRespDTOList = this.rmiCommonService.queryList(sysTaxRateQueryDTO);
                ddos.forEach(d -> sysTaxRateRespDTOList.forEach(dto -> {
                    if (d.getSoTaxRate().compareTo(dto.getTaxRateValue()) == 0) {
                        d.setSoTaxRateNo(dto.getTaxRateNo());
                    }
                }));
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u8ba2\u5355Id\u4e0d\u5b58\u5728");
        }
        salReceiptRespVO.setSalReceiptdRespVOS(ddos);
        return salReceiptRespVO;
    }

    public SalReceiptServiceImpl(SalReceiptRepoProc salReceiptRepoProc, SalReceiptRepo salReceiptRepo, SalReceiptdRepoProc salReceiptdRepoProc, SalReceiptdRepo salReceiptdRepo, RmiOrderSalSoDService rmiOrderSalSoDService, ComSaleFileInfoService comSaleFileInfoService, SalSoaRepo salSoaRepo, RmiDoDRpcService rmiDoDRpcService, RmiOrgEmpService rmiOrgEmpService, RmiBrandService rmiBrandService, RmiCommonService rmiCommonService, SalReceiptStateService salReceiptStateService, RmiOrgOuService rmiOrgOuService, SalInvApplyRepoProc salInvApplyRepoProc, SalInvApplydRepoProc salInvApplydRepoProc, RmiSysNextNumberService rmiSysNextNumberService, BipOrderRepo bipOrderRepo, BipOrderBackRepo bipOrderBackRepo, BipOrderDRepo bipOrderDRepo, SalSoRpcService salSoRpcService, SysCurrencyRpcService sysCurrencyRpcService) {
        this.salReceiptRepoProc = salReceiptRepoProc;
        this.salReceiptRepo = salReceiptRepo;
        this.salReceiptdRepoProc = salReceiptdRepoProc;
        this.salReceiptdRepo = salReceiptdRepo;
        this.rmiOrderSalSoDService = rmiOrderSalSoDService;
        this.comSaleFileInfoService = comSaleFileInfoService;
        this.salSoaRepo = salSoaRepo;
        this.rmiDoDRpcService = rmiDoDRpcService;
        this.rmiOrgEmpService = rmiOrgEmpService;
        this.rmiBrandService = rmiBrandService;
        this.rmiCommonService = rmiCommonService;
        this.salReceiptStateService = salReceiptStateService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.salInvApplyRepoProc = salInvApplyRepoProc;
        this.salInvApplydRepoProc = salInvApplydRepoProc;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.bipOrderRepo = bipOrderRepo;
        this.bipOrderBackRepo = bipOrderBackRepo;
        this.bipOrderDRepo = bipOrderDRepo;
        this.salSoRpcService = salSoRpcService;
        this.sysCurrencyRpcService = sysCurrencyRpcService;
    }
}

