/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipFavoritesService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFavoritesQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFavoritesSaveParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipFavoritesRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemDetailAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemPicAppRespVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.BipFavoritesDo;
import com.elitesland.yst.production.sale.entity.QBipFavoritesDo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipFavoritesRepo;
import com.elitesland.yst.production.sale.repo.shop.BipFavoritesRepoProc;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class BipFavoritesServiceImpl
extends BaseServiceImpl
implements BipFavoritesService {
    private QBipFavoritesDo qBipFavoritesDo = QBipFavoritesDo.bipFavoritesDo;
    private final BipFavoritesRepo bipFavoritesRepo;
    private final BipItemAppService bipItemAppService;
    private final BipFavoritesRepoProc bipFavoritesRepoProc;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;

    public PagingVO<BipFavoritesRespVO> search(BipFavoritesQueryParamVO searchParam) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtils.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u5f97\u5f53\u524d\u767b\u5f55\u4eba\u8bf7\u68c0\u67e5");
        }
        searchParam.setCustAccountId(currentUserDTO.getUserId());
        JPAQuery<BipFavoritesRespVO> jpaQuery = this.select(searchParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(searchParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, this.qBipFavoritesDo);
        List respVOS = jpaQuery.fetch();
        this.translatePage(respVOS);
        return PagingVO.builder().total(total).records(respVOS).build();
    }

    private void translatePage(List<BipFavoritesRespVO> bipFavoritesRespVOS) {
        bipFavoritesRespVOS.forEach(bip -> {
            ApiResult detail = this.bipItemAppService.getDetail(bip.getItemId(), this.getCurrentOuIdInfo());
            Assert.isFalse((!detail.isSuccess() ? 1 : 0) != 0, (String)("\u672a\u67e5\u5230\u5546\u54c1id\u4e3a:" + bip.getItemId() + "\u7684\u6570\u636e"), (Object[])new Object[0]);
            BipItemDetailAppRespVO detailData = (BipItemDetailAppRespVO)detail.getData();
            bip.setAmt(detailData.getPrice());
            bip.setItemTitle(detailData.getTitle());
            List picList = detailData.getPicList();
            if (!CollectionUtils.isEmpty((Collection)picList)) {
                bip.setFileCode(((BipItemPicAppRespVO)picList.get(0)).getFileCode());
            }
        });
    }

    private Long getCurrentOuIdInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        BipCustUserBindDO bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUser.getUserId());
        if (bipCustUserBindDO == null || bipCustUserBindDO.getOuId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u516c\u53f8");
        }
        return bipCustUserBindDO.getOuId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void collectBipFavorites(BipFavoritesSaveParamVO bipFavoritesSaveParamVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtils.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u65e0\u6cd5\u6536\u85cf");
        }
        bipFavoritesSaveParamVO.setCustAccountId(currentUserDTO.getUserId());
        if (ObjectUtils.isEmpty((Object)bipFavoritesSaveParamVO)) {
            return;
        }
        if (bipFavoritesSaveParamVO.getIfCollectFlag().equals(1)) {
            this.saveBipFavorites(bipFavoritesSaveParamVO);
        } else {
            this.bipFavoritesRepo.deleteBipFavorites(bipFavoritesSaveParamVO.getCustAccountId(), bipFavoritesSaveParamVO.getItemIds());
        }
    }

    public Boolean ifCollected(Long itemId) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtils.isEmpty((Object)currentUserDTO)) {
            return Boolean.FALSE;
        }
        return this.bipFavoritesRepoProc.exists(currentUserDTO.getUserId(), itemId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveBipFavorites(BipFavoritesSaveParamVO bipFavoritesSaveParamVO) {
        ArrayList bipFavoritesDos = new ArrayList();
        BipFavoritesDo bipFavoritesDo = new BipFavoritesDo();
        bipFavoritesDo.setCustAccountId(bipFavoritesSaveParamVO.getCustAccountId());
        if (CollectionUtils.isEmpty((Collection)bipFavoritesSaveParamVO.getItemIds())) {
            return;
        }
        bipFavoritesSaveParamVO.getItemIds().forEach(bip -> {
            bipFavoritesDo.setItemId((Long)bip);
            bipFavoritesDo.setCollectTime(LocalDateTime.now());
            bipFavoritesDos.add(bipFavoritesDo);
        });
        this.bipFavoritesRepo.saveAll(bipFavoritesDos);
    }

    public JPAQuery<BipFavoritesRespVO> select(BipFavoritesQueryParamVO searchParam) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipFavoritesRespVO.class, (Expression[])new Expression[]{this.qBipFavoritesDo.id, this.qBipFavoritesDo.itemCode, this.qBipFavoritesDo.itemId, this.qBipFavoritesDo.collectTime, this.qBipFavoritesDo.custAccountId, this.qBipFavoritesDo.num, this.qBipFavoritesDo.putAmt})).from((EntityPath)this.qBipFavoritesDo);
        if (searchParam != null) {
            jpaQuery.where(this.where(searchParam));
        }
        return jpaQuery;
    }

    public Predicate where(BipFavoritesQueryParamVO searchParam) {
        BooleanExpression predicate = this.qBipFavoritesDo.isNotNull();
        if (!ObjectUtils.isEmpty((Object)searchParam.getCustAccountId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipFavoritesDo.custAccountId.eq((Object)searchParam.getCustAccountId()));
        }
        return predicate;
    }

    public BipFavoritesServiceImpl(BipFavoritesRepo bipFavoritesRepo, BipItemAppService bipItemAppService, BipFavoritesRepoProc bipFavoritesRepoProc, BipCustUserBindRepoProc bipCustUserBindRepoProc) {
        this.bipFavoritesRepo = bipFavoritesRepo;
        this.bipItemAppService = bipItemAppService;
        this.bipFavoritesRepoProc = bipFavoritesRepoProc;
        this.bipCustUserBindRepoProc = bipCustUserBindRepoProc;
    }
}

