package com.elitesland.pur.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 有价商品查询参数
 *
 * @author chaofeng.xia
 * @date 2023/10/9 13:07
 */
@Data
@ApiModel(value = "purPriceItemParamDTO", description = "有价商品查询参数")
public class PurPriceItemParamDTO implements Serializable {

    private static final long serialVersionUID = -461308934305624252L;

    @ApiModelProperty("业务类型：团内或团外 [UDC]PUR:PUR_BUSINESS_TYPE")
    @NotNull(message = "业务类型不能为空")
    private String businessType;

    @ApiModelProperty("公司ID")
    @NotNull(message = "公司ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("币种")
    @NotNull(message = "币种不能为空")
    private String currCode;

    @ApiModelProperty("生效日期")
    @NotNull(message = "生效日期不能为空")
    private LocalDate validDate;
}
