package com.elitesland.pur.dto.po;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 采购订单明细(PurPoD)
 *
 * @author liuqi
 * @since 2020-07-21 10:05:07
 */


@Data
@ApiModel(value = "pur_po_d", description = "采购订单明细")
public class PurPoDUpdateParamDTO implements Serializable {
    private static final long serialVersionUID = 402116355488680789L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private BigDecimal qty;
    /**
     * 数量2
     */
    @ApiModelProperty("数量2")
    private BigDecimal qty2;
    /**
     * 通知发货数量
     */
    @ApiModelProperty("通知发货数量")
    private BigDecimal shipmentQty;

    @ApiModelProperty("已出库数量")
    private Double shippedQty;
    /**
     * 已收数量
     */
    @ApiModelProperty("已收数量")
    private BigDecimal acceptQty;

    @ApiModelProperty("收货日期")
    private LocalDateTime acceptDate;
    @ApiModelProperty("拒收数量")
    private BigDecimal rejectedQty;
    @ApiModelProperty("已收金额")
    private BigDecimal recvAmt;
    @ApiModelProperty("已取消数量")
    private BigDecimal cancelQty;
    /**
     * 已退数量
     */
    @ApiModelProperty("已退数量")
    private BigDecimal returnedQty;
    /**
     * 差异数量
     */
    @ApiModelProperty("差异数量")
    private BigDecimal diffQty;

    @ApiModelProperty("已付数量")
    private BigDecimal payedQty;



}
