package com.elitesland.pur.dto.supp;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/05/23
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purSuppBankAccRpcParam", description = "供应商银行信息DTO查询入参")
public class PurSuppBankAccRpcParam implements Serializable {
    private static final long serialVersionUID = -387241510013919081L;

    @ApiModelProperty("供应商ID")
    private List<Long> suppIds;
    @ApiModelProperty("供应商编号")
    private List<String> suppCodes;
    @ApiModelProperty("地址号列表")
    private List<Long> addrNos;

    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;
    @ApiModelProperty("开户银行，支持模糊查询")
    private String bankName;
    @ApiModelProperty("开户支行， 支持模糊查询")
    private String branchName;
    @ApiModelProperty("银行账号，支持模糊查询")
    private String bankAcc;

   /* @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    private String accType;
    @ApiModelProperty("收付款方式")
    private String payCollectMethod;
    @ApiModelProperty(value = "开户行账号名称")
    private String bankAccountName;
    @ApiModelProperty(value = "开户行账号组合")
    private String bankAccountComp;
    @ApiModelProperty("数据来源")
    private List<String> dataSources;*/
}
