package com.elitesland.pur.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.supp.PurUnionAccountSaveDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * <p>
 * 采购订单
 * </p>
 *
 * @author tina.he
 * @since 2021-06-07 10:01:49
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurUnionAccountProvider.PATH)
public interface PurUnionAccountProvider {

    String PATH = "/purUnionAccount";

    /**
     * 创建单据
     *
     * @param createParam 创建信息
     * @return 主键id
     */
    @PostMapping("/createPurUnionAccount")
    ApiResult<Long> createPurUnionAccount(@RequestBody PurUnionAccountSaveDTO createParam);
}
