package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/05/23
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purSuppBaseRpcDTO", description = "供应商RpcDTO基础信息出参对象")
public class PurSuppBaseRpcDTO implements Serializable {
    private static final long serialVersionUID = 3549014267644956844L;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty("供应商编码")
    private String suppCode;
    @ApiModelProperty("供应商名称")
    private String suppName;
    @ApiModelProperty("供应商类型 [UDC]PUR:SUPP_TYPE")
    @SysCode(sys = "yst-purc", mod = "SUPP_TYPE")
    private String suppType;
    private String suppTypeName;
    @ApiModelProperty("供应商类别 [UDC]PUR:SUPP_TYPE2")
    @SysCode(sys = "yst-purc", mod = "SUPP_TYPE2")
    private String suppType2;
    private String suppType2Name;
    @ApiModelProperty("供应商状态 [UDC]PUR:SUPP_STATUS")
    @SysCode(sys = "yst-purc", mod = "SUPP_STATUS")
    private String suppStatus;
    private String suppStatusName;

    @ApiModelProperty("统一信用代码")
    private String certNo;
    @ApiModelProperty("内部交易公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId2;
    @ApiModelProperty("内部交易公司编码")
    private String ouCode2;
    @ApiModelProperty("内部交易公司名称")
    private String ouName2;

    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;
    @ApiModelProperty("外部系统供应商编码")
    private String erpSuppCode;
    @ApiModelProperty("付款条款")
    private String paymentTerm;
    private String paymentTermName;
    @ApiModelProperty("付款方式 [UDC]PUR:PAY_TYPE")
    @SysCode(sys = "yst-purc", mod = "PAY_TYPE")
    private String payMethod;
    private String payMethodName;
    @ApiModelProperty("默认发票类型 [UDC]COM:INV_TYPE")
    @SysCode(sys = "yst-supp", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;
    @ApiModelProperty("税率编码")
    private String taxRateNo;
    @ApiModelProperty("税率名称")
    private String taxRateDesc;
    @ApiModelProperty("税率值")
    private Double taxRateValue;
    @ApiModelProperty("纳税人类型 [UDC]ORG:PAYER_TYPE")
    @SysCode(sys = "yst-supp", mod = "PAYER_TYPE")
    private String taxPayerType;
    private String taxPayerTypeName;
    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty(value = "地址薄类型:[UDC]ORG:ADDR_TYPE")
    private String addrType;
    @ApiModelProperty("数据来源:[UDC]ORG:ADDR_TYPE")
    private String dataSource;
    @ApiModelProperty("付款协议编码")
    private String protocolCode;

    @ApiModelProperty("内外部 [UDC]PUR:IO_TYPE")
    @SysCode(sys = "yst-purc", mod = "IO_TYPE")
    private String ioType;
    private String ioTypeName;

    @ApiModelProperty("供应商归属公司")
    private List<PurSuppOuRespDTO> suppOuRespVOList;

    @ApiModelProperty("供应商简称")
    private String suppAbbr;

    @ApiModelProperty("注册地址")
    private String registerAddress;

    @ApiModelProperty("法人姓名(代表)")
    private String reprName;

    @ApiModelProperty("注册资金")
    private String registerFund;

    @ApiModelProperty("经营范围")
    private String businessScope;

    @ApiModelProperty("纳税人识别号")
    private String taxPayerId;

    @ApiModelProperty("金蝶同步")
    private String outSysKey;

    @ApiModelProperty("金蝶同步")
    private String syncStatus;

    @ApiModelProperty("蜀海同步")
    private String shSysKey;

    @ApiModelProperty("蜀海同步")
    private String shSyncStatus;

    @ApiModelProperty("收货仓库id")
    private Long recvWhId;

    @ApiModelProperty("收货仓库编码")
    private String recvWhCode;

    @ApiModelProperty("收货仓库名称")
    private String recvWhName;


    private List<PurSuppAddressRpcDTO> addressRpcDTOS;
}
