package com.elitesland.pur.dto.gr;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderVO;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 采购收货单
 * </p>
 *
 * @author yifansir
 */
@Data
@ApiModel(value = "pur_gr", description = "采购收货单")
@EqualsAndHashCode(callSuper = true)
public class PurGrRespVODTO extends BaseModelMedOrderVO implements  Serializable {

    private static final long serialVersionUID = 399175131090854991L;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouCode;
    private String ouName;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("采购组织名称")
    private String buName;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("采购单类型")
    private String poType;

    @ApiModelProperty("单据Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 单据类型 [UDC]PUR:GR_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:GR_TYPE")
    @SysCode(sys = "yst-purc", mod = "GR_TYPE")
    private String docType;
    private String docTypeName;

    /**
     * 单据状态 [UDC]PUR:GR_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:GR_STATUS")
    @SysCode(sys = "yst-purc", mod = "GR_STATUS")
    private String docStatus;
    private String docStatusName;
    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商联系电话")
    private String suppContactTel;
    @ApiModelProperty("供应商联系人邮箱")
    private String suppContactEmail;
    @ApiModelProperty("供应商联系人")
    private String suppContactName;
    @ApiModelProperty("供应商详细地址")
    private String returnAddr;
    @ApiModelProperty("省编码")
    private String province;
    private String provinceName;

    @ApiModelProperty("市编码")
    private String city;
    private String cityName;

    @ApiModelProperty("区编码")
    private String county;
    private String countyName;

    @ApiModelProperty("国家")
    @SysCode(sys = "yst-supp", mod = "COUNTRY")
    private String country;
    private String countryName;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    private String whCode;
    private String whName;
    @ApiModelProperty(value = "对接外部仓库 1：是 0：否")
    private Boolean joinOutWh;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    /**
     * 收货人员工ID
     */
    @ApiModelProperty("收货人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long recvEmpId;

    @ApiModelProperty("收货人员工名字")
    @JsonSerialize(using = ToStringSerializer.class)
    private String recvEmpName;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private BigDecimal qty;
    private BigDecimal qtySum;

    @ApiModelProperty("总拒收数量")
    private BigDecimal rejectQty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 记账币种
     */
    @ApiModelProperty("记账币种")
    private String homeCurr;
    /**
     * 交易币种
     */
    @ApiModelProperty("交易币种")
    private String currCode;
    private String currName;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    private String relateDoc2ClsName;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;

    @ApiModelProperty("采购场景")
    private String es11;

    /**
     * 文件服务器编码
     */
    @ApiModelProperty("文件服务器编码")
    private String fileCode;

    @ApiModelProperty("采购收货单明细")
    private List<PurGrDRespVODTO> purGrDRespVOList;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp", mod = "TP_TYPE")
    private String transType;
    private String transTypeName;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    @ApiModelProperty("详细地址")
    private String shipmentDetailaddr;

    @ApiModelProperty("发运联系人")
    private String shipmentContactName;

    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;

    @ApiModelProperty("承运商联系人")
    private String carrierContactName;

    @ApiModelProperty("承运商联系电话")
    private String carrierContactTel;

    @ApiModelProperty("承运商名称")
    private String carrierSuppName;

    @ApiModelProperty("收货联系电话")
    private String tel;

    @ApiModelProperty("采购场景ID")
    private Long sceneTypeId;

    @ApiModelProperty("采购场景编码")
    private String sceneTypeCode;

    @ApiModelProperty("采购订单订购日期")
    private LocalDateTime poDocTime;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("越库标识 true=是，false=否，默认值为false")
    private Boolean overStockFlag;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;
    @ApiModelProperty("根来源类型")
    private String rootDocClsName;
    @ApiModelProperty("根来源场景名称")
    private String rootDocTypeName;

    @ApiModelProperty("要交日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;

    @ApiModelProperty("项目编码")
    private String projectCode;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("总订购数量")
    private BigDecimal poQty;

    @ApiModelProperty("本次总收货数量")
    private BigDecimal sumQty;

    @ApiModelProperty("总订购数量")
    private BigDecimal sumPoQty;

    @ApiModelProperty("可收货总数量")
    private BigDecimal sumAvalQty;

    @ApiModelProperty("含税总额")
    BigDecimal sumCurrAmt;

    @ApiModelProperty("未税总额")
    BigDecimal sumCurrNetAmt;

    @ApiModelProperty("含税总额")
    BigDecimal sumTaxAmt;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDate;

    @ApiModelProperty("推送WMS状态")
    private String wmsStatus;

    @ApiModelProperty("推送WMS状态")
    private String wmsStatusName;

    @ApiModelProperty("推送WMS时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsTime;

    @ApiModelProperty("接收WMS回传状态")
    private String wmsFeedbackStatus;

    @ApiModelProperty("接收WMS回传状态")
    private String wmsFeedbackStatusName;

    @ApiModelProperty("wms日志")
    private String wmsLog;

    @ApiModelProperty("WMS撤回日志")
    private String wmsCancelLog;

    @ApiModelProperty("WMS撤回时间")
    private LocalDateTime wmsCancelTime;

//    @ApiModelProperty("供应商归属公司")
//    private List<PurSuppOuRespVO> suppOuRespVOList;

    @ApiModelProperty("结算路径")
    private String pathCode = null;

    @ApiModelProperty("公司间一致性")
    private Boolean companyConsistentFlag = true;


    @ApiModelProperty("付款协议编码")
    private String protocolCode;

    @ApiModelProperty("付款协议名称")
    private String protocolName;

    @ApiModelProperty("要货类型 [UDC]yst-suplan:DEMAND_SET_TYPE")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String demandType;
    private String demandTypeName;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("表分区字段：月")
    private Integer ym;
    @ApiModelProperty("是否需要验收 0:否 1：是")
    private Integer acceptance;
    private String acceptanceName;
    private Boolean qt;
    @ApiModelProperty("采购订单ID")
    private Long poId;

    @ApiModelProperty("入库单号")
    private String invIdoDocNo;
}
