package com.elitesland.pur.dto.po;

import com.elitesland.pur.base.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购订单(PurPo)实体类
 *
 * @author liuqi
 * @since 2020-07-21 10:04:45
 */


@Data
@ApiModel(value = "pur_po", description = "采购订单")
public class PurPoDTO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -34281089348927283L;
    /**
     * 公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * BUID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BUID")
    private Long buId;
    private String buCode;
    private String buName;
    /**
     * 供应商ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司的地址号")
    private Long ouAddrNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库的地址号")
    private Long whAddrNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商的地址号")
    private Long suppAddrNo;

    /**
     * 发货数量
     */
    @ApiModelProperty("发货数量")
    Double shippedQty;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;
    /**
     * 供应商联系人
     */
    @ApiModelProperty("供应商联系人")
    String suppContactName;
    /**
     * 供应商联系电话
     */
    @ApiModelProperty("供应商联系电话")
    String suppContactTel;
    /**
     * 供应商联系人邮箱
     */
    @ApiModelProperty("供应商联系人邮箱")
    String suppContactEmail;
    /**
     * 供应商传真
     */
    @ApiModelProperty("供应商传真")
    String suppContactFax;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据类型 [UDC]PUR:PO_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:PO_TYPE")
    @SysCode(sys = "yst-purc", mod = "PO_TYPE")
    private String docType;
    @ApiModelProperty("单据类型名称")
    private String docTypeName;
    /**
     * 单据类型2 [UDC]PUR:PO_TYPE2
     */
    @ApiModelProperty("单据类型2 [UDC]PUR:PO_TYPE2")
    @SysCode(sys = "yst-purc", mod = "PO_TYPE2")
    private String docType2;
    @ApiModelProperty("单据类型2 [UDC]PUR:PO_TYPE2")
    private String docType2Name;
    /**
     * 单据状态 [UDC]PUR:PO_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:PO_STATUS")
    @SysCode(sys = "yst-purc", mod = "PO_STATUS")
    private String docStatus;
    @ApiModelProperty("单据状态名称")
    private String docStatusName;
    /**
     * 订单时间
     */
    @ApiModelProperty("订单时间")
    private LocalDateTime docTime;

    /**
     * 采购场景类型
     */
    @ApiModelProperty("采购场景类型ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sceneTypeId;

    @ApiModelProperty("采购场景类型名称")
    private String sceneTypeName;

    @ApiModelProperty("采购场景类型编码")
    private String sceneTypeCode;

    /**
     * 采购员员工ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购员员工ID")
    private Long agentEmpId;
    private String agentEmpCode;
    private String agentEmpName;

    @ApiModelProperty("采购员员工名称")
    private String empName;
    /**
     * 采购来源
     */
    @ApiModelProperty("采购来源")
    @SysCode(sys = "yst-purc", mod = "PO_GEN_TYPE")
    private String poSource;
    private String poSourceName;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    private String currName;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税总金额
     */
    @ApiModelProperty("含税总金额")
    private BigDecimal amt;
    /**
     * 未税总金额
     */
    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private Double qty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 付款条款
     */
    @ApiModelProperty("付款条款")
    private String paymentTerm;
    private String paymentTermName;
    /**
     * 要求交期
     */
    @ApiModelProperty("要求交期")
    private LocalDateTime demandDate;
    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp", mod = "TP_TYPE")
    private String transType;
    @ApiModelProperty("运输方式名称")
    private String transTypeName;
    /**
     * 收货仓库ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收货仓库ID")
    private Long whId;
    /**
     * 收货仓库联系人
     */
    @ApiModelProperty("收货仓库联系人")
    private String whContactName;
    /**
     * 收货仓库联系人电话
     */
    @ApiModelProperty("收货仓库联系人电话")
    private String whContactTel;
    /**
     * 收货仓库联系人邮箱
     */
    @ApiModelProperty("收货仓库联系人邮箱")
    private String whContactEmail;
    /**
     * 承运商供应商ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("承运商供应商ID")
    private Long carrierSuppId;
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carrierSuppCode;
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carrierSuppName;
    /**
     * 承运商
     */
    @ApiModelProperty("承运商")
    private String carrier;
    /**
     * 收货单位ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收货单位ID")
    private Long acceptOuId;
    /**
     * 收货地址
     */
    @ApiModelProperty("收货地址")
    private String recvAddr;
    /**
     * 退货地址
     */
    @ApiModelProperty("退货地址")
    private String returnAddr;
    /**
     * 收货允差
     */
    @ApiModelProperty("收货允差")
    private Double recvTolerance;
    /**
     * 合同ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("合同ID")
    private Long contractId;
    /**
     * 合同编号
     */
    @ApiModelProperty("合同编号")
    private String contractNo;
    /**
     * 供方合同号
     */
    @ApiModelProperty("供方合同号")
    private String suppContractNo;
    /**
     * 供方单号
     */
    @ApiModelProperty("供方单号")
    private String suppDocNo;
    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    /**
     * 收货总数量
     */
    @ApiModelProperty("收货总数量")
    private Double acceptQty;

    @ApiModelProperty("拒收总数量")
    private BigDecimal rejectedQty;
    /**
     * 关闭日期
     */
    @ApiModelProperty("关闭日期")
    private LocalDateTime closeDate;

    /**
     * 关联单据类别 来源销售单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 来源销售单等。[UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类别名称")
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联ID")
    private Long realteId;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String realteNo;
    /**
     * 关联2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联2ID")
    private Long realte2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String realte2No;
    /**
     * 备注2 货柜
     */
    @ApiModelProperty("备注2 货柜")
    private String remark2;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * 租户ID
     */
//    @JsonSerialize(using = ToStringSerializer.class)
//    @ApiModelProperty("租户ID")
//    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司地址")
    private String ouAddress;

    @ApiModelProperty("公司电话")
    private String ouPhone;

    @ApiModelProperty("公司传真")
    private String ouFax;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("供应商地址")
    private String suppAddress;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库类型")
    private String whType;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("采购明细")
    private List<PurPoDDTO> purPoDDTOList;

    @ApiModelProperty("收货联系人姓名")
    private String recvContactName;

    @ApiModelProperty("收货联系人电话")
    private String recvContactPhone;

    @ApiModelProperty("收货联系人传真号码")
    private String recvContactFax;

   // @ApiModelProperty("采购明细采购订单付款计划")
   // private List<PurPoPayplanRespVO> purPoPayplanRespVOlist;

    @ApiModelProperty("来源单据编号")
    String rootDocNo;

    @ApiModelProperty("单据类别")
    private String docCls;
}
