package com.elitesland.pur.contract.param;

import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author chun.yan
 * @Date 2024/3/13
 */
@Data
@ApiModel(description = "合同物料保存参数")
public class PurContractItemSaveRpcParam extends BaseModelVOMedItem {

    private static final long serialVersionUID = -7871305843089286140L;

    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty(value = "物料ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;


    @ApiModelProperty(value = "物料规格")
    private String itemSpec;

    @ApiModelProperty(value = "单位")
    private String uom;

    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "含税价")
    private BigDecimal taxPrice;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "不含税价")
    private BigDecimal netPrice;

    @ApiModelProperty(value = "材质")
    private String material;

    @ApiModelProperty(value = "产地")
    private String producingArea;

    @ApiModelProperty(value = "起订量")
    private BigDecimal minQty;

    @ApiModelProperty(value = "起送量")
    private BigDecimal sendQty;

    @ApiModelProperty("起订金额")
    private BigDecimal minAmt;

    @ApiModelProperty("供货周期")
    private BigDecimal supplyCycle;

    @ApiModelProperty(value = "取价方式")
    private String pricingMethod;

    @ApiModelProperty(value = "来源订单ID")
    private Long relateId;

    @ApiModelProperty(value = "来源单号")
    private String relateDocNo;

    @ApiModelProperty(value = "来源明细ID")
    private Long relateDid;

    @ApiModelProperty(value = "来源行号")
    private Integer relateLineNo;

    @ApiModelProperty(value = "阶梯从")
    private Integer tieredFrom;

    @ApiModelProperty(value = "阶梯至")
    private Integer tieredTo;

    @ApiModelProperty(value = "含税价2")
    private BigDecimal taxPrice2;

    @ApiModelProperty(value = "不含税价2")
    private BigDecimal netPrice2;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "品质等级")
    private String qualifyLevel;

    @ApiModelProperty(value = "基准价")
    private BigDecimal basePrice;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "行号")
    private Integer lineNo;

    @ApiModelProperty(value = "累计采购量")
    private BigDecimal sumPurQty;
}
