package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/05/23
 * @Version 1.0
 * @Content:
 */
@Data
public class PurSsDRpcParam extends BaseModelMedOrderDVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1661289712318546405L;

    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 采购订单明细ID
     */
    @ApiModelProperty("采购订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poDId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 发货数量
     */
    @ApiModelProperty("发货数量")
    private BigDecimal qty;
    @ApiModelProperty("最大允差比例")
    private BigDecimal toleranceRatio;
    /**
     * 收货允差
     */
    @ApiModelProperty("收货允差")
    private BigDecimal recvTolerance;

    @ApiModelProperty("收货允差")
    private BigDecimal recvTolerance2;


    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 发货数量2
     */
    @ApiModelProperty("发货数量2")
    private BigDecimal qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private BigDecimal uomRatio2;
    /**
     * 发货批次
     */
    @ApiModelProperty("发货批次")
    private String lotNo;
    /**
     * 生产批次
     */
    @ApiModelProperty("生产批次")
    private String menuLotNo;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    /**
     * 过期日期
     */
    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;
    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 剩余效期天数
     */
    @ApiModelProperty("剩余效期天数")
    private Integer untilExpireDays;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private BigDecimal demandFreshPercent;
    /**
     * 最低允收期天数
     */
    @ApiModelProperty("最低允收期天数")
    private Integer demandAapDays;
    /**
     * 预计到货时效期天数
     */
    @ApiModelProperty("预计到货时效期天数")
    private Integer etaAapDays;
    /**
     * 是否新鲜度合格
     */
    @ApiModelProperty("是否新鲜度合格")
    private Integer isFressValid;

    @ApiModelProperty("到货保质期比例")
    private BigDecimal actualFreshPercent;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootId;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long outerId;

    @ApiModelProperty("外部单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long outerDid;

    @ApiModelProperty("外部单据行号")
    private BigDecimal outerLineno;


    @ApiModelProperty("来源单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据明细功能区")
    private String rootDocDeter2;

    @ApiModelProperty("来源单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDid;

    @ApiModelProperty("来源单据明细行号")
    private BigDecimal rootDocLineno;

    @ApiModelProperty("关联单据类型")
    private String rootDocType;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;

    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;

    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("关联单据2明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;

    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;

    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("ES4")
    private String es4;

    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("品牌")
    private String dbrand;

    @ApiModelProperty("是否含税")
    private Integer taxInclFlag;


    @ApiModelProperty("基价")
    private BigDecimal basePrice;
    ;

    @ApiModelProperty("价格类型")
    private String priceType;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("折扣类型")
    private String discType;

    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;

    @ApiModelProperty("折扣额")
    private BigDecimal discAmt;

    @ApiModelProperty("折扣描述")
    private String discDesc;

    @ApiModelProperty("折扣后价格")
    private BigDecimal discedPrice;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("外币含不税单价")
    private BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    private BigDecimal currPrice;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    /**
     * 订购数量
     */
    @ApiModelProperty("订购数量")
    private BigDecimal poQty;

    @ApiModelProperty("供应商发货单已收数量")
    private BigDecimal acceptQty;
}
