package com.elitesland.pur.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/22
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purPriceParamDTO", description = "获取采购价格DTO入参")
public class PurPriceParamDTO implements Serializable {

    private static final long serialVersionUID = 1778196094175766334L;

    @ApiModelProperty("商品ID")
    @NotNull(message = "商品ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("单位")
    @NotNull(message = "单位不能为空")
    private String uom;

    @ApiModelProperty("币种")
    @NotNull(message = "币种不能为空")
    private String currCode;

    @ApiModelProperty("公司ID")
    @NotNull(message = "公司ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("生效日期")
    @NotNull(message = "生效日期不能为空")
    private LocalDate validDate;
}
