package com.elitesland.pur.dto.gr;

import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 采购收货单明细(PurGrD)实体类
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-08-05 17:07:28
 */
@Data
@ApiModel(value = "pur_gr_d", description = "采购收货单明细")
@EqualsAndHashCode(callSuper = true)
public class PurGrDSaveVODTO extends BaseModelMedOrderDVO implements Serializable {
    private static final long serialVersionUID = -11465120562135707L;

    @ApiModelProperty("单位成本")
    private BigDecimal costPrice;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private Double lineNo;
    /**
     * 采购订单明细ID
     */
    @ApiModelProperty("采购订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poDId;
    /**
     * 供应商发货单明细ID
     */
    @ApiModelProperty("供应商发货单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ssDId;

    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemSpec;
    /**
     * 订购数量
     */
    @ApiModelProperty("订购数量")
    private Double poQty;

    @ApiModelProperty("发货数量")
    private Double ssQty;
    /**
     * 收货数量
     */
    @ApiModelProperty("收货数量")
    private BigDecimal qty;

    /**
     * 收货状态
     */
    @ApiModelProperty("收货状态")
    private String recvStatus;

    @ApiModelProperty("拒收数量")
    private BigDecimal rejectQty;

    @ApiModelProperty("单位")
    private String uom;

    /**
     * 收货数量2
     */
    @ApiModelProperty("收货数量2 - 和入库单位一致的收货数量")
    private BigDecimal qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 保留小数位
     */
    @ApiModelProperty("保留小数位")
    private Integer decimalPlaces;
    /**
     * 税额
     */
    @ApiModelProperty("税额（原币）")
    private BigDecimal taxAmt;


    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额（本币）")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额（本币）")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额（原币）")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额（原币）")
    private BigDecimal currNetAmt;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    /**
     * 收货批次
     */
    @ApiModelProperty("收货批次")
    private String lotNo;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    /**
     * 过期日期
     */
    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;
    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 供应商发货日期
     */
    @ApiModelProperty("供应商发货日期")
    private LocalDateTime shipmentDate;
    /**
     * 异常备注
     */
    @ApiModelProperty("异常备注")
    private String exceptionDesc;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private Double relateDocLineno;

    @ApiModelProperty("来源单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据类型")
    private String rootDocType;

    @ApiModelProperty("来源单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDid;

    @ApiModelProperty("来源单据明细行号")
    private Double rootDocLineno;


    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private Double relateDoc2Lineno;

    @ApiModelProperty("品牌")
    private String dbrand;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("外币含不税单价")
    private BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    private BigDecimal currPrice;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private Double currRate;

    @ApiModelProperty("收货单据编号")
    String grNo;

    @ApiModelProperty("退货申请数量")
    private BigDecimal rpoReturnQty;

    /**
     * 收货允差
     */
    @ApiModelProperty("最大允差比例")
    private BigDecimal toleranceRatio;

    @ApiModelProperty("收货允差")
    private BigDecimal recvTolerance;

    @ApiModelProperty("入库日期")
    private LocalDateTime storageDate;

    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;

    @ApiModelProperty("是否为复制数据行")
    private Boolean isCopy;

    @ApiModelProperty("商品库存状态 [UDC:inv]STK_ITM_STATUS")
    private String stkItmStatus;

    @ApiModelProperty("开票数量")
    private BigDecimal invoiceQty;

    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty("销售含税金额")
    private BigDecimal lastPathSaleAmt;

    @ApiModelProperty("销售含税单价")
    private BigDecimal lastPathSalePrice;

    @ApiModelProperty("结算含税单价")
    private BigDecimal amortizedPrice;

    @ApiModelProperty("采购收货已退货数量")
    private BigDecimal returnedQty;

    @ApiModelProperty("采购退货登记单已签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("对账数量")
    private BigDecimal checkQty;

    @ApiModelProperty("对账状态")
    private String accountStatus;

    @ApiModelProperty("生产厂家")
    private String manuFactory;

    @ApiModelProperty("生产厂家名")
    private String manuFactoryName;

    @ApiModelProperty(value = "研发项目")
    private String rdPro;

    @ApiModelProperty(value = "管理复检有效期")
    private Boolean manageRecheckValidityFlag;

    @ApiModelProperty(value = "是否管理批号")
    private Boolean manageLotFlag;
}
