package com.elitesland.pur.dto.supp;


import com.elitesland.pur.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/01
 * @Version 1.0
 * @Content:
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "purAddrBankAccDTO", description = "供应商的银行信息出参对象")
public class PurAddrBankAccDTO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -7214858631817985473L;
    @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    String accType;

    @ApiModelProperty("是否默认：1是，0否")
    Boolean defaultFlag;

    @ApiModelProperty("银行ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long bankId;

    @ApiModelProperty("开户行代码")
    String bankCode;

    @ApiModelProperty("开户行名称")
    String bankName;

    @ApiModelProperty("网点名称")
    String branchName;

    @ApiModelProperty("开户行账号")
    String bankAcc;

    @ApiModelProperty("开户姓名")
    String holderName;

    @ApiModelProperty("币种")
    String currCode;
    @ApiModelProperty("币种名称")
    String currName;

    @ApiModelProperty("用户ID")
    private String thirdpartyVirtualUserId;

    @ApiModelProperty("银行账户绑定流水号")
    private String thirdpartyVirtualAcc;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("主表业务类型")
    String masDocCls;

    @ApiModelProperty("数据来源")
    private String dataSource;
}
