package com.elitesland.pur.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 获取有价商品
 *
 * @author chaofeng.xia
 * @date 2023/10/9 13:07
 */
@Data
@ApiModel(value = "purPriceItemDTO", description = "获取有价商品")
public class PurPriceItemDTO implements Serializable {

    private static final long serialVersionUID = -1561653541306622822L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("生效日期")
    private LocalDate validDate;

    @ApiModelProperty("商品ids")
    private List<Long> itemIds;
}
