package com.elitesland.pur.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <p>
 * 商品采购价格查询参数
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020/7/24
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "商品采购价格查询参数", description = "商品采购价格查询参数")
public class PurPriceParamRpcDTO implements Serializable {

    private static final long serialVersionUID = 2025488792130892378L;

    @ApiModelProperty("唯一标识")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long uuid;

    @ApiModelProperty("商品ID")
    @NotNull(message = "商品ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("公司ID")
    @NotNull(message = "公司ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("供应商ID")
    @NotNull(message = "供应商ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("采购单位")
    @NotNull(message = "采购单位不能为空")
    private String uom;

    @ApiModelProperty("币种")
    @NotNull(message = "币种不能为空")
    private String currCode;

    @ApiModelProperty("业务日期")
    @NotNull(message = "业务日期不能为空")
    @JsonFormat(pattern ="yyyy-MM-dd HH:mm:ss", timezone ="GMT+8")
    private LocalDateTime docTime;

    @ApiModelProperty("采购数量")
    @NotNull(message = "采购数量不能为空")
    private BigDecimal qty;

    @ApiModelProperty("主单位")
    private String mainUom;

    @ApiModelProperty("mainMoq：主单位最小起订量")
    private BigDecimal mainMoq;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;

//    @ApiModelProperty("合同号")
//    private String contractNo;
}
