package com.elitesland.pur.dto;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <p>
 * 品项采购累计订货数量
 * </p>
 *
 * @author nc
 * @since 2025-09-16
 */
@Data
@ApiModel
public class PurPurcQtyDTO {

	private static final long serialVersionUID = 1L;


    /**
     * 增加类型 1增加 2减
     */
    @ApiModelProperty(value = "增加类型 1增加 2减")
    private Integer addType;

    /**
     * 合同号
     */
    @ApiModelProperty(value = "合同号")
    private String contractNo;


    @ApiModelProperty(value = "商品编码")
    private Long itemId;

    @ApiModelProperty(value = "公司编号")
    private Long ouId;

    @ApiModelProperty(value = "供应商编号")
    private Long suppId;
    /**
     * 商品名称
     */
    @ApiModelProperty(value = "商品名称")
    private String itemName;

    /**
     * 累计单据号
     */
    @ApiModelProperty(value = "累计单据号")
    private String orderCode;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    /**
     * 增减数量 需要正负值存储
     */
    @ApiModelProperty(value = "增减数量 需要正负值存储")
    private BigDecimal qty;



    /**
     * 供应商名称
     */
    @ApiModelProperty(value = "供应商名称")
    private String suppName;

}
