package com.elitesland.pur.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;


/**
 * <p>
 * 品项采购累计订货数量
 * </p>
 *
 * @author nc
 * @since 2025-09-16
 */
@Data
@ApiModel
public class PurPurcQtySumRespDTO {

	private static final long serialVersionUID = 1L;

	/**
	 * 合同号
	 */
	@ApiModelProperty(value = "合同号")
	private String contractNo;
	/**
	 * 商品编码
	 */
	@ApiModelProperty(value = "商品编码")
	@NotNull(message = "商品编码" + "不能为空")
	@Size(max = 100, message = "商品ID不能空")
	private Long itemId;

	/**
	 * 公司编号
	 */
	@ApiModelProperty(value = "公司编号")
	@NotNull(message = "公司编号" + "不能为空")
	@Size(max = 100, message = "公司ID不能空")
	private Long ouId;

	/**
	 * 供应商编号
	 */
	@ApiModelProperty(value = "供应商编号")
	@NotNull(message = "供应商编号" + "不能为空")
	@Size(max = 100, message = "供应商ID不能空")
	private Long suppId;

	/**
	 * 累计单据号
	 */
	@ApiModelProperty(value = "累计单据号")
	private String orderCode;



	@ApiModelProperty(value = "采购累计订货量")
	private BigDecimal sumQty;




}