package com.elitesland.pur.dto.gr;

import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(description = "采购收货单明细")
public class PurGrDetailRpcDTO extends BaseModelMedOrderDVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("明细ID")
    private Long id;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("入库批次")
    private String inLotNo;

    @ApiModelProperty("发货数量")
    private BigDecimal deliveryQty;

    @ApiModelProperty("入库数量")
    private BigDecimal inQty;

    @ApiModelProperty("订货数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("基本单位")
    private String uom2;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("小数位数")
    private Integer places;

    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("可退数量")
    private BigDecimal canRtnQty;

    @ApiModelProperty("关联单据类别 [UDC]SUPP:DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类型")
    private  String relateDocType;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private  String relateDocNo;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    @ApiModelProperty("关联单据行号")
    private Double relateDocLineno;

    @ApiModelProperty("关联单据2类别 [UDC]SUPP:DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    @ApiModelProperty("关联单据2行号")
    private Double relateDoc2Lineno;

    @ApiModelProperty("来源单据类别 [UDC]SUPP:DOC_CLS")
    private String rootDocCls;
    @ApiModelProperty("来源单据类型")
    private String rootDocType;
    @ApiModelProperty("来源单据Id")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    private  String rootDocNo;
    @ApiModelProperty("来源单据明细ID")
    private Long rootDocDid;
    @ApiModelProperty("来源单据行号")
    private Double rootDocLineno;
}