package com.elitesland.pur.dto.gr;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Getter
@Setter
@ApiModel(description = "采购收货单")
public class PurGrRpcDTO extends BaseModelMedOrderVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("地址号")
    private Long addrNo;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("收货仓库")
    private Long toWhId;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("发货供应商")
    private Long suppId;

    @ApiModelProperty("发货供应商")
    private String suppCode;

    @ApiModelProperty("发货供应商")
    private String suppName;

    @ApiModelProperty("状态")
    private String docStatus;
    @ApiModelProperty("采购订单ID")
    private Long poId;

    @ApiModelProperty("入库单号")
    private String invIdoDocNo;

    private List<PurGrDetailRpcDTO> rpcDTOS;
}