package com.elitesland.pur.dto.gr;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * <p>
 * 采购收货单(PurGr)实体类
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-08-05 17:04:52
 */
@Data
@ApiModel(value = "pur_gr", description = "采购收货单")
@EqualsAndHashCode(callSuper = true)
public class PurGrSaveVODTO extends BaseModelMedOrderVO implements Serializable {
    private static final long serialVersionUID = 194589649559012783L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司编码")
    private String ouCode;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据类型 [UDC]PUR:GR_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:GR_TYPE")
    private String docType;
    /**
     * 单据状态 [UDC]PUR:GR_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:GR_STATUS")
    private String docStatus;
    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    /**
     * 收货人员工ID
     */
    @ApiModelProperty("收货人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long recvEmpId;

    /**
     * 收货人员工名字
     */
    @ApiModelProperty("收货人员工名字")
    @JsonSerialize(using = ToStringSerializer.class)
    private String recvEmpName;

    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private BigDecimal qty;

    @ApiModelProperty("总拒收数量")
    private BigDecimal rejectQty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 记账币种
     */
    @ApiModelProperty("记账币种")
    private String homeCurr;
    /**
     * 交易币种
     */
    @ApiModelProperty("交易币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double  currRate;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;

    @ApiModelProperty("是否需要出入库")
    private String es11;

    @ApiModelProperty("是否含税")
    private Integer taxInclFlag;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private Double taxRate;

    /**
     * 逻辑删除，0：无接口，1：有接口
     */
    @ApiModelProperty("逻辑删除，0：无接口，1：有接口")
    private Integer intfFlag;

    @ApiModelProperty("采购收货单明细")
    private List<PurGrDSaveVODTO> purGrDSaveVOList;

    @ApiModelProperty("采购结算对账单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long purAccountCheckId;

    @ApiModelProperty(value = "是否生成采购结算对账单，0：未生成，1：已生成")
    private Integer accountFlag;

    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull
    private Long outerId;

    /**
     * 文件服务器编码
     */
    @ApiModelProperty("文件服务器编码")
    private String fileCode;

    private Boolean groupFlag;

    /**
     * 是否团内 [UDC]ORG:SUPP_TYPE2
     */
    @ApiModelProperty("是否团内 [UDC]ORG:SUPP_TYPE2")
    @SysCode(sys = "yst-supp", mod = "SUPP_TYPE2")
    private String insideStatus;
    @ApiModelProperty("是否团内名称")
    private String insideStatusName;

    @ApiModelProperty("仓库联系人电话")
    private String tel;

    @ApiModelProperty("收货地址国家")
    private String country;

    @ApiModelProperty("收货地址省")
    private String province;

    @ApiModelProperty("收货地址市")
    private String city;

    @ApiModelProperty("收货地址区县")
    private String county;

    @ApiModelProperty("收货地址详细地址")
    private String detailAddr;

    @ApiModelProperty("员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long empId;

    @ApiModelProperty("付款条款")
    private String paymentTerm;

    @ApiModelProperty("员工")
    private String empCode;

    private Boolean isFromSsFlag;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    @ApiModelProperty("单据类型")
    String poType;

    @ApiModelProperty("采购场景ID")
    private Long sceneTypeId;

    @ApiModelProperty("采购场景编码")
    private String sceneTypeCode;

    @ApiModelProperty("是否需要验收 0：否 1是")
    private Integer acceptance;
    @ApiModelProperty("是否需要验收 0：否 1是")
    private String acceptanceName;

    @ApiModelProperty("采购订单订购日期")
    private LocalDateTime poDocTime;

    @ApiModelProperty("出货方式")
    private String sellMethod;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("越库标识 true=是，false=否，默认值为false")
    private Boolean overStockFlag;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据Id")
    private Long rootDocId;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    @ApiModelProperty("来源单据类型")
    private String rootDocType;

    @ApiModelProperty("要交日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;

    @ApiModelProperty("项目编码")
    private String projectCode;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("结算路径")
    private String pathCode;

    @ApiModelProperty("公司间一致性")
    private Boolean companyConsistentFlag;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDate;

    @ApiModelProperty("内外部客户")
    private String inOutCustomer;

    @ApiModelProperty("是否需要删除明细行,重新插入 no 不删除")
    private String deleteDetailFlag;

    @ApiModelProperty("要货类型 [UDC]yst-suplan:DEMAND_SET_TYPE")
    private String demandType;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("来源单业务场景编码（采购：采购场景 退货：退货订单类型（RJ,RW））")
    private String sourceCode;
    @ApiModelProperty("来源单业务场景名称")
    private String sourceName;

    @ApiModelProperty("采购订单ID")
    private Long poId;

    @ApiModelProperty("入库单号")
    private String invIdoDocNo;
}
