package com.elitesland.pur.dto.ss;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 供应商发货单
 * </p>
 *
 * @author liuqi
 * @since 2020-08-03 10:55:08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "pur_ss", description = "供应商发货单")
public class PurSsRespVODTO extends BaseModelMedOrderVO implements Serializable {
    private static final long serialVersionUID = 612060958576140290L;

    /**
     * 公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;
    private String ouCode;
    private String ouName;
    /**
     * BUID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BUID")
    private Long buId;

    @ApiModelProperty("采购组织名称")
    private String buName;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据状态 [UDC]PUR:SS_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:SS_STATUS")
    @SysCode(sys = "yst-purc", mod = "SS_STATUS")
    private String docStatus;
    @ApiModelProperty("单据状态名称")
    private String docStatusName;

    @ApiModelProperty("发货总数")
    private BigDecimal qty;
    private BigDecimal qtySum;

    @ApiModelProperty("收货总数")
    private BigDecimal acceptQty;

    @ApiModelProperty("拒收总数")
    private BigDecimal rejectedQty;

    /**
     * 发货日期
     */
    @ApiModelProperty("发货日期")
    private LocalDateTime shipmentDate;
    /**
     * 仓库ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    private Long whId;
    private String whCode;
    private String whName;
    private String whType;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    @ApiModelProperty("功能区名称")
    private String deter2Name;
    /**
     * 预计到货日期
     */
    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;
    /**
     * 发运联系人
     */
    @ApiModelProperty("发运联系人")
    private String shipmentContactName;

    /**
     * 发货人(发货提交的当前登录人,在生成收货单使用)
     */
    @ApiModelProperty("发货人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long shipmentEmpId;
    /**
     * 发运联系电话
     */
    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;

    @ApiModelProperty("发运国家")
    private String shipmentCountry;
    @ApiModelProperty("发运国家-名称")
    private String shipmentCountryName;
    @ApiModelProperty("省")
    private String shipmentProvince;
    @ApiModelProperty("省-名称")
    private String shipmentProvinceName;

    @ApiModelProperty("市")
    private String shipmentCity;
    @ApiModelProperty("市-名称")
    private String shipmentCityName;
    @ApiModelProperty("区")
    private String shipmentCounty;
    @ApiModelProperty("区-名称")
    private String shipmentCountyName;
    @ApiModelProperty("详细地址")
    private String shipmentDetailaddr;

    /**
     * 发运乡镇街道
     */
    @ApiModelProperty("发运乡镇街道")
    private String shipmentStreet;


    @ApiModelProperty("是否创建配送单")
    private Boolean carriageFlag;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税总金额")
    private BigDecimal amt;

    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;

    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("收货人名称")
    private String recvEmpName;

    @ApiModelProperty("收货人ID")
    private Long recvEmpId;

    @ApiModelProperty("仓库联系人电话")
    private String tel;

    @ApiModelProperty("收货地址国家")
    private String country;
    private String countryName;

    @ApiModelProperty("收货地址省")
    private String province;
    private String provinceName;

    @ApiModelProperty("收货地址市")
    private String city;
    private String cityName;

    @ApiModelProperty("收货地址区县")
    private String county;
    private String countyName;

    @ApiModelProperty("收货地址")
    private String detailAddr;

    @ApiModelProperty("供应商发货单")
    private List<PurSsDRespVODTO> purSsDRespVOList;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp",mod = "TP_TYPE")
    private String transType;
    @ApiModelProperty("运输方式名称")
    private String transTypeName;
    @ApiModelProperty("承运商联系人")
    private String carrierContactName;
    @ApiModelProperty("承运商联系电话")
    private String carrierContactTel;

    @ApiModelProperty("承运商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carrierSuppId;
    @ApiModelProperty("承运商名称")
    private String carrierSuppName;

    @ApiModelProperty("越库标识 true=是，false=否，默认值为false")
    private Boolean overStockFlag;

    @ApiModelProperty("要求到货日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("采购场景编号")
    private String sceneTypeCode;
    private Long sceneTypeId;
    private String sceneTypeName;

    @ApiModelProperty("是否需要验收 0：否 1：是")
    private Integer acceptance;

    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;

    @ApiModelProperty("结算路径")
    private String pathCode;

    @ApiModelProperty("公司间一致性")
    private Boolean companyConsistentFlag;

    @ApiModelProperty("供应商类型2 [UDC]PUR:SUPP_TYPE2")
    @SysCode(sys = "yst-purc", mod = "SUPP_TYPE2")
    private String suppType2;
    private String suppType2Name;
    @ApiModelProperty("承运商名称")
    private String carrierName;

    @ApiModelProperty("采购订单订货数量")
    private BigDecimal poQtySum;

    @ApiModelProperty("收货允差")
    private BigDecimal recvToleranceSum;

    @ApiModelProperty("实际未发数量(可发货数量)")
    private BigDecimal acUnshipQtySum;

    @ApiModelProperty("发货类型")
    @SysCode(sys = "yst-purc", mod = "SHIPMENT_TYPE")
    private String shipmentType;
    private String shipmentTypeName;

    @ApiModelProperty("供应商归属公司")
    private List<PurSuppOuRespVODTO> suppOuRespVOList;

    @ApiModelProperty("内外部客户")
    private String inOutCustomer;

    @ApiModelProperty("要货类型 [UDC]yst-suplan:DEMAND_SET_TYPE")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String demandType;
    private String demandTypeName;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("发货地址号")
    private Long deliverAddrNo;

    @ApiModelProperty("发货联系人")
    private String deliverContactName;

    @ApiModelProperty("发货联系人电话")
    private String deliverContactTel;

    @ApiModelProperty("发货联系人email")
    private String deliverContactEmail;

    @ApiModelProperty("发货国家")
    private String deliverCountry;

    @ApiModelProperty("发货省份")
    private String deliverProvince;

    @ApiModelProperty("发货城市")
    private String deliverCity;

    @ApiModelProperty("发货乡镇")
    private String deliverCounty;

    @ApiModelProperty("发货街道")
    private String deliverStreet;

    @ApiModelProperty("发货详细地址")
    private String deliverDetailaddr;

    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;

    @ApiModelProperty("收货地址联系人")
    private String recvContactName;

    @ApiModelProperty("收货地址电话")
    private String recvContactTel;

    @ApiModelProperty("收货联系人邮箱")
    private String recvContactEmail;

    @ApiModelProperty("收货国家")
    private String recvCountry;

    @ApiModelProperty("收货省")
    private String recvProvince;

    @ApiModelProperty("收货市")
    private String recvCity;

    @ApiModelProperty("收货区县")
    private String recvCounty;

    @ApiModelProperty("收货乡镇街道")
    private String recvStreet;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;


    @ApiModelProperty(value = "是否免检，true：免检，false：需要质检")
    private Boolean qt;


    /**
     * 推送WMS状态（0-未推送 1-推送成功 2-推送失败）
     */
    @ApiModelProperty(value = "推送WMS状态：0-未推送 1-推送成功 2-推送失败")
    private Integer pushWmsStatus;

    /**
     * 推送WMS异常日志
     */
    @ApiModelProperty(value = "推送WMS异常日志")
    private String pushWmsErrorLog;

    /**
     * 最近一次推送WMS时间
     */
    @ApiModelProperty(value = "最近一次推送WMS时间")
    private LocalDateTime lastPushWmsTime;

    /**
     * WMS回传状态
     */
    @ApiModelProperty(value = "WMS回传状态")
    private String wmsCallbackStatus;

    /**
     * WMS撤回时间
     */
    @ApiModelProperty(value = "WMS撤回时间")
    private LocalDateTime wmsWithdrawTime;

    /**
     * WMS撤回日志
     */
    @ApiModelProperty(value = "WMS撤回日志")
    private String wmsWithdrawLog;

    private String relateDocClsName;

    @ApiModelProperty("来源单业务场景编码（采购：采购场景 退货：退货订单类型（RJ,RW））")
    private String sourceCode;
    @ApiModelProperty("来源单业务场景名称")
    private String sourceName;
}
