package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class PurSuppSubItemRpcVO implements Serializable {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty("唯一ID")
    private Long id;

    @ApiModelProperty("主表id")
    private Long masId;
    @ApiModelProperty("所属公司ID")
    private Long ouId;
    /**
     * 所属公司编号
     */
    @ApiModelProperty(value = "所属公司编号")
    private String ouCode;

    /**
     * 所属公司名称
     */
    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    @ApiModelProperty("供应商编码")
    private String suppCode;
    @ApiModelProperty("企业(供应商)名称")
    private String suppName;
    @ApiModelProperty("企业(供应商)简称")
    private String suppAbbr;
    /**
     * 商品id
     */
    @ApiModelProperty(value = "商品id")
    private Long itemId;
    /**
     * SKU商品编号
     */
    @ApiModelProperty(value = "SKU商品编号")
    private String itemCode;

    /**
     * SKU商品名称
     */
    @ApiModelProperty(value = "SKU商品名称")
    private String itemName;

    @ApiModelProperty("生产厂家")
    private String manuFactory;
    @ApiModelProperty("生产厂家名称")
    private String manuFactoryName;

    @ApiModelProperty(value = "产地")
    private String origin;
    @ApiModelProperty(value = "质量标准")
    private String qualityStandard;
    @ApiModelProperty(value = "剂型")
    @SysCode(sys = "yst-supp", mod = "DOSAGE_FORM")
    private String dosageForm;
    @ApiModelProperty(value = "剂型")
    private String dosageFormName;
    @ApiModelProperty(value = "来源单号")
    private String sourceDocNo;

}
