package com.elitesland.pur.contract.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.contract.param.PurContractSaveRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * <p>
 * 功能说明: 采购合同
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/22
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurContractProvider.PATH)
public interface PurContractProvider {
    String PATH = "/purContract";

    /**
     * 创建采购合同
     * @param param
     * @return
     */
    @PostMapping("/createOne")
    ApiResult<Long> createOne(@RequestBody @Valid PurContractSaveRpcParam param);


}
