package com.elitesland.pur.dto.supp;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.pur.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/01
 * @Version 1.0
 * @Content:
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "purAddrBankAccDTO", description = "供应商的银行信息出参对象")
public class PurAddrBankAccDTO extends BaseModelVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -7214858631817985473L;

    @ApiModelProperty("ID")
    private Long id;
    @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    @SysCode(sys = "yst-supp", mod = "ADDR_BANKACC_TYPE")
    private String accType;
    @ApiModelProperty("账号类型名称")
    private String accTypeName;
    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;
    @ApiModelProperty("银行ID")
    private Long bankId;
    @ApiModelProperty("银行编号")
    private String bankCode;
    @ApiModelProperty("银行名称")
    private String bankName;
    @ApiModelProperty("网点编码")
    private String branchCode;
    @ApiModelProperty("网点名称")
    private String branchName;
    @ApiModelProperty("开户行账号")
    private String bankAcc;
    @ApiModelProperty("开户人姓名")
    private String holderName;
    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("币种名称")
    private String currName;
    @ApiModelProperty("第三方虚拟用户ID")
    private String thirdpartyVirtualUserId;
    @ApiModelProperty("第三方虚拟帐户")
    private String thirdpartyVirtualAcc;
    @ApiModelProperty("数据来源")
    private String dataSource;
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    @ApiModelProperty("收付款方式：[UDC]COM:PAY_METHOD")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String payCollectMethod;
    private String payCollectMethodName;

    @ApiModelProperty("主表ID")
    private Long masId;
    @ApiModelProperty("主表业务类型")
    private String masDocCls;
}
