package com.elitesland.pur.contract.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author chun.yan
 * @Date 2024/3/13
 */
@Data
@ApiModel(description = "合同保存参数")
public class PurContractSaveRpcParam implements Serializable {

    private static final long serialVersionUID = 5366649052113274004L;

    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "合同号")
    private String contractNo;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "签订地点")
    private String signingLocation;
    @ApiModelProperty(value = "合同状态")
    private String contractStatus;

    @ApiModelProperty(value = "合同类型")
    private String contractType;

    @ApiModelProperty(value = "合同模板")
    private String contractTemplate;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "供应商ID")
    private Long suppId;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ApiModelProperty(value = "币种")
    private String cuurCode;

    @ApiModelProperty(value = "账期")
    private String accountPeriod;
    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "签署日期")
    private LocalDateTime contractTime;

    @ApiModelProperty(value = "合同生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "合同失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("合同金额")
    private BigDecimal contractAmt;

    @ApiModelProperty("合同总金额")
    private BigDecimal contractTotalAmt;

    @ApiModelProperty("合同金额大写")
    private String contractAmtWords;

    @ApiModelProperty(value = "合同数量")
    private BigDecimal qty;

    // 公司基本信息
    @ApiModelProperty(value = "公司基本信息-法人代表")
    private String ouReprName;
    @ApiModelProperty(value = "公司基本信息-纳税人识别号")
    private String ouCertNo;
    @ApiModelProperty(value = "公司基本信息-开户银行")
    private String ouBankName;
    @ApiModelProperty(value = "公司基本信息-支行")
    private String ouBranchName;
    @ApiModelProperty(value = "公司基本信息-银行账号")
    private String ouBankAcc;
    @ApiModelProperty(value = "公司基本信息-联系人")
    private String ouContact;
    @ApiModelProperty(value = "公司基本信息-联系电话")
    private String ouMobile;
    @ApiModelProperty(value = "公司基本信息-联系人邮箱")
    private String ouEmail;
    @ApiModelProperty(value = "公司基本信息-国家")
    private String ouCountry;
    @ApiModelProperty(value = "公司基本信息-省")
    private String ouProvince;
    @ApiModelProperty(value = "公司基本信息-市")
    private String ouCity;
    @ApiModelProperty(value = "公司基本信息-区")
    private String ouCounty;
    @ApiModelProperty(value = "公司基本信息-地址")
    private String ouAddress;

    @ApiModelProperty("公司基本信息-收货人姓名")
    private String ouRecvContact;
    @ApiModelProperty("公司基本信息-收货人电话")
    private String ouRecvMobile;
    @ApiModelProperty("公司基本信息-收货人邮箱")
    private String ouRecvEmail;
    @ApiModelProperty(value = "公司基本信息-收货人国家")
    private String ouRecvCountry;
    @ApiModelProperty(value = "公司基本信息-收货人省")
    private String ouRecvProvince;
    @ApiModelProperty(value = "公司基本信息-收货人市")
    private String ouRecvCity;
    @ApiModelProperty(value = "公司基本信息-收货人区")
    private String ouRecvCounty;
    @ApiModelProperty(value = "公司基本信息-收货人地址")
    private String ouRecvAddress;

    // 供应商基本信息
    @ApiModelProperty(value = "供应商基本信息-法人代表")
    private String suppReprName;
    @ApiModelProperty(value = "供应商基本信息-纳税人识别号")
    private String suppCertNo;
    @ApiModelProperty(value = "供应商基本信息-开户银行")
    private String suppBankName;
    @ApiModelProperty(value = "供应商基本信息-支行")
    private String suppBranchName;
    @ApiModelProperty(value = "供应商基本信息-银行账号")
    private String suppBankAcc;
    @ApiModelProperty(value = "供应商基本信息-联系人")
    private String suppContact;
    @ApiModelProperty(value = "供应商基本信息-联系电话")
    private String suppMobile;
    @ApiModelProperty(value = "供应商基本信息-联系人邮箱")
    private String suppEmail;
    @ApiModelProperty(value = "供应商基本信息-国家")
    private String suppCountry;
    @ApiModelProperty(value = "供应商基本信息-省")
    private String suppProvince;
    @ApiModelProperty(value = "供应商基本信息-市")
    private String suppCity;
    @ApiModelProperty(value = "供应商基本信息-区")
    private String suppCounty;
    @ApiModelProperty(value = "供应商基本信息-地址")
    private String suppAddress;

    @ApiModelProperty("供应商基本信息-发货人姓名")
    private String suppShipContact;
    @ApiModelProperty("供应商基本信息-发货人电话")
    private String suppShipMobile;
    @ApiModelProperty("供应商基本信息-发货人邮箱")
    private String suppShipEmail;
    @ApiModelProperty(value = "供应商基本信息-发货人国家")
    private String suppShipCountry;
    @ApiModelProperty(value = "供应商基本信息-发货人省")
    private String suppShipProvince;
    @ApiModelProperty(value = "供应商基本信息-发货人市")
    private String suppShipCity;
    @ApiModelProperty(value = "供应商基本信息-发货人区")
    private String suppShipCounty;
    @ApiModelProperty(value = "供应商基本信息-发货人地址")
    private String suppShipAddress;

    @ApiModelProperty(value = "有效合同总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty(value = "账户余额")
    private BigDecimal accountBalance;

    @ApiModelProperty(value = "应缴纳质保金")
    private BigDecimal payWarranty;

    @ApiModelProperty(value = "价格类型")
    private String priceType;

    @ApiModelProperty(value = "是否组装")
    private String assemble;

    @ApiModelProperty(value = "累计合同订单金额")
    private BigDecimal totalOrderAmt;

    @ApiModelProperty(value = "累计合同退货订单金额")
    private BigDecimal totalReturnAmt;

    @ApiModelProperty(value = "累计合同入库金额")
    private BigDecimal totalWarehousingAmt;

    @ApiModelProperty(value = "累计合同退货出库金额")
    private BigDecimal totalOutboundAmt;

    @ApiModelProperty(value = "累计合同预付款金额")
    private BigDecimal totalAdvanceAmt;

    @ApiModelProperty(value = "累计合同应付单已付金额")
    private BigDecimal totalPayAmt;

    @ApiModelProperty(value = "订单达成率")
    private BigDecimal orderAchievementRate;

    @ApiModelProperty(value = "收获达成率")
    private BigDecimal deliveryAchievementRate;

    @ApiModelProperty(value = "付款达成率")
    private BigDecimal payAchievementRate;

    @ApiModelProperty(value = "合同来源")
    private String contractSource;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("创建人ID")
    private Long createUserId;

    @ApiModelProperty("是否确认")
    private boolean isConfirm;

    @ApiModelProperty("附件")
    private String fileCodes;

    @ApiModelProperty("关联订单号")
    private String relateDocNo;

    @ApiModelProperty("取价方式")
    private String pricingMethod;

    @ApiModelProperty("是否委外")
    private String outIng;

    @ApiModelProperty("期初订单达成金额")
    private BigDecimal initialOrderAmt;

    @ApiModelProperty("期初入库达成金额")
    private BigDecimal initialWarehousingAmt;

    @ApiModelProperty("期初付款达成金额")
    private BigDecimal initialPayAmt;

    @ApiModelProperty("物料明细")
    private List<PurContractItemSaveRpcParam> itemList;

    @ApiModelProperty("补充协议标记")
    private Boolean flag;



    // 基本信息添加的属性
    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty(value = "合作形式")
    private String cooperationType;

    // 交付约定
    @ApiModelProperty(value = "交货方式")
    private String deliveryMethod;

    @ApiModelProperty(value = "交货期限")
    private String deliveryDeadline;


    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp",mod = "TP_TYPE")
    private String transType;
    private String transTypeName;

    @ApiModelProperty(value = "运费承担方")
    private String freightPayer;

    @ApiModelProperty(value = "交货地点")
    private String deliveryLocation;

    // 验收约定
    @ApiModelProperty(value = "验收期限（天）")
    private Integer acceptanceTerm;

    @ApiModelProperty(value = "调整换货期限（天）")
    private Integer exchangeTerm;

    @ApiModelProperty(value = "验收不合格处理方式")
    private String unqualifiedHandling;

    @ApiModelProperty(value = "隐藏缺陷发现期限（天）")
    private Integer hiddenDefectTerm;

    @ApiModelProperty(value = "验收质量标准")
    private String acceptanceStandard;



    @ApiModelProperty(value = "付款方式")
    private String paymentMethod;
    @ApiModelProperty(value = "付款期限（天）")
    private Integer payTerm;
    @ApiModelProperty(value = "预付款比例（%）")
    private BigDecimal prepaymentRatio;
    @ApiModelProperty("开票期限")
    private Integer invoiceTerm;
}
