package com.elitesland.pur.dto.account;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/07/31
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purAccountCheckDtlRpcDTO", description = "采购对账单明细表")
public class PurAccountCheckDtlRpcDTO extends BaseModelMedOrderDVO implements Serializable {
    @Serial
    private static final long serialVersionUID = 560084368657998263L;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("业务单据ID")
    private Long billId;
    @ApiModelProperty("业务单据明细ID")
    private Long billDId;

    @ApiModelProperty("对账单行号")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "预付款分摊金额")
    private BigDecimal prepaymentAmt;
    @ApiModelProperty(value = "已付款金额")
    private BigDecimal paymentAmt;
    @ApiModelProperty(value = "付款申请在途金额")
    private BigDecimal payingAmt;
    @ApiModelProperty(value = "未付款金额")
    private BigDecimal unpayAmt;

    @ApiModelProperty("商品ID")
    private Long itemId;
    @ApiModelProperty("品项规格")
    private String itemSpec;

    @ApiModelProperty("仓库ID")
    private Long whId;
    @ApiModelProperty("仓库编码")
    private String whCode;
    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("对账数量")
    private BigDecimal qty;
    @ApiModelProperty("基本单位对账数量")
    private BigDecimal qty2;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("单位2")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("税率(调整前)")
    private BigDecimal oldTaxRate;

    @ApiModelProperty("本币含税单价(调整前)")
    private BigDecimal originCurrPrice;
    @ApiModelProperty("本币不含税单价(调整前)")
    private BigDecimal originCurrNetPrice;

    @ApiModelProperty("本币含税金额(调整前)")
    private BigDecimal originCurrAmt;
    @ApiModelProperty("本币不含税金额(调整前)")
    private BigDecimal originCurrNetAmt;
    @ApiModelProperty("税额(调整前)")
    private BigDecimal originTaxAmt;

    @ApiModelProperty("税率(调整后)")
    private BigDecimal taxRate;

    @ApiModelProperty("本币含税单价(调整后)")
    private BigDecimal currNetPrice;
    @ApiModelProperty("本币不含税单价(调整后)")
    private BigDecimal currPrice;
    @ApiModelProperty("不含税价格(调整后)")
    private BigDecimal netPrice;
    @ApiModelProperty("含税单价(调整后)")
    private BigDecimal price;

    @ApiModelProperty("含税金额(调整后)")
    private BigDecimal amt;
    @ApiModelProperty("不含税金额(调整后)")
    private BigDecimal netAmt;
    @ApiModelProperty("本币含税金额(调整后)")
    private BigDecimal currAmt;
    @ApiModelProperty("本币不含税金额(调整后)")
    private BigDecimal currNetAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;
    @ApiModelProperty("价格本币种")
    private String pbCurr;
    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;
    @ApiModelProperty("单据日期")
    private LocalDateTime relateDocDate;
    @ApiModelProperty("收发货单编码")
    private String relateDocNo;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    @ApiModelProperty("收发货单行号")
    private BigDecimal relateDocLine;

    @ApiModelProperty("关联单据类别2")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    private String relateDoc2ClsName;
    @ApiModelProperty("订/退单编码")
    private String relateDoc2No;
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据明细2ID")
    private Long relateDoc2Did;
    @ApiModelProperty("订/退单行号")
    private BigDecimal relateDoc2Line;

    @ApiModelProperty("对账单编号")
    private String docNo;
    @ApiModelProperty("对账日期")
    private LocalDateTime docDate;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("付款协议名称")
    private String protocolName;
}
