package com.elitesland.pur.dto.po;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 付款单支付回调参数.
 *
 * @author Kaiser（wang shao）
 * @date 2025/12/6 周六
 */
@Getter
@Setter
public class PurPayOrderPaidDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = 6107923867226223167L;

    @ApiModelProperty(value = "付款单ID", required = true)
    private Long payOrderId;
    @ApiModelProperty(value = "付款单编号", required = true)
    private String payOrderNo;

    @ApiModelProperty(value = "来源单编号")
    private String sourceNo;

    @ApiModelProperty(value = "付款金额", required = true)
    private BigDecimal amtTotal;

    @ApiModelProperty(value = "付款时间", required = true)
    private LocalDateTime paidTime;

    @ApiModelProperty(value = "付款单明细列表", required = true)
    private List<PaidDetail> detailList;

    @Getter
    @Setter
    public static class PaidDetail implements Serializable {
        @Serial
        private static final long serialVersionUID = -2113246577547883773L;

        @ApiModelProperty(value = "付款单明细ID", required = true)
        private Long payOrderDetailId;

        @ApiModelProperty(value = "关联单据ID", required = true)
        private Long relateDocId;
        @ApiModelProperty(value = "关联单据明细ID", required = true)
        private Long relateDocDid;

        @ApiModelProperty(value = "付款金额", required = true)
        private BigDecimal amt;

        @ApiModelProperty(value = "付款明细数量")
        private BigDecimal qty;
        @ApiModelProperty(value = "付款明细基本单位数量")
        private BigDecimal qty2;
    }
}
