package com.elitesland.pur.config;

import com.elitesland.pur.common.inter.PurPushRecordRepository;
import com.elitesland.pur.common.inter.bip.PurBipPushClient;
import com.elitesland.pur.common.inter.impl.NoopPurBipPushClient;
import com.elitesland.pur.common.inter.impl.NoopPurRetryRecordRepository;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/22 周二
 */
@AutoConfiguration
class PurApiAutoConfiguration {

    @ConditionalOnMissingBean(PurBipPushClient.class)
    @Bean
    public PurBipPushClient noopPurBipPushClient() {
        return new NoopPurBipPushClient();
    }

    @ConditionalOnMissingBean(PurPushRecordRepository.class)
    @Bean
    public PurPushRecordRepository noopPurPushRecordRepository() {
        return new NoopPurRetryRecordRepository();
    }
}
