package com.elitesland.pur.dto.po;

import com.el.coordinator.core.common.jpa.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 甲指乙采类 门店订货 输入的地址
 */
@Data
@ApiModel(value = "商品列表查询入参")
public class AddrDTO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -8387700128516698775L;
    /**
     * 甲指乙采进入报货列表，输入收货地址
     */
    @ApiModelProperty("国家")
    private String country;
    private String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区县")
    private String county;
    private String countyName;

    @ApiModelProperty("详细地址")
    private String detailAddr;

    @ApiModelProperty("联系人")
    private String contPerson;

    @ApiModelProperty("联系人电话")
    private String tel;
}