package com.elitesland.pur.dto.gr;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(description = "采购出/入库单明细成本")
public class PurGrDetailCostRpcDTO implements Serializable {

    private static final long serialVersionUID = 4487416482441963319L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购出/入库单明细ID")
    @NotNull(message = "采购出/入库单明细ID不能为空")
    private Long id;

    @ApiModelProperty("商品id")
    @NotNull(message = "商品id不能为空")
    private Long itemId;

    @ApiModelProperty("单位")
    @NotNull(message = "单位不能为空")
    private String uom;

    @ApiModelProperty("单位成本")
    @NotNull(message = "单位成本不能为空")
    private BigDecimal costPrice;

    @ApiModelProperty("成本总价")
    private BigDecimal costAmt;

}