package com.elitesland.pur.dto.gr;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "采购收货单")
public class PurGrRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("地址号")
    private Long addrNo;

    @ApiModelProperty("承运商编码")
    private String carrierCode;

    @ApiModelProperty("承运商名称")
    private String carrier;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("收货仓库")
    private Long toWhId;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("发货供应商")
    private Long suppId;

    @ApiModelProperty("发货供应商")
    private String suppCode;

    @ApiModelProperty("发货供应商")
    private String suppName;

    @ApiModelProperty("状态")
    private String docStatus;

    @ApiModelProperty("采购订单ID")
    private Long relateDocId;

    @ApiModelProperty("采购订单类别")
    private String relateDocCls;

    @ApiModelProperty("收货地址国家")
    private String country;

    @ApiModelProperty("收货地址省")
    private String province;

    @ApiModelProperty("收货地址市")
    private String city;

    @ApiModelProperty("收货地址区县")
    private String county;

    @ApiModelProperty("地址")
    private String detailAddr;

    @ApiModelProperty("报货单Id")
    private  Long rootDocId;

    @ApiModelProperty("报货单编号")
    private String rootDocNo;

    @ApiModelProperty("报货类别 [UDC]SUPP:DOC_CLS")
    private String rootDocCls;

    @ApiModelProperty("赔付类型")
    private String refundType;

    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;

    private List<PurGrDetailRpcDTO> rpcDTOS;
}