package com.elitesland.pur.dto.supp;

import com.elitesland.pur.base.BaseModelParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/9/20 11:24
 * @Description:
 */
@Data
public class PurSuppRpcParam extends BaseModelParam implements Serializable {

    @ApiModelProperty("供应商编码")
    private String suppCode;
    @ApiModelProperty("企业(供应商)名称")
    private String suppName;
    @ApiModelProperty("企业(供应商)简称")
    private String suppAbbr;
    @ApiModelProperty("供应商类型 [UDC]PUR:SUPP_TYPE")
    private String suppType;
    @ApiModelProperty("供应商类型2 [UDC]PUR:SUPP_TYPE2")
    private String suppType2;
    @ApiModelProperty("供应商状态 [UDC]PUR:SUPP_STATUS")
    private String suppStatus;
    @ApiModelProperty("供应商(企业)性质 [UDC]PUR:COMP_PROP")
    private String compProp;
    @ApiModelProperty("行业类型 [UDC]PUR:INDUS_FLAG")
    private String indusFlag1;
    @ApiModelProperty("注册资金")
    private String registerFund;
    @ApiModelProperty("注册地址")
    private String registerAddress;
    @ApiModelProperty("公司注册日期")
    private LocalDateTime registerDate;
    @ApiModelProperty("内部交易公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId2;
    @ApiModelProperty("内部交易公司编码")
    private String ouCode2;
    @ApiModelProperty("内部交易公司名称")
    private String ouName2;
    @ApiModelProperty("法人姓名(代表)")
    private String reprName;
    @ApiModelProperty("税务登记证编号")
    private String taxRegNo;
    @ApiModelProperty("纳税人识别号")
    private String taxPayerId;
    @ApiModelProperty("统一信用代码")
    private String certNo;
    @ApiModelProperty("公司总人数")
    private Integer totalStaff;
    @ApiModelProperty("公司网站")
    private String webAddress;
    @ApiModelProperty("邮编")
    private String zipCode;
    @ApiModelProperty("ERP供应商编码")
    private String erpSuppCode;
    @ApiModelProperty("商城入驻时间")
    private LocalDateTime mallSettlementTime;
    @ApiModelProperty("法人手机号")
    private String legalPersonPhone;
    @ApiModelProperty("法人邮箱")
    private String legalPersonMailbox;
    @ApiModelProperty("法人证件类型 [UDC]PUR:CERTIFICATE_TYPE")
    private String certificateType;
    @ApiModelProperty("法人证件编码")
    private String certificateCode;
    @ApiModelProperty("主营品类 [UDC]PUR:MAIN_CATEGORY")
    private String mainCategory;
    @ApiModelProperty("厂房性质 [UDC]PUR:PLANT_NATURE")
    private String plantNature;
    @ApiModelProperty("厂房面积")
    private BigDecimal plantArea;
    @ApiModelProperty("工厂员工数")
    private Integer factoryEmployeesNumber;
    @ApiModelProperty("开发技术人数")
    private Integer technologyPeopleNumber;
    @ApiModelProperty("品质检验人数")
    private Integer qualityInspectionNumber;
    @ApiModelProperty("认证体系 [UDC]PUR:CERTIFICATION_SYSTEM")
    private String certificationSystem;
    @ApiModelProperty("产品执行标准")
    private String productPerformanceStandards;
    @ApiModelProperty("质量检验")
    private String qualityInspection;
    @ApiModelProperty("检验范围")
    private String inspectionScope;
    @ApiModelProperty("供货质量记录")
    private String deliveryQualityRecord;
    @ApiModelProperty("主要生产设备")
    private String mainProductionEquipment;
    @ApiModelProperty("经营范围")
    private String businessScope;
    @ApiModelProperty("企业简介")
    private String companyProfile;
    @ApiModelProperty("付款条款")
    private String paymentTerm;
    private String paymentTermName;
    @ApiModelProperty("付款方式 [UDC]PUR:PAY_TYPE")
    private String payMethod;
    private String payMethodName;
    @ApiModelProperty("默认发票类型 [UDC]COM:INV_TYPE")
    private String invType;
    private String invTypeName;
    @ApiModelProperty("税率编码")
    private String taxRateNo;
    @ApiModelProperty("税率名称")
    private String taxRateDesc;
    @ApiModelProperty("税率值")
    private BigDecimal taxRateValue;
    @ApiModelProperty("纳税人类型 [UDC]ORG:PAYER_TYPE")
    private String taxPayerType;
    private String taxPayerTypeName;
    @ApiModelProperty("公司ID(来源公司)")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("单据编号")
    private String docNo;
    @ApiModelProperty("单据类型 [UDC]COM:APPLY_TYPE")
    private String docType;
    @ApiModelProperty("单据状态 [UDC]COM:APPLY_STATUS")
    private String docStatus;
    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;
    @ApiModelProperty("审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;
    @ApiModelProperty("申请人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;
    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;
    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;
    @ApiModelProperty("实缴资金")
    private String paidMoney;
    @ApiModelProperty("公司邮箱")
    private String registerMail;
    @ApiModelProperty("主营品类简介")
    private String categoryDescription;
    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("(基本信息 部分)地址号申请的具体地址信息")
    private List<PurAddrApplyAddressRpcSaveVO> addressSaveVOList;

    @ApiModelProperty("(证照信息）地址号申请的资质信息")
    private List<PurAddrApplyQualifyRpcSaveVO> qualifySaveVOList;

    @ApiModelProperty("(账户信息)地址号申请的银行账号")
    private List<PurAddrApplyBankAccRpcSaveVO> bankAccSaveVOList;

    @ApiModelProperty("文件")
    private String fileCode;

    @ApiModelProperty(value = "是否免检，true：免检，false：需要质检")
    Boolean qt;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;

    @ApiModelProperty("付款协议名称")
    private String protocolName;

    @ApiModelProperty("内外部 [UDC]PUR:IO_TYPE")
    private String ioType;

    @ApiModelProperty("批号前缀 [UDC]INV:LOT_MANU_FACTORY")
    private String lotNoPrefix;
}
