package com.elitesland.pur.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:品项采购价格
 * </p>
 *
 * @Author Darren
 * @Version 1.0
 * @Content:
 * @Date 2021/02/24
 */
@Data
@ApiModel(value = "purPurcPriceRespVO", description = "品项采购价格")
public class PurPurcPriceRpcDTO implements Serializable {

    private static final long serialVersionUID = -7088824509020545241L;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编号")
    private String ouCode;
    /**
     * BUID
     */
    @ApiModelProperty("组织中心(BU)ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    @ApiModelProperty("组织中心(BU)名称")
    private String buName;
    @ApiModelProperty("组织中心(BU)编码")
    private String buCode;
    /**
     * 事业部ID
     */
    @ApiModelProperty("事业部ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long bdId;
    private String bdName;
    /**
     * 价格编号
     */
    @ApiModelProperty("价格编号")
    private String priceNo;
    /**
     * 价格类型
     */
    @ApiModelProperty("价格类型")
    @SysCode(sys = "yst-purc", mod = "PUR_PRICE_TYPE")
    private String priceType;
    @ApiModelProperty("价格类型名称")
    private String priceTypeName;
    /**
     * 价格类型2
     */
    @ApiModelProperty("价格类型2")
    private String priceType2;
    /**
     * 价格类型3
     */
    @ApiModelProperty("价格类型3")
    private String priceType3;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    @ApiModelProperty("品项名称")
    String itemName;
    @ApiModelProperty("品项编号")
    String itemCode;
    @ApiModelProperty("规格型号")
    private String spec;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;
    @ApiModelProperty("品牌名称")
    String brandName;
    String agencyName;
    String agencyCode;
    @ApiModelProperty("品牌简称")
    String abbrName;
    @ApiModelProperty("品牌负责人")
    @JsonSerialize(using = ToStringSerializer.class)
    Long managerEmpId;
    @ApiModelProperty("品牌负责人名称")
    String managerEmpName;
    /**
     * 品牌2
     */
    @ApiModelProperty("品牌2")
    private String itemBrand2;
    /**
     * 非品项价格对象类型
     */
    @ApiModelProperty("非品项价格对象类型")
    private String nonitemType;
    /**
     * 非品项价格对象编号
     */
    @ApiModelProperty("非品项价格对象编号")
    private String nonitemCode;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;
    /**
     * 供应商简称
     */
    @ApiModelProperty("供应商简称")
    private String suppAbbr;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;
    /**
     * 采购区域
     */
    @ApiModelProperty("采购区域")
    private String region;
    /**
     * 价格组
     */
    @ApiModelProperty("价格组")
    private String priceGroup;
    /**
     * 配送地址号
     */
    @ApiModelProperty("配送地址号")
    private Integer shiptoAddrNo;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 从数量
     */
    @ApiModelProperty("从数量")
    private BigDecimal fromQty;
    /**
     * 到数量
     */
    @ApiModelProperty("到数量")
    private BigDecimal toQty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    @ApiModelProperty("单位名称")
    String uomName;

    /**
     * 不含税单价
     */
    @ApiModelProperty("不含税单价")
    private BigDecimal netPrice;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private Double taxRate;

    @ApiModelProperty("税率说明")
    private String taxRateDesc;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    /**
     * 含运费含税价格
     */
    @ApiModelProperty("含运费含税价格")
    private BigDecimal freightTaxPrice;
    /**
     * 含运费净价
     */
    @ApiModelProperty("含运费净价")
    private BigDecimal freightNetPrice;
    /**
     * 运费
     */
    @ApiModelProperty("运费")
    private BigDecimal freightPrice;
    /**
     * 费用1描述
     */
    @ApiModelProperty("费用1描述")
    private String fee1Desc;
    /**
     * 费用1
     */
    @ApiModelProperty("费用1")
    private BigDecimal fee1;
    /**
     * 费用2描述
     */
    @ApiModelProperty("费用2描述")
    private String fee2Desc;
    /**
     * 费用2
     */
    @ApiModelProperty("费用2")
    private BigDecimal fee2;
    /**
     * 费用3描述
     */
    @ApiModelProperty("费用3描述")
    private String fee3Desc;
    /**
     * 费用3
     */
    @ApiModelProperty("费用3")
    private BigDecimal fee3;
    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    private Double discRatio;
    /**
     * 总价
     */
    @ApiModelProperty("总价")
    private BigDecimal totalPrice;
    /**
     * 运费单位
     */
    @ApiModelProperty("运费单位")
    private String freightUom;
    /**
     * 辅助价格1
     */
    @ApiModelProperty("辅助价格1")
    private BigDecimal ePrice1;
    /**
     * 辅助价格2
     */
    @ApiModelProperty("辅助价格2")
    private BigDecimal ePrice2;
    /**
     * 辅助价格3
     */
    @ApiModelProperty("辅助价格3")
    private BigDecimal ePrice3;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("币种名称")
    String currCodeName;
    /**
     * 定价时间
     */
    @ApiModelProperty("定价时间")

    private LocalDateTime priceDate;
    /**
     * 生效时间
     */
    @ApiModelProperty("生效时间")

    private LocalDateTime validFrom;
    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")

    private LocalDateTime validTo;
    /**
     * 期间ID
     */
    @ApiModelProperty("期间ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long periodId;
    /**
     * 相关ID1 促销活动等
     */
    @ApiModelProperty("相关ID1 促销活动等")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId1;
    /**
     * 相关ID2
     */
    @ApiModelProperty("相关ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId2;
    /**
     * 相关ID3
     */
    @ApiModelProperty("相关ID3")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId3;
    /**
     * 实际采购量
     */
    @ApiModelProperty("实际采购量")
    private Double buyedQty;
    /**
     * 价格涨跌幅
     */
    @ApiModelProperty("价格涨跌幅")
    private Double priceDelta;
    /**
     * 价格状态
     */
    @ApiModelProperty("价格状态")
    @SysCode(sys = "yst-supp", mod = "STATUS_ACTIVEORNO")
    private String priceStatus;
    @ApiModelProperty("价格状态名称")
    String priceStatusName;
    /**
     * 价格来源
     */
    @ApiModelProperty("价格来源")
    private String priceSource;
    /**
     * 来源单据类别
     */
    @ApiModelProperty("来源单据类别")
    private String srcDocCls;
    /**
     * 来源单据ID
     */
    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;
    /**
     * 来源单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String srcDocNo;
    /**
     * 来源单据明细ID
     */
    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDId;
    /**
     * 来源单据类别2
     */
    @ApiModelProperty("来源单据类别2")
    private String srcDocCls2;
    /**
     * 来源单据ID2
     */
    @ApiModelProperty("来源单据ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId2;
    /**
     * 来源单据编号2
     */
    @ApiModelProperty("来源单据编号2")
    private String srcDocNo2;
    /**
     * 来源单据明细ID2
     */
    @ApiModelProperty("来源单据明细ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDId2;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;
    /**
     * EN1
     */
    @ApiModelProperty("EN1")
    private Double en1;
    /**
     * EN2
     */
    @ApiModelProperty("EN2")
    private Double en2;
    /**
     * EN3
     */
    @ApiModelProperty("EN3")
    private Double en3;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    private Long uuid;
}
