package com.elitesland.pur.provider;

import com.elitesland.pur.Application;
import com.elitesland.pur.dto.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/22
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurPriceProvider.PATH)
public interface PurPriceProvider {
    String PATH = "/purPrice";
    /**
     * 根据获取采购价格DTO入参查询采购价格
     *
     * @param param 获取采购价格DTO入参
     * @return 采购价格
     */
    @GetMapping("/getPrice")
    ApiResult<PurPriceBaseDTO> getPriceByParam(@RequestBody @Valid PurPriceParamDTO param);

    /**
     * 批量查询采购价格
     *
     * @param priceBatchParam 批量获取采购价格DTO入参
     * @return 采购价格
     */
    @GetMapping("/getPriceList")
    ApiResult<List<PurPriceBaseDTO>> getPriceListByParam(@RequestBody @Valid PurPriceBatchParamDTO priceBatchParam);

    /**
     * 查询有价商品-提供给基础域
     * 1.外部价：返回采购价格的商品ids
     * 2.内部价：返回供应商对应的内部公司编码，公司对应的客户编码
     *
     * @param param 查询有价商品参数
     * @return 有价商品
     */
    @GetMapping("/getPriceItems")
    ApiResult<PurPriceItemDTO> getPriceItems(@RequestBody @Valid PurPriceItemParamDTO param);

    /**
     * 查询商品采购价格
     *
     * @param param 商品信息
     * @return 商品价格
     */
    @GetMapping("/getItemPurPrice")
    ApiResult<List<PurPurcPriceRpcDTO>> getItemPurPrice(@RequestBody @Valid List<PurPriceParamRpcDTO> param);

}
