package com.elitesland.pur.dto.ss;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.pur.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-08-03 10:59:49
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "pur_ss_d", description = "供应商发货单明细")
public class PurSsDRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -32641534531217458L;

    /**
     * 主表ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主表ID")
    private Long masId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private Double lineNo;
    /**
     * 采购订单明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购订单明细ID")
    private Long poDId;
    /**
     * 品项ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("品项ID")
    private Long itemId;
    private String itemCode;
    private String itemName;
    private String itemSpec;
    /**
     * 异构ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("异构ID")
    private Long variId;
    /**
     * 仓库ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    private Long whId;
    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;
    @ApiModelProperty("温层名称")
    private String deter1Name;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    @ApiModelProperty("功能区名称")
    private String deter2Name;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 发货数量
     */
    @ApiModelProperty("发货数量")
    private Double qty;

    @ApiModelProperty("拒收数量")
    private BigDecimal rejectedQty;

    @ApiModelProperty("采购订单已拒收数量")
    private BigDecimal poRejectedQty;

    @ApiModelProperty("采购订单已取消数量")
    private Double canceledQty;


    @ApiModelProperty("采购订单订货数量")
    private Double poQty;

    @ApiModelProperty("供应商发货单已收数量")
    private Double acceptQty;

    @ApiModelProperty("采购订单已收数量")
    private Double poAcceptQty;

    @ApiModelProperty("收货单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String acceptUom;
    private String acceptUomName;

    @ApiModelProperty("采购订单已出库数量")
    private Double shippedQty;
    /**
     * 实际未发货数量
     */
    @ApiModelProperty("实际未发数量")
    private Double acUnshipQty;

    /**
     * 实际未收数量
     */
    @ApiModelProperty("实际未收数量")
    private Double unRecpQty;

    /**
     * 发货单位
     */
    @ApiModelProperty("发货单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipmentUom;
    private String shipmentUomName;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;
    /**
     * 发货数量2
     */
    @ApiModelProperty("发货数量2")
    private Double qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private Double uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;
    /**
     * 发货批次
     */
    @ApiModelProperty("发货批次")
    private String lotNo;
    /**
     * 生产批次
     */
    @ApiModelProperty("生产批次")
    private String menuLotNo;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    /**
     * 过期日期
     */
    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;
    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 剩余效期天数
     */
    @ApiModelProperty("剩余效期天数")
    private Integer untilExpireDays;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private Double demandFreshPercent;
    /**
     * 最低允收期天数
     */
    @ApiModelProperty("最低允收期天数")
    private Integer demandAapDays;
    /**
     * 预计到货时效期天数
     */
    @ApiModelProperty("预计到货时效期天数")
    private Integer etaAapDays;
    /**
     * 是否新鲜度合格
     */
    @ApiModelProperty("是否新鲜度合格")
    private Integer isFressValid;

    @ApiModelProperty("到货保质期比例")
    private Double actualFreshPercent;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 根ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("根ID")
    private Long rootId;

    @ApiModelProperty("来源单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDid;

    @ApiModelProperty("来源单据明细行号")
    private Double rootDocLineno;


    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("分子公司功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String rootDocDeter2;
    @ApiModelProperty("分子公司功能区名称")
    private String rootDocDeter2Name;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类别名称")
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private Double relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类别名称")
    private String relateDoc2ClsName;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private Double relateDoc2Lineno;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long outerId;

    @ApiModelProperty("外部单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long outerDid;

    @ApiModelProperty("外部单据行号")
    private Double outerLineno;


    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    @ApiModelProperty("基准日期")
    private LocalDateTime aapDate;

    @ApiModelProperty("品牌code")
    private String dbrand;


    @ApiModelProperty("基价")
    private BigDecimal basePrice;;

    @ApiModelProperty("价格类型")
    private String priceType;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("折扣类型")
    private String discType;

    @ApiModelProperty("折扣率")
    private Double discRatio;

    @ApiModelProperty("折扣额")
    private BigDecimal discAmt;

    @ApiModelProperty("折扣描述")
    private String discDesc;

    @ApiModelProperty("折扣后价格")
    private BigDecimal discedPrice;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private Double taxRate;

    @ApiModelProperty("外币含不税单价")
    private BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    private BigDecimal currPrice;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private Double currRate;

    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    /**
     * 商品是否启用批次
     */
    @ApiModelProperty("商品是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("是否供应商仓库")
    private Integer isSuppWh;

    @ApiModelProperty("是否越库供应商仓库标志")
    private Integer isCrossFlagSuppWh;

    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;





}
