package com.elitesland.pur.dto.file;


import com.elitesland.pur.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author tina.he
 * @since 2020/6/16
 */
@Data
@ApiModel(value = "com_file", description = "文件上传日志表")
public class ComFileDTO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -1511065033699247029L;

    @ApiModelProperty("文件原名称")
    private String originalName;

    @ApiModelProperty("文件上传名称")
    private String uploadName;

    @ApiModelProperty("文件地址")
    private String filePath;

    @ApiModelProperty("文件大小")
    private Long fileSize;

    @ApiModelProperty("后缀名")
    private String suffix;

    @ApiModelProperty("文件类型")
    private String mimeType;

    @ApiModelProperty("文件编码")
    private String fileCode;

    @ApiModelProperty("访问路径")
    private String fileUrl;

    @ApiModelProperty("缩略图文件编码")
    private String thumbnailFileCode;

    @ApiModelProperty("缩略图文件地址")
    private String thumbnailFilePath;

    @ApiModelProperty("缩略图文件下载路径")
    private String thumbnailFileUrl;


}
