package com.elitesland.pur.dto.ss;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "PurSsQtRpcParamDto", description = "供应商发货单质检确认参数")
public class PurSsQtRpcParamDto implements Serializable {
    private static final long serialVersionUID = -1288939798948998849L;

    @ApiModelProperty("单据ID")
    @NotNull(message = "供应商发货单ID不能为空")
    private Long id;

    @ApiModelProperty("单据ID")
    @NotNull(message = "供应商发货单明细不能为空")
    private List<PurSsQtDRpcParamDto> ssQtDRpcParamDtoList;

    @Data
    public static class PurSsQtDRpcParamDto implements Serializable {
        @ApiModelProperty("明细id")
        @NotNull(message = "供应商发货单明细ID不能为空")
        private Long id;

        @ApiModelProperty("合格数量")
        private BigDecimal okQty;

        @ApiModelProperty("不合格数量")
        private BigDecimal noQty;
    }
}
