package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.ss.PurSsDTO;
import com.elitesland.pur.dto.ss.PurSsQtRpcParamDto;
import com.elitesland.pur.dto.supp.PurSceneDTO;
import com.elitesland.pur.dto.supp.PurSceneParamVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurSsProvider.PATH)
public interface PurSsProvider {
    String PATH = "/purSs";

    @PostMapping("/updateCarrierInfo")
    ApiResult<Void> updateCarrierInfo(@RequestBody PurSsDTO param);

    @PostMapping("/updateIsCarrige")
    ApiResult<Void> updateIsCarrige(@RequestBody PurSsDTO param);

    @PostMapping("/confirmByInvQt")
    ApiResult<String> confirmByInvQt(@RequestBody @Valid PurSsQtRpcParamDto param);

}
